/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaExtendTools;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractSnapshotsPropareAction
extends AbstractBaseProtectExtendAction {
    private static Log logger = LogFactory.getInstance(AbstractSnapshotsPropareAction.class);
    private static final String RETRY_SWITCH_KEY = "BaseSanSnapshotPrepareAction.retry.switch";
    private static final String RETRY_TIMES_KEY = "BaseSanSnapshotPrepareAction.retry.times";
    private static final String RETRY_TIME_INTERVAL_KEY = "BaseSanSnapshotPrepareAction.retry.timeInterval";
    private static final boolean INIT_RETRY_SWITCH = true;
    private static final long INIT_RETRY_TIMES = 10L;
    private static final long INIT_RETRY_TIME_INTERVAL = 6L;
    private static final Set<Long> RETRY_ERROR_CODES = new HashSet<Long>(Arrays.asList(1073948248L));
    private ProtectGroup protectGroup = null;

    public void preExcute(ActionContext context) {
        this.protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        String paramId = "";
        List<Integer> doubleLocationTypes = Arrays.asList(19, 30, 31, 32);
        if (PolicyTemplateType.PolicyTemplateE.ARRAY_SNAPSHOT.getValue() == this.protectGroup.getTemplate().getType()) {
            paramId = this.protectGroup.getProductSiteId();
        } else if (doubleLocationTypes.contains(this.protectGroup.getTemplate().getType())) {
            paramId = this.getExcuteSiteId(context);
        }
        this.setNameParams(((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(paramId).getName());
    }

    protected boolean getProtectGroupReplica(ActionContext context) {
        boolean hasActiveOldRep;
        ProtectGroupReplica oldReplica = this.getToActiveReplicas(context);
        IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(this.protectGroup.getPoType());
        boolean isNeedReactiveReplica = provider.isNeedReActiveReplica(this.protectGroup);
        if (null != oldReplica && isNeedReactiveReplica) {
            hasActiveOldRep = true;
            context.addObject("PG_REPLICA_ENTITY", (Object)oldReplica);
        } else {
            hasActiveOldRep = false;
            if (!isNeedReactiveReplica) {
                context.addObject("PROTECTGROUP_REPLICA_TO_DELETE", (Object)oldReplica);
            }
            ProtectGroupReplica newReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(this.protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
            context.addObject("PG_REPLICA_ENTITY", (Object)newReplica);
        }
        return hasActiveOldRep;
    }

    protected ProtectGroupReplica getToActiveReplicas(ActionContext context) {
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY");
        List list = ((IReplicaRetentionStrategyManager)ServiceLocator.getInstance().getService(IReplicaRetentionStrategyManager.class)).getToReactivateReplicas(this.protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue(), Integer.valueOf(-1), Integer.valueOf(task.getSchedule().getProtectedType()));
        ProtectGroupReplica protectGroupReplica = null;
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (ProtectGroupReplica replica : list) {
                if (!CheckReplicaExtendTools.checkSnapshotCorrect(replica, true)) {
                    CheckReplicaTools.updateProtectGroupReplicaStatus((String)replica.getId(), (int)DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
                    continue;
                }
                if (3 == replica.getStatus()) continue;
                protectGroupReplica = replica;
                break;
            }
        }
        if (null != protectGroupReplica && !this.isProtectGroupReplicaSame(context, protectGroupReplica)) {
            logger.error((Object)"RelicaStorageInfo of ProtectGroupReplica has changed.");
            CheckReplicaTools.updateProtectGroupReplicaStatus((String)protectGroupReplica.getId(), (int)DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
            return null;
        }
        return protectGroupReplica;
    }

    private boolean isProtectGroupReplicaSame(ActionContext context, ProtectGroupReplica replica) {
        Set<String> newResourceSet;
        ProtectGroupReplica newPgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(this.protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
        if (VerifyUtil.isEmpty((Object)newPgReplica)) {
            return false;
        }
        Set<String> oldResourceSet = this.getStorageResourceList(replica);
        return oldResourceSet.containsAll(newResourceSet = this.getStorageResourceList(newPgReplica)) && newResourceSet.containsAll(oldResourceSet);
    }

    private Set<String> getStorageResourceList(ProtectGroupReplica replica) {
        HashSet<String> set = new HashSet<String>();
        Set protectObjectReplicas = replica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)protectObjectReplicas)) {
            return set;
        }
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
                set.add(storageInfo.getStorageProviderSN() + ":" + storageInfo.getSrcStorageId());
            }
        }
        return set;
    }

    private String getExcuteSiteId(ActionContext context) {
        Schedule schedule;
        String siteId = "";
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY");
        if (task != null && (schedule = task.getSchedule()) != null) {
            siteId = schedule.getSourceSiteId();
        }
        return siteId;
    }

    protected boolean prepare(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        if (DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() != pg.getStatus()) {
            logger.error((Object)"pg'status is not Running.", 90160758786989L);
            this.setDetail("lego.err.1073948458");
            return false;
        }
        HashSet pos = new HashSet();
        pos.addAll(pg.getPolist());
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY");
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            logger.error((Object)"replica not found.", 90160758786989L);
            this.setDetail("lego.err.1073948459");
            return false;
        }
        HashSet poReplicas = new HashSet();
        poReplicas.addAll(pgReplica.getReplicas());
        context.addObject("PO_ENTITY", pos);
        context.addObject("PO_REPLICA_ENTITY", poReplicas);
        logger.info((Object)("BaseSanSnapPrepareAction prepare end to execute:" + pg.getName()), 90160758786988L);
        return true;
    }

    protected boolean checkGroup(ActionContext context) {
        ProtectionJobExtendUtil jobUtil = ProtectionJobExtendUtil.getInstance();
        long retryTimes = this.getRetryTimes();
        while (true) {
            try {
                ProtectionJobUtil.getInstance().checkHyperMetro(this.protectGroup, context);
                jobUtil.checkLunPairStatus(this.protectGroup);
                jobUtil.checkReplicationPair(this.protectGroup, context);
                return true;
            }
            catch (LegoCheckedException e) {
                if (!this.getRetrySwitch() || !RETRY_ERROR_CODES.contains(e.getErrorCode()) || retryTimes <= 0L) {
                    this.setDetail(e.getErrorMessageKey());
                    this.setDetailParams(this.constructParams(e.getParameters()));
                    return false;
                }
                CommonUtil.sleep((long)(this.getRetryTimeInterval() * 1000L));
                if (--retryTimes >= 0L) continue;
                return false;
            }
            break;
        }
    }

    private boolean getRetrySwitch() {
        return "true".equals(LegoConfig.getInstance().getKeyValue(RETRY_SWITCH_KEY, String.valueOf(true)).trim());
    }

    private long getRetryTimes() {
        long retryTimes = LegoConfig.getInstance().getNumber(RETRY_TIMES_KEY, 10L);
        long retryTimeInterval = LegoConfig.getInstance().getNumber(RETRY_TIME_INTERVAL_KEY, 6L);
        if (retryTimeInterval * retryTimes > 86400L) {
            retryTimes = 10L;
            logger.error((Object)"The number of \"retryTimeInterval\" multiplied by the number of \"retryTimes\"cannot be greater than 24 hours.");
        } else if (retryTimes < 0L || retryTimeInterval < 0L) {
            retryTimes = 10L;
            logger.error((Object)"The number of \"retryTimes\" or \"retryTimeInterval\" cannot less than 0 .");
        }
        return retryTimes;
    }

    private long getRetryTimeInterval() {
        long retryTimes = LegoConfig.getInstance().getNumber(RETRY_TIMES_KEY, 10L);
        long retryTimeInterval = LegoConfig.getInstance().getNumber(RETRY_TIME_INTERVAL_KEY, 6L);
        if (retryTimeInterval * retryTimes > 86400L) {
            retryTimeInterval = 6L;
            logger.error((Object)"The number of \"retryTimeInterval\" multiplied by the number of \"retryTimes\"cannot be greater than 24 hours.");
        } else if (retryTimes < 0L || retryTimeInterval < 0L) {
            retryTimeInterval = 6L;
            logger.error((Object)"The number of \"retryTimes\" or \"retryTimeInterval\" cannot less than 0 .");
        }
        return retryTimeInterval;
    }
}

