/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArraySynMonitorSubAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(ArraySynMonitorSubAction.class);
    private static final String SYN_COMPLETE = "com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization.Complete";
    private static final String SYN_GOING_ON = "com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization";
    private static final String SYN_PROGRESS = "com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization.Progress";
    private ReplicationRelationBo rrb;
    private long overTime;

    public ArraySynMonitorSubAction(ReplicationRelationBo rrb, long overTime) {
        this.rrb = rrb;
        this.overTime = overTime;
    }

    public void preExcute(ActionContext context) {
        super.preExcute(context);
        if (this.rrb.isConsistentGroup()) {
            this.setName("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.ReplicationGroup");
        } else {
            this.setName("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Replication");
        }
        this.setNameParams(this.rrb.getReplicationId());
    }

    public boolean doExecute(ActionContext context) {
        if (this.rrb.isConsistentGroup()) {
            return this.monitorArrayReplicationProgress(false, context);
        }
        ArrayList<String> masterLunIds = new ArrayList<String>(this.rrb.getTgtLuns().keySet());
        logger.debug((Object)("all masterLunIds :" + masterLunIds), 90160758786988L);
        List<ReplicationPair> replicationPair = null;
        try {
            replicationPair = this.getPairsByLun(this.rrb.getSrcDeviceSn(), masterLunIds);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("get replication pair failed, deviceSn:" + this.rrb.getSrcDeviceSn() + " luns:" + StringUtil.arrayToStrWithSplit((Object[])masterLunIds.toArray(), (String)";")), (Throwable)e, 90160758784001L);
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("get replication pair failed, deviceSn:" + this.rrb.getSrcDeviceSn() + " luns:" + StringUtil.arrayToStrWithSplit((Object[])masterLunIds.toArray(), (String)";") + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.setDetail("lego.err.-1");
            return false;
        }
        if (!VerifyUtil.isEmpty(replicationPair)) {
            Integer localResType = replicationPair.iterator().next().getLocalResType();
            if (Integer.valueOf(XveMOType.LUN.getValue()).equals(localResType) || null == localResType) {
                return this.monitorArrayReplicationProgress(false, context);
            }
            if (Integer.valueOf(XveMOType.FILESYSTEM.getValue()).equals(localResType)) {
                return this.monitorArrayReplicationProgress(true, context);
            }
            logger.error((Object)("cannot find the device type: localResType" + localResType), 90160758786989L);
            this.setDetail("lego.err.1073948444");
            this.setDetailParams(this.constructParams(new String[]{this.rrb.getSrcDeviceSn()}));
        } else {
            logger.error((Object)("replicationPair is empty, all masterLunIds :" + masterLunIds), 90160758786989L);
            this.setDetail("lego.err.1073947394");
        }
        return false;
    }

    private boolean monitorArrayReplicationProgress(boolean isNas, ActionContext context) {
        while (true) {
            AbstractBaseProtectAction.ReplicationProgress progress;
            if (ProtectionJobUtil.checkWhetherTerminateTask((ActionContext)context)) {
                this.terminateTask();
                return false;
            }
            CommUtil.pauseThread((long)5000L);
            try {
                progress = this.syncProgress(this.rrb);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("Synchronize replication failed. SrcStorageProviderSN:" + this.rrb.getSrcDeviceSn() + ",TgtStorageProviderSN:" + this.rrb.getTgtDeviceSn()), (Throwable)e, 90160758784001L);
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
                return false;
            }
            catch (Exception e) {
                logger.error((Object)("Synchronize replication failed. SrcStorageProviderSN:" + this.rrb.getSrcDeviceSn() + ",TgtStorageProviderSN:" + this.rrb.getTgtDeviceSn() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                this.setDetail("lego.err.1073948448");
                return false;
            }
            if (progress.isCompleted()) {
                logger.info((Object)"Synchronize replication success. ", 90160758784000L);
                this.setDetail(SYN_COMPLETE);
                return true;
            }
            long curTime = System.currentTimeMillis();
            if (curTime > this.overTime) {
                logger.error((Object)"Synchronize replication time out. ", 90160758784001L);
                this.setDetail("lego.err.1073948744");
                return false;
            }
            if (isNas) {
                this.setDetail(SYN_GOING_ON);
                continue;
            }
            this.setDetail(SYN_PROGRESS);
            this.setDetailParams(progress.getProgress() + "%");
        }
    }

    private void terminateTask() {
        try {
            ProtectionJobExtendUtil.terminateTask(this.rrb);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return;
        }
        this.setDetail("lego.err.1073948226");
    }

    private List<ReplicationPair> getPairsByLun(String deviceSn, List<String> masterLunIds) {
        List pairs;
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(deviceSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByLun error, site is null, deviceSN:" + deviceSn), 90160758787071L);
            return null;
        }
        if (1 == site.getSiteType()) {
            HashMap<String, Object> uriVariabels = new HashMap<String, Object>();
            uriVariabels.put("devSn", deviceSn);
            uriVariabels.put("lunIds", StringUtil.arrayToStrWithSplit((Object[])masterLunIds.toArray(), (String)";"));
            uriVariabels.put("isFromDevice", true);
            RestClient client = SiteUtil.initClient((Site)site);
            pairs = client.getForObjects("/ws/storages/{devSn}/action/getReplicationPairBySrcLunIds?lunIds={lunIds}&isFromDevice={isFromDevice}", uriVariabels, ReplicationPair.class);
        } else {
            String srcLunId = null;
            if (!masterLunIds.isEmpty()) {
                srcLunId = (String)masterLunIds.stream().findFirst().get();
            }
            pairs = StorageReplicationManagerProxy.getInstance().queryReplications(deviceSn, srcLunId);
        }
        return pairs;
    }
}

