/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction;
import com.huawei.ism.drm.protection.framework.engine.action.BaseParentAction;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.Date;
import java.util.List;

public class BaseArraySynMonitorAction
extends BaseParentAction {
    private static final long HOUR_2 = LegoConfig.getInstance().getNumber("array.syn.monitor.timeout", 7200L) * 1000L;
    private static final long MINUTE_1 = 60000L;
    private static final long ZERO = 0L;
    private long overTaskTime;

    public void preExcute(ActionContext context) {
        super.preExcute(context);
        Date date = new Date();
        this.overTaskTime = date.getTime() + HOUR_2;
        Long nextTime = NumberUtil.convertToLong((Object)context.getObject("PG_NEXT_FIRE_TIME"), (long)0L);
        if (!nextTime.equals(NumberUtil.convertToLong((Object)0L))) {
            this.overTaskTime = nextTime - 60000L;
        }
    }

    protected void updateSubActions(ActionContext context, List<AbstractBaseProtectAction> subActions) {
        List rrbs = this.getReplicationRelationBos(context);
        for (ReplicationRelationBo rrb : rrbs) {
            subActions.add(new ArraySynMonitorSubAction(rrb, this.overTaskTime));
        }
    }

    public long getOverTaskTime() {
        return this.overTaskTime;
    }

    public void setOverTaskTime(long overTaskTime) {
        this.overTaskTime = overTaskTime;
    }
}

