/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BaseAsyncReplicateAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(BaseAsyncReplicateAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseAsyncReplicateAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        this.setProtectGroupReplicaTimestamp(context);
        return this.asyncReplicate(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean asyncReplicate(ActionContext context) {
        boolean flag = false;
        List bos = this.getReplicationRelationBos(context);
        try {
            if (!this.checkReplicationRelation(bos)) {
                boolean bl = flag;
                return bl;
            }
            IRecoveryProcessBaseHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            for (ReplicationRelationBo obj : bos) {
                logger.info((Object)("begin to sync once {srcSN:" + obj.getSrcDeviceSn() + ",tgtSN:" + obj.getTgtDeviceSn() + ",mirrorID:" + obj.getReplicationId() + ",isConsistGroup:" + obj.isConsistentGroup() + "}"), 90160758786988L);
                OperationResultBill optResultBill = ((IRecoveryProcessHandler)recoveryProcHandler).synchronize(obj.getReplicationId(), obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.isConsistentGroup());
                if (null != optResultBill && optResultBill.isHasFailRecord() && !VerifyUtil.isEmpty((Collection)optResultBill.getOperationResults())) {
                    OperationResult optResult = (OperationResult)optResultBill.getOperationResults().get(0);
                    logger.error((Object)("sync mirror failed.the error code is " + optResult.getErrorCode()), 90160758786989L);
                    this.setDetail("lego.err." + optResult.getErrorCode());
                    boolean bl = flag;
                    return bl;
                }
                logger.info((Object)("End to sync once:" + obj.getReplicationId()), 90160758786988L);
            }
            logger.info((Object)"BaseAsyncReplicateAction end to execute!", 90160758786988L);
            boolean bl = flag = true;
            return bl;
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)"BaseAsyncReplicateAction executed failed!", e.getErrorCode());
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948448");
            logger.error((Object)"BaseAsyncReplicateAction executed failed!", 1073948448L);
            boolean bl = flag;
            return bl;
        }
        finally {
            if (!flag && context.getContext().containsKey("FREEZE_PO_ENTITY")) {
                Set pos = (Set)context.getObject("FREEZE_PO_ENTITY");
                for (ProtectObject po : pos) {
                    this.thaw(po);
                }
            }
        }
    }

    private void thaw(ProtectObject po) {
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        if (appManager != null) {
            appManager.thaw(po);
        } else {
            logger.error((Object)("appManager is null!poType:" + po.getPoType()));
        }
    }

    protected boolean checkReplicationRelation(List<ReplicationRelationBo> bos) {
        boolean flag = false;
        try {
            for (ReplicationRelationBo obj : bos) {
                if (!this.isSyncing(obj)) continue;
                this.setDetail("lego.err.1073948434");
                logger.error((Object)"Pair's status is syncing.", 1073948434L);
                return flag;
            }
            logger.info((Object)"BaseAsyncReplicateAction end to execute!", 90160758786988L);
            flag = true;
            return flag;
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)"BaseAsyncReplicateAction executed failed!", (Throwable)e, errorCode);
            return flag;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948448");
            logger.error((Object)("BaseAsyncReplicateAction executed failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948448L);
            return flag;
        }
    }

    protected boolean isSyncing(ReplicationRelationBo obj) {
        IRecoveryProcessBaseHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        List targetLuns = ((IRecoveryProcessHandler)recoveryProcHandler).querySyncStatus(obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.getReplicationId(), obj.isConsistentGroup());
        if (null == targetLuns || targetLuns.isEmpty()) {
            logger.error((Object)"Query Replication Target Lun error when check Sync state.", 1073948461L);
            throw new LegoCheckedException(1073948461L, "query Replication Target Lun error when check Sync state.");
        }
        for (ReplicationTargetLun targetLun : targetLuns) {
            if (2 != targetLun.getPairStatus() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue() && XveEuumDefineParent.RUNNING_STATUS_E.INITIAL_SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue()) continue;
            return true;
        }
        return false;
    }

    private void setProtectGroupReplicaTimestamp(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType)) {
            return;
        }
        if (null == context.getObject("REPLICA_TIMESTANP")) {
            context.addObject("REPLICA_TIMESTANP", (Object)String.valueOf(new Date().getTime()));
        }
    }
}

