/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractSnapshotsPropareAction;
import com.huawei.ism.drm.protection.framework.engine.action.BasePrepareAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseSanSnapshotPrepareAction
extends AbstractSnapshotsPropareAction {
    private static Log logger = LogFactory.getInstance(BasePrepareAction.class);
    private ProtectGroup protectGroup = null;
    private boolean hasActiveOldRep = false;

    public boolean doExecute(ActionContext context) {
        this.protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseSanSnapshotPrepareAction begin to execute,pgId:" + this.protectGroup.getUuid() + " pgName " + this.protectGroup.getName()), 90160758786988L);
        this.updatePgStorageInfo();
        this.hasActiveOldRep = this.getProtectGroupReplica(context);
        if (!this.prepare(context)) {
            return false;
        }
        if (!this.checkGroup(context)) {
            logger.error((Object)"Failed to check the status before deactivating the snapshot. pgName: %s", new Object[]{this.protectGroup.getName()});
            context.addObject("REPLICA_NEED_CALLBACK", (Object)false);
            return false;
        }
        return this.snapshotGroup(context);
    }

    private void updatePgStorageInfo() {
        IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(this.protectGroup.getPoType());
        if (provider.needRefreshPgStorageInfoPreBuildReplica(this.protectGroup)) {
            try {
                provider.updateProtectObjectsProps(this.protectGroup);
                this.protectGroup.getProps().put("RefreshTriggerCache", "true");
                IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
                service.getStorageInfoChangedProtectObjectList(this.protectGroup);
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)"Failed to update storage info. %s");
                this.setDetail("lego.err." + ex.getErrorCode());
                throw ex;
            }
        }
    }

    protected boolean snapshotGroup(ActionContext context) {
        boolean flag = false;
        Set poReplicas = (Set)context.getObject("PO_REPLICA_ENTITY");
        SnapShotAssociateProtectObject apo = new SnapShotAssociateProtectObject();
        this.initApoInfo(poReplicas, apo);
        try {
            apo = this.makeSnapshotGroup(context, apo, poReplicas);
            if (null == apo) {
                return flag;
            }
            context.addObject("PO_GROUP_MAP", (Object)apo);
            logger.info((Object)"BaseSnapshotGroupAction end to execute!", 90160758786988L);
            flag = true;
            return flag;
        }
        catch (Exception e) {
            if ("--".equals(this.getDetail())) {
                this.setDetail("lego.err.-1");
            }
            logger.error((Object)("BaseSnapshotGroupAction executed failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            return flag;
        }
    }

    protected SnapShotAssociateProtectObject makeSnapshotGroup(ActionContext context, SnapShotAssociateProtectObject snapshotPo, Set<ProtectObjectReplica> curPoReplicas) {
        if (null == snapshotPo) {
            return null;
        }
        ProtectGroupReplica newPgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(this.protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
        if (VerifyUtil.isEmpty((Object)newPgReplica)) {
            logger.error((Object)"the newPgReplica is null");
            throw new LegoCheckedException(1073947394L);
        }
        Set newPoReplicas = newPgReplica.getReplicas();
        Map<String, ProtectObjectReplica> curPoIdReplicaMap = this.getPoIdReplicaMap(curPoReplicas);
        Map<String, ProtectObjectReplica> newPoIdReplicaMap = this.getPoIdReplicaMap(newPoReplicas);
        this.removeNoneExistPoReplica(snapshotPo, curPoReplicas, newPoIdReplicaMap);
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY");
        this.removeNoneExistPoReplica(snapshotPo, pgReplica.getReplicas(), newPoIdReplicaMap);
        for (ProtectObjectReplica poReplica : curPoReplicas) {
            IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(this.protectGroup.getPoType());
            provider.backUpPoMetadata(poReplica);
            for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
                LocalStorageReplica localStor = (LocalStorageReplica)stor;
                String lunId = localStor.getSrcStorageId();
                if (VerifyUtil.isEmpty((String)lunId)) {
                    logger.error((Object)("ProtectObject(" + poReplica.getPoId() + ") does not have snapshort."), 90160758786989L);
                    this.setDetail("lego.err.1073948446");
                    return null;
                }
                if (snapshotPo.getSnapshotInfo().containsKey(lunId)) {
                    String snapshotId = (String)snapshotPo.getSnapshotInfo().get(lunId);
                    localStor.setStorageId(snapshotId);
                    continue;
                }
                this.updateSnapshotPo(snapshotPo, localStor, this.hasActiveOldRep);
            }
        }
        for (ProtectObjectReplica newPoReplica : newPoReplicas) {
            if (curPoIdReplicaMap.containsKey(newPoReplica.getPoId())) continue;
            pgReplica.getReplicas().add(newPoReplica);
            curPoReplicas.add(newPoReplica);
            for (RelicaStorageInfo stor : newPoReplica.getStorageInfos()) {
                LocalStorageReplica localStor = (LocalStorageReplica)stor;
                String lunId = localStor.getSrcStorageId();
                if (VerifyUtil.isEmpty((String)lunId)) {
                    logger.error((Object)("ProtectObject(" + newPoReplica.getPoId() + ") does not have snapshort."), 90160758786989L);
                    this.setDetail("lego.err.1073948446");
                    return null;
                }
                if (snapshotPo.getSnapshotInfo().containsKey(lunId)) {
                    String snapshotId = (String)snapshotPo.getSnapshotInfo().get(lunId);
                    localStor.setStorageId(snapshotId);
                    continue;
                }
                this.updateSnapshotPo(snapshotPo, localStor, false);
            }
        }
        return snapshotPo;
    }

    private void updateSnapshotPo(SnapShotAssociateProtectObject snapshotPo, LocalStorageReplica localStor, boolean onlyDisable) {
        if (!onlyDisable) {
            this.createSnapShotAndUpdateDb(snapshotPo, localStor);
        } else {
            snapshotPo.getSnapshotInfo().put(localStor.getSrcStorageId(), localStor.getStorageId());
            this.disableSnapshotAfterCreate(snapshotPo, localStor.getSrcStorageProviderSN(), localStor.getStorageId());
        }
    }

    private Map<String, ProtectObjectReplica> getPoIdReplicaMap(Set<ProtectObjectReplica> poReplicas) {
        HashMap<String, ProtectObjectReplica> poIdReplicaMap = new HashMap<String, ProtectObjectReplica>();
        for (ProtectObjectReplica rep : poReplicas) {
            poIdReplicaMap.put(rep.getPoId(), rep);
        }
        return poIdReplicaMap;
    }

    private void removeNoneExistPoReplica(SnapShotAssociateProtectObject snapshotPo, Set<ProtectObjectReplica> poReplicas, Map<String, ProtectObjectReplica> poIdReplicaMap) {
        Iterator<ProtectObjectReplica> iterator = poReplicas.iterator();
        while (iterator.hasNext()) {
            ProtectObjectReplica poReplica = iterator.next();
            if (!poIdReplicaMap.containsKey(poReplica.getPoId())) {
                for (RelicaStorageInfo localStor : poReplica.getStorageInfos()) {
                    snapshotPo.getSnapshotInfo().put(localStor.getSrcStorageId(), localStor.getStorageId());
                    LocalStorageReplica stor = (LocalStorageReplica)localStor;
                    this.updateSnapshotPo(snapshotPo, stor, this.hasActiveOldRep);
                }
                logger.debug((Object)"po replica[%s] not exsit,remove from to be actived replica.", new Object[]{poReplica.getId()});
                iterator.remove();
                continue;
            }
            poReplica.setProtectObject(poIdReplicaMap.get(poReplica.getPoId()).getProtectObject());
        }
    }

    private void initApoInfo(Set<ProtectObjectReplica> poReplicas, SnapShotAssociateProtectObject apo) {
        Iterator<ProtectObjectReplica> iterator = poReplicas.iterator();
        if (iterator.hasNext()) {
            ProtectObjectReplica poReplica = iterator.next();
            for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
                LocalStorageReplica localStor = (LocalStorageReplica)stor;
                String srcArraySN = localStor.getStorageProviderSN();
                if (VerifyUtil.isEmpty((String)srcArraySN)) continue;
                apo.setSrcStorageProviderSN(srcArraySN);
                apo.setTgtStorageProviderSN(srcArraySN);
                break;
            }
        }
    }

    protected void createSnapShotAndUpdateDb(SnapShotAssociateProtectObject apo, LocalStorageReplica localStor) {
        Snapshot snapshot = this.createSnapshot(localStor);
        if (!VerifyUtil.isEmpty((Object)snapshot)) {
            String snapshotId = String.valueOf(snapshot.getSnapshotId());
            try {
                this.disableSnapshotAfterCreate(apo, localStor.getSrcStorageProviderSN(), snapshotId);
                localStor.setStorageId(snapshotId);
                apo.getSnapshotInfo().put(localStor.getSrcStorageId(), snapshotId);
            }
            catch (Exception e) {
                this.deleteSnapshotOnStorage(localStor.getSrcStorageProviderSN(), snapshotId, localStor.getSnapshotName());
                ExceptionUtil.rethrowException((Throwable)e, (String)"update snapshot db info error.", (long)-1L, (String[])new String[0], (Log)logger);
            }
        } else {
            this.setDetail("lego.err.1073948454");
            throw new LegoCheckedException(1073948454L, "create snapshot error.");
        }
    }

    protected Snapshot createSnapshot(LocalStorageReplica localStor) {
        Lun lun = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunBySnAndLunId(localStor.getSrcStorageProviderSN(), localStor.getSrcStorageId());
        if (null == lun) {
            logger.error((Object)("lun(" + localStor.getSrcStorageProviderSN() + ":" + localStor.getSrcStorageId() + ") is null."), 90160758784001L);
            this.setDetail("lego.err.1073948454");
            throw new LegoCheckedException(1073948454L);
        }
        Snapshot result = null;
        try {
            IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(localStor.getSrcStorageProviderSN());
            this.checkProxy(proxy, localStor.getSrcStorageProviderSN());
            Snapshot paramSnapshot = new Snapshot();
            paramSnapshot.setSnapshotName(localStor.getSnapshotName());
            ArrayList<String> lunIds = new ArrayList<String>();
            lunIds.add(lun.getLunId());
            result = proxy.createSnapshot(localStor.getSrcStorageProviderSN(), lunIds, paramSnapshot);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            logger.error((Object)("GenerateProtectGroupReplica Creating snapshot failed. DevSN:" + localStor.getSrcStorageProviderSN() + ",Name:" + localStor.getSnapshotName() + ",LunId:" + localStor.getSrcStorageId()), (Throwable)e, errorCode);
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            this.sendSnapShotExceedLimitMsg(this.protectGroup.getUuid(), errorCode);
            throw new LegoCheckedException(errorCode, (Throwable)e);
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948454");
            String errorMsg = "GenerateProtectGroupReplica Creating snapshot failed. DevSN:" + localStor.getSrcStorageProviderSN() + ",Name:" + localStor.getSnapshotName() + ",LunId:" + localStor.getSrcStorageId();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948454L, (String[])new String[0], (Log)logger);
        }
        return result;
    }

    protected void disableSnapshot(SnapShotAssociateProtectObject snapshotPo, String snapshotId, LocalStorageReplica localStor) {
        IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(snapshotPo.getSrcStorageProviderSN());
        this.checkProxy(proxy, snapshotPo.getSrcStorageProviderSN());
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(snapshotId);
        OperationResult optResult = proxy.disableSnapshot(snapshotPo.getSrcStorageProviderSN(), (Snapshot)arraySnapshot);
        if (null == optResult) {
            logger.error((Object)"Disable snapshot error", 90160758784001L);
            this.setDetail("lego.err.1073948681");
            throw new LegoCheckedException(1073948681L);
        }
        if (!optResult.isSuccess()) {
            logger.error((Object)"Disable snapshot error,need to recreate snapshot!", 90160758784001L);
            this.createSnapShotAndUpdateDb(snapshotPo, localStor);
        }
    }

    protected void disableSnapshotAfterCreate(SnapShotAssociateProtectObject apo, String arraySn, String snapshotId) {
        IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(arraySn);
        this.checkProxy(proxy, arraySn);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(snapshotId);
        OperationResult optResult = proxy.disableSnapshot(arraySn, (Snapshot)arraySnapshot);
        if (null == optResult) {
            logger.error((Object)"Disable snapshot error", 90160758784001L);
            this.setDetail("lego.err.1073948681");
            throw new LegoCheckedException(1073948681L);
        }
        if (!optResult.isSuccess()) {
            logger.error((Object)"Disable snapshot error", 90160758784001L);
            this.setDetail("lego.err." + optResult.getErrorCode());
            this.setDetailParams(this.constructParams(optResult.getArgs()));
            throw new LegoCheckedException(1073948681L);
        }
        List snapshot = proxy.getSnapshot(arraySn, (Snapshot)arraySnapshot);
        Snapshot firstSnapshot = (Snapshot)CommonUtil.getFirstElement((Collection)snapshot);
        if (null != firstSnapshot) {
            logger.info((Object)("get snapshot wwns, device sn: " + arraySn + ", snapshotid: " + snapshotId + ", pg: " + (null == this.protectGroup ? "error null" : this.protectGroup.getName())));
            apo.getSnapshotIdAndWwnMap().put(snapshotId, firstSnapshot.getWwn());
        }
    }

    protected void deleteSnapshotOnStorage(String arraySN, String snapshotId, String snapshotName) {
        IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(arraySN);
        this.checkProxy(proxy, arraySN);
        ArraySnapshot as = new ArraySnapshot();
        try {
            as.setSnapshotId(snapshotId);
            as.setSnapshotName(snapshotName);
            proxy.deleteSnapshot(arraySN, (Snapshot)as);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            logger.error((Object)("DeleteSnapshotOnStorage error: " + arraySN + ",Name:" + snapshotName + ",Id:" + snapshotId), (Throwable)e, errorCode);
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            throw new LegoCheckedException(errorCode, (Throwable)e);
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948679");
            String errorMsg = "deleteSnapshotOnStorage error: " + arraySN + ",Name:" + snapshotName + ",Id:" + snapshotId;
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948679L, (String[])new String[0], (Log)logger);
        }
    }

    private void checkProxy(IStorageSnapshotManager proxy, String arraySN) {
        if (proxy == null) {
            logger.error((Object)("IStorageSnapshotManager is null. arraySn:" + arraySN));
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
    }

    public ProtectGroup getProtectGroup() {
        return this.protectGroup;
    }

    public void setProtectGroup(ProtectGroup protectGroup) {
        this.protectGroup = protectGroup;
    }

    public boolean isHasActiveOldRep() {
        return this.hasActiveOldRep;
    }

    public void setHasActiveOldRep(boolean hasActiveOldRep) {
        this.hasActiveOldRep = hasActiveOldRep;
    }
}

