/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBackupAction;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CloudBackupAction
extends AbstractBackupAction {
    private static final Log logger = LogFactory.getInstance(CloudBackupAction.class);

    @Override
    protected BackupPlan getBackupPlan(ActionContext context) {
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY");
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY");
        Schedule schedule = task.getSchedule();
        String planId = (String)schedule.getExtParameters().get("BACKUP_PLAN_ID");
        if (null == planId) {
            logger.error((Object)"planId nox exist.");
            throw new LegoCheckedException(1073947394L);
        }
        BackupPlan plan = new BackupPlan();
        plan.setId(planId);
        plan.setBackupMode(this.getBackupMode(context));
        String devSn = replica.getStorageDeviceId();
        plan.setDevSn(devSn);
        return plan;
    }

    @Override
    protected Map<String, String> getParameterMap(ActionContext context) {
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY");
        HashMap<String, String> paraMap = new HashMap<String, String>();
        List<Snapshot> list = this.getSnapshotList(replica);
        paraMap.put("snapshotList", this.convertSnapshotStr(list));
        context.addObject("BACKUP_SNAPSHOTLIST", list);
        return paraMap;
    }

    private List<Snapshot> getSnapshotList(ProtectGroupReplica replica) {
        if (null == replica || !replica.isSanSnapshotReplica()) {
            logger.error((Object)"replica is not correct.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<Snapshot> list = new ArrayList<Snapshot>();
        HashSet set = new HashSet();
        replica.getReplicas().forEach(protectObjectReplica -> protectObjectReplica.getStorageInfos().forEach(storageInfo -> {
            if (!set.contains(replica.getStorageDeviceId() + storageInfo.getStorageId())) {
                Snapshot snapshot = new Snapshot();
                snapshot.setSrcResourceId(Integer.valueOf(storageInfo.getSrcStorageId()));
                snapshot.setSnapshotId(storageInfo.getStorageId());
                snapshot.setDevSn(replica.getStorageDeviceId());
                snapshot.setId(storageInfo.getStorageId());
                snapshot.setName(((LocalStorageReplica)storageInfo).getSnapshotName());
                list.add(snapshot);
            }
            set.add(replica.getStorageDeviceId() + storageInfo.getStorageId());
        }));
        return list;
    }

    private String convertSnapshotStr(List<Snapshot> list) {
        if (null == list) {
            logger.error((Object)"replica is not correct.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray jsonArray = new JSONArray();
        list.forEach(snapshot -> {
            JSONObject object = new JSONObject();
            object.put((Object)"snapshotId", (Object)snapshot.getSnapshotId());
            object.put((Object)"snapshotType", (Object)1);
            object.put((Object)"lunId", (Object)snapshot.getSrcResourceId());
            jsonArray.add((Object)object);
        });
        return jsonArray.toString();
    }

    @Override
    protected String getBackupEngine() {
        return "NativeBackupEngine";
    }
}

