/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CreateNasSnapshotAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(CreateNasSnapshotAction.class);
    private ProtectGroup protectGroup = null;

    public boolean doExecute(ActionContext context) {
        this.protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseNasSnapshotAction begin to execute,pgId:" + this.protectGroup.getUuid() + " Name: " + this.protectGroup.getName()), 90160758786988L);
        ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(this.protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
        if (null == pgReplica) {
            logger.error((Object)("CreateNasSnapshotAction get replica error,pgId:" + this.protectGroup.getUuid() + " pgName " + this.protectGroup.getName()));
            this.setDetail("lego.err.2117645");
            return false;
        }
        context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        context.addObject("PO_REPLICA_ENTITY", (Object)pgReplica.getReplicas());
        return this.refreshSnapShort(context);
    }

    protected boolean refreshSnapShort(ActionContext context) {
        boolean flag = false;
        Set poReplicas = (Set)context.getObject("PO_REPLICA_ENTITY");
        SnapShotAssociateProtectObject apo = null;
        Iterator iterator = poReplicas.iterator();
        if (iterator.hasNext()) {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)iterator.next();
            for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
                LocalStorageReplica localStor = (LocalStorageReplica)stor;
                String srcArraySN = localStor.getStorageProviderSN();
                if (VerifyUtil.isEmpty((String)srcArraySN)) continue;
                apo = new SnapShotAssociateProtectObject();
                apo.setSrcStorageProviderSN(srcArraySN);
                apo.setTgtStorageProviderSN(srcArraySN);
                break;
            }
        }
        try {
            apo = this.makeSnapshotGroup(apo, poReplicas);
            if (null == apo) {
                return flag;
            }
            context.addObject("PO_GROUP_MAP", (Object)apo);
            logger.info((Object)"BaseNasSnapshotAction end to execute!", 90160758786988L);
            flag = true;
            return flag;
        }
        catch (Exception e) {
            if ("--".equals(this.getDetail())) {
                this.setDetail("lego.err.-1");
            }
            logger.error((Object)("BaseNasSnapshotAction executed failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            return flag;
        }
    }

    protected SnapShotAssociateProtectObject makeSnapshotGroup(SnapShotAssociateProtectObject snapshotPo, Set<ProtectObjectReplica> poReplicas) {
        if (null == snapshotPo) {
            return null;
        }
        for (ProtectObjectReplica poReplica : poReplicas) {
            if (this.createOrDeleteSnapshot(snapshotPo, poReplica) != null) continue;
            return null;
        }
        return snapshotPo;
    }

    private SnapShotAssociateProtectObject createOrDeleteSnapshot(SnapShotAssociateProtectObject snapshotPo, ProtectObjectReplica poReplica) {
        for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
            LocalStorageReplica localStor = (LocalStorageReplica)stor;
            String nasId = localStor.getSrcStorageId();
            if (VerifyUtil.isEmpty((String)nasId)) {
                logger.error((Object)("ProtectObject(" + poReplica.getPoId() + ") does not have snapshort."), 90160758786989L);
                this.setDetail("lego.err.1073948446");
                return null;
            }
            if (snapshotPo.getSnapshotInfo().containsKey(nasId)) {
                String snapshotId = (String)snapshotPo.getSnapshotInfo().get(nasId);
                localStor.setStorageId(snapshotId);
                continue;
            }
            this.createSnapShotAndLocalStor(snapshotPo, localStor);
        }
        return snapshotPo;
    }

    protected void createSnapShotAndLocalStor(SnapShotAssociateProtectObject apo, LocalStorageReplica localStor) {
        String snapshotId = this.createSnapshot(localStor);
        if (!VerifyUtil.isEmpty((String)snapshotId)) {
            try {
                localStor.setStorageId(snapshotId);
                apo.getSnapshotInfo().put(localStor.getSrcStorageId(), snapshotId);
            }
            catch (Exception e) {
                this.deleteSnapshotOnStorage(localStor.getSrcStorageProviderSN(), snapshotId, localStor.getSnapshotName());
                ExceptionUtil.rethrowException((Throwable)e, (String)"update snapshot db info error.", (long)-1L, (String[])new String[0], (Log)logger);
            }
        } else {
            this.setDetail("lego.err.1073948454");
            throw new LegoCheckedException(1073948454L, "create snapshot error.");
        }
    }

    protected String createSnapshot(LocalStorageReplica localStor) {
        IStorageFileSystemManager fileSystemManagerProxy = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(localStor.getSrcStorageProviderSN());
        this.checkFileSystemMgr(fileSystemManagerProxy, localStor);
        ArrayList<String> nasFileIds = new ArrayList<String>();
        nasFileIds.add(localStor.getSrcStorageId());
        List nasFiles = fileSystemManagerProxy.queryFileSystems(localStor.getSrcStorageProviderSN(), nasFileIds, this.getVstoreId(this.protectGroup));
        if (VerifyUtil.isEmpty((Collection)nasFiles)) {
            logger.error((Object)("nas(" + localStor.getSrcStorageProviderSN() + ":" + localStor.getSrcStorageId() + ") is null."), 90160758784001L);
            this.setDetail("lego.err.1073948454");
            throw new LegoCheckedException(1073948454L);
        }
        String snapId = null;
        try {
            IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(localStor.getSrcStorageProviderSN());
            this.checkStorageFileSystemSnapshotMgr(fileSystemSnapshotManagerProxy, localStor.getSrcStorageProviderSN());
            String nasId = ((NasFileSystem)nasFiles.get(0)).getResourceId();
            snapId = fileSystemSnapshotManagerProxy.createSnapshot(localStor.getSrcStorageProviderSN(), nasId, localStor.getSnapshotName());
            if (VerifyUtil.isEmpty((String)snapId)) {
                logger.error((Object)"snapId is empty!", 90160758784001L);
                throw new LegoCheckedException(1073948680L);
            }
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            logger.error((Object)("GenerateProtectGroupReplica Creating snapshot failed. DevSN:" + localStor.getSrcStorageProviderSN() + ",Name:" + localStor.getSnapshotName() + ",LunId:" + localStor.getSrcStorageId()), (Throwable)e, errorCode);
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            this.sendSnapShotExceedLimitMsg(this.protectGroup.getUuid(), errorCode);
            throw new LegoCheckedException(errorCode, (Throwable)e);
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948454");
            String errorMsg = "GenerateProtectGroupReplica Creating snapshot failed. DevSN:" + localStor.getSrcStorageProviderSN() + ",Name:" + localStor.getSnapshotName() + ",LunId:" + localStor.getSrcStorageId();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948454L, (String[])new String[0], (Log)logger);
        }
        return snapId;
    }

    private void checkFileSystemMgr(IStorageFileSystemManager fileSystemManagerProxy, LocalStorageReplica storageSn) {
        if (fileSystemManagerProxy == null) {
            logger.error((Object)("IStorageFileSystemManager is null!arraySN:" + storageSn.getSrcStorageProviderSN()));
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void deleteSnapshotOnStorage(String arraySN, String snapshotId, String snapshotName) {
        block5: {
            try {
                IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(arraySN);
                this.checkStorageFileSystemSnapshotMgr(fileSystemSnapshotManagerProxy, arraySN);
                OperationResult result = fileSystemSnapshotManagerProxy.deleteSnapshot(arraySN, snapshotId);
                if (result.isSuccess()) break block5;
                String errorCode = result.getErrorCode();
                long errCode = 1073948679L;
                try {
                    errCode = Long.parseLong(errorCode);
                }
                catch (Exception e) {
                    logger.error((Object)"operation<Long.parseLong(errorCode)> error!", 1073948679L);
                }
                logger.error((Object)("delete SnapshotOnStorage error code: " + errCode), 1073948679L);
                throw new LegoCheckedException(errCode, result.getArgs());
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                logger.error((Object)("DeleteSnapshotOnStorage error: " + arraySN + ",Name:" + snapshotName + ",Id:" + snapshotId), (Throwable)e, errorCode);
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
                throw new LegoCheckedException(errorCode, (Throwable)e);
            }
            catch (Exception e) {
                this.setDetail("lego.err.1073948679");
                String errorMsg = "deleteSnapshotOnStorage error: " + arraySN + ",Name:" + snapshotName + ",Id:" + snapshotId;
                ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948679L, (String[])new String[0], (Log)logger);
            }
        }
    }

    private void checkStorageFileSystemSnapshotMgr(IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy, String arraySN) {
        if (fileSystemSnapshotManagerProxy == null) {
            logger.error((Object)("fileSystemSnapshotManagerProxy is null!arraySN:" + arraySN));
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
    }

    private String getVstoreId(ProtectGroup pg) {
        String vStoreId = null;
        if (null != pg && null != pg.getPolist() && pg.getPolist().size() > 0) {
            ProtectObject protectObject = (ProtectObject)pg.getPolist().iterator().next();
            vStoreId = this.getVstoreId(protectObject);
        }
        return vStoreId;
    }

    private String getVstoreId(ProtectObject protectObject) {
        String vStoreId = null;
        if (null != protectObject && null != protectObject.getUsedStorageResourceSet() && !protectObject.getUsedStorageResourceSet().isEmpty()) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next();
            vStoreId = null != protectObjectStorageInfo ? protectObjectStorageInfo.getVstoreId() : null;
        }
        return vStoreId;
    }
}

