/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.array.sdk.model.HyperVaultJob;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;

public class HyperVaultBackUpMonitorSubAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(HyperVaultBackUpMonitorSubAction.class);
    private static final String SYN_PROGRESS_RUNNING = "com.huawei.ism.drm.protection.framework.engine.action.HyperVaultBackUpMonitorSubAction.HyperJob.Progress.Running";
    private static final String SYN_PROGRESS_COMPLETE = "com.huawei.ism.drm.protection.framework.engine.action.HyperVaultBackUpMonitorSubAction.HyperJob.Progress.Complete";
    private static final String SYN_PROGRESS_CANCELLED = "com.huawei.ism.drm.protection.framework.engine.action.HyperVaultBackUpMonitorSubAction.HyperJob.Progress.Cancelled";
    private static final String SYN_PROGRESS_SUSPENDED = "com.huawei.ism.drm.protection.framework.engine.action.HyperVaultBackUpMonitorSubAction.HyperJob.Progress.Suspended";
    private long overTaskTime;
    private HyperVaultReplica hyperVaultReplica;

    public HyperVaultBackUpMonitorSubAction(HyperVaultReplica hyperVaultReplica, long overTaskTime) {
        this.hyperVaultReplica = hyperVaultReplica;
        this.overTaskTime = overTaskTime;
    }

    public void preExcute(ActionContext context) {
        this.setNameParams(this.hyperVaultReplica.getPairId());
    }

    public boolean doExecute(ActionContext context) {
        return this.monitorBackUpProgress(context);
    }

    private boolean monitorBackUpProgress(ActionContext context) {
        long curTime;
        PolicyTemplate policyTemplate;
        Map props;
        String prStr;
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        ProtectionRelation protectionRelation = null;
        if (pg != null && !VerifyUtil.isEmpty((String)(prStr = (String)(props = (policyTemplate = pg.getTemplate()).getProps()).get("protectionRelation")))) {
            protectionRelation = ProtectionRelationJsonConverter.toProtectionRelation(prStr);
        }
        String deviceSn = this.hyperVaultReplica.getSrcStorageProviderSN();
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(deviceSn);
        if (mgr == null) {
            logger.error((Object)("IStorageHyperVaultManager is null.deviceSn:" + deviceSn));
            throw new LegoCheckedException(2117645L);
        }
        String jobId = (String)context.getObject("HyperVaultJobId_" + this.hyperVaultReplica.getPairId());
        logger.info((Object)("HyperVault JobId :" + jobId + "  hyperVaultId:" + this.hyperVaultReplica.getPairId()));
        if (VerifyUtil.isEmpty((String)jobId)) {
            logger.error((Object)"jobId is Empty");
            return false;
        }
        do {
            HyperVaultJob job = null;
            try {
                job = this.queryJob(mgr, deviceSn, protectionRelation, jobId);
                if (VerifyUtil.isEmpty((Object)job) || VerifyUtil.isEmpty((String)job.getCopyId())) {
                    logger.error((Object)"can not find copy id");
                    this.setDetail("lego.err.1073947394");
                    return false;
                }
                logger.info((Object)("job copy id :" + job.getCopyId()));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("query job error." + (Object)((Object)e)));
                this.setDetail(e.getErrorMessageKey());
                return false;
            }
            Boolean result = this.checkHyperVaultJobProgress(job);
            if (!VerifyUtil.isEmpty((Object)result)) {
                if (result.booleanValue()) {
                    this.hyperVaultReplica.setStorageId(job.getCopyId());
                    this.hyperVaultReplica.setSnapshotName(job.getCopyName());
                }
                return result;
            }
            CommUtil.pauseThread((long)5000L);
        } while ((curTime = System.currentTimeMillis()) <= this.overTaskTime);
        logger.error((Object)"Synchronize Hyper Vault Progress time out. ");
        this.setDetail("lego.err.1073947433");
        return false;
    }

    private HyperVaultJob queryJob(IStorageHyperVaultManager mgr, String deviceSn, ProtectionRelation protectionRelation, String jobId) {
        HyperVaultJob job;
        block2: {
            job = null;
            try {
                job = mgr.queryJob(deviceSn, jobId);
            }
            catch (Exception e) {
                logger.error((Object)"query job error, deviceSN: %s, jobId: %s", new Object[]{deviceSn, jobId});
                if (VerifyUtil.isEmpty((Object)protectionRelation) || VerifyUtil.isEmpty((String)protectionRelation.getSrcResourceProviderSn())) break block2;
                job = mgr.queryJob(protectionRelation.getSrcResourceProviderSn(), jobId);
            }
        }
        return job;
    }

    private Boolean checkHyperVaultJobProgress(HyperVaultJob job) {
        Boolean result;
        switch (XveEuumDefineParent.RUNNING_STATUS_E.valueOf((int)NumberUtil.convertToInteger((Object)job.getRunningState()))) {
            case JOB_COMPLETED: {
                this.setDetail(SYN_PROGRESS_COMPLETE);
                result = true;
                break;
            }
            case CANCELLED: {
                this.setDetail(SYN_PROGRESS_CANCELLED);
                result = false;
                break;
            }
            case SUSPENDING: {
                this.setDetail(SYN_PROGRESS_SUSPENDED);
                result = true;
                break;
            }
            default: {
                this.setDetail(SYN_PROGRESS_RUNNING);
                result = null;
            }
        }
        return result;
    }
}

