/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HyperVaultManualBackUpAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(HyperVaultManualBackUpAction.class);
    private static final String LOCAL_BACK_UP = "hypervault.local.backup";
    private static final String REMOTE_BACK_UP = "hypervault.remote.backup";

    public void preExcute(ActionContext context) {
        int protectLocation = NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION"));
        if (protectLocation == DrmEnumDefine.ProtectLocation.A_A.getValue()) {
            this.setNameParams(LOCAL_BACK_UP);
        } else {
            this.setNameParams(REMOTE_BACK_UP);
        }
    }

    public boolean doExecute(ActionContext context) {
        try {
            ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
            logger.info((Object)("HyperVaultManualBackUpAction begin to execute,pgId:" + protectGroup.getUuid() + " pgName " + protectGroup.getName()));
            ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
            if (pgReplica == null) {
                logger.error((Object)("HyperVaultManualBackUpAction get replica error,pgId:" + protectGroup.getUuid() + " pgName " + protectGroup.getName()));
                this.setDetail("lego.err.2117645");
                return false;
            }
            context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
            this.manualBackUpAll(context, pgReplica);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        return true;
    }

    private void manualBackUpAll(ActionContext context, ProtectGroupReplica replica) {
        Set poReplicas = replica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)poReplicas)) {
            logger.error((Object)"can not get rpoReplicas");
            throw new LegoCheckedException(1073947394L);
        }
        HashSet<String> vaultIds = new HashSet<String>();
        for (ProtectObjectReplica poReplica : poReplicas) {
            Set hyperVaultReplicas = poReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)hyperVaultReplicas)) {
                logger.error((Object)"can not get hyperVaultReplicas");
                throw new LegoCheckedException(1073947394L);
            }
            for (RelicaStorageInfo info : hyperVaultReplicas) {
                HyperVaultReplica replicaStorageInfo = (HyperVaultReplica)info;
                if (vaultIds.contains(replicaStorageInfo.getPairId())) continue;
                vaultIds.add(replicaStorageInfo.getPairId());
                this.manualBackUpHyperVault(context, replicaStorageInfo, replica.getProtectLocation());
            }
        }
    }

    private void manualBackUpHyperVault(ActionContext context, HyperVaultReplica replicaStorage, int location) {
        String deviceSn = replicaStorage.getSrcStorageProviderSN();
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(deviceSn);
        if (mgr == null) {
            logger.error((Object)"IStorageHyperVaultManager is null!deviceSn:%s", new Object[]{deviceSn});
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
        XveEnumDefine.VAULT_ACTION_TYPE_E type = XveEnumDefine.VAULT_ACTION_TYPE_E.LOCAL_ACTION;
        try {
            if (!VerifyUtil.isEmpty((String)replicaStorage.getStorageId()) && !replicaStorage.getStorageId().equals("NONE")) {
                List copys = mgr.queryCopysByHyperVault(deviceSn, replicaStorage.getPairId());
                if (this.oldCopyIdExist(replicaStorage.getStorageId(), copys)) {
                    mgr.deleteCopy(deviceSn, replicaStorage.getStorageId());
                }
            }
            if (location == DrmEnumDefine.ProtectLocation.B_B.getValue()) {
                type = XveEnumDefine.VAULT_ACTION_TYPE_E.REMOTE_ACTION;
            }
            String jobId = mgr.manualBackup(deviceSn, replicaStorage.getPairId(), type);
            context.addObject("HyperVaultJobId_" + replicaStorage.getPairId(), (Object)jobId);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("manual back up failure.deviceSn " + deviceSn + " hyper vault pair id " + replicaStorage.getPairId() + " copy id " + replicaStorage.getStorageId()), (Throwable)ex);
            this.setDetail(ex.getErrorMessageKey());
            throw ex;
        }
    }

    private boolean oldCopyIdExist(String copyId, List<HyperVaultCopy> copys) {
        boolean result = false;
        StringBuffer log = new StringBuffer();
        for (HyperVaultCopy copy : copys) {
            log.append(copy.getId() + ";");
            if (!copyId.equals(copy.getId())) continue;
            return true;
        }
        logger.info((Object)"copyId :%s  not exists in device :%s.", new Object[]{copyId, log.toString()});
        return result;
    }
}

