/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.service.IProtectActionService;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.AbstractProtectActionFlowDefineMgr;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionBaseFlowDefineMgr;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Service(name="com.huawei.ism.drm.protection.action.service.IProtectActionService", desc="", interfaceClass=IProtectActionService.class)
public class ProtectActionFlowDefineMgr
extends ProtectActionBaseFlowDefineMgr
implements IProtectActionService {
    private static final Log logger = LogFactory.getInstance(AbstractProtectActionFlowDefineMgr.class);
    private static ProtectActionFlowDefineMgr instance = new ProtectActionFlowDefineMgr();

    private ProtectActionFlowDefineMgr() {
    }

    public static ProtectActionFlowDefineMgr getInstance() {
        return instance;
    }

    public void disableAction(String pgId, String actionId) {
        logger.debug((Object)"disableAction");
        this.changeActionEnable(pgId, actionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeActionEnable(String pgId, String actionId, boolean toStatus) {
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(pgId);
        if (!lockFlag) {
            logger.error((Object)("The pg is locked: " + pgId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            AbstractBaseProtectAction action = this.queryProtectActionFromDb(pgId, actionId);
            if (VerifyUtil.isEmpty((Object)action)) {
                logger.error((Object)"action is null", 2117645L);
                throw new LegoCheckedException(2117645L);
            }
            this.checkActionOpt(ProtectGroupHelper.ProtectGroupOpt.MOFIFY.getStatus(), pgId, action);
            action.setEnable(toStatus);
            this.setEnableFlag(action, toStatus);
            ArrayList<AbstractBaseProtectAction> param = new ArrayList<AbstractBaseProtectAction>();
            param.add(action);
            this.saveOrUpdateActions(param);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"enable action failed", (Throwable)e, 0x300001L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"enable action failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(pgId);
        }
    }

    private void setEnableFlag(AbstractBaseProtectAction action, boolean toStatus) {
        action.getParams().put("isEnableFlag", Boolean.toString(toStatus));
    }

    public void enableAction(String pgId, String actionId) {
        logger.debug((Object)"enableAction");
        this.changeActionEnable(pgId, actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAction(String protectGroupId, String actionId, Map<String, String> params) {
        AbstractBaseProtectAction action = this.queryProtectActionFromDb(protectGroupId, actionId);
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)"The pg is locked: %s.", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            if (VerifyUtil.isEmpty((Object)action)) {
                throw new LegoCheckedException(2117645L);
            }
            this.checkActionOpt(ProtectGroupHelper.ProtectGroupOpt.MOFIFY.getStatus(), protectGroupId, action);
            params.put("protectGroupId", protectGroupId);
            action.checkParams(params);
            Map actionParams = action.getParams();
            for (Map.Entry<String, String> param : params.entrySet()) {
                actionParams.put(param.getKey(), param.getValue());
            }
            ArrayList<AbstractBaseProtectAction> actions = new ArrayList<AbstractBaseProtectAction>();
            actions.add(action);
            this.saveOrUpdateActions(actions);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"enable action failed,error is %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"enable action failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        this.updateScheduleExtParameter(protectGroupId, actionId, params, action);
    }

    private void updateScheduleExtParameter(String protectGroupId, String actionId, Map<String, String> params, AbstractBaseProtectAction action) {
        Map<String, String> updatedTemplateProps = this.getUpdatedTemplateProps(action, params);
        if (VerifyUtil.isEmpty(updatedTemplateProps)) {
            logger.info((Object)("protect group " + protectGroupId + " modify action: " + actionId + ", there is no need to update schedule"));
            return;
        }
        ProtectGroup pg = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        Schedule schedule = pg.getTemplate().getSchedules().stream().filter(item -> item.getProtectLocation() == action.getProtectLocation()).findAny().orElse(null);
        if (null == schedule || ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
            logger.info((Object)("shcedule is null or not snapshot, protect group: " + protectGroupId + ", action location: " + action.getProtectLocation()));
            return;
        }
        ScriptParamsUtils.filterSensitiveParams((Schedule)schedule);
        Map scheduleExtParameters = schedule.getExtParameters();
        for (Map.Entry<String, String> entry : updatedTemplateProps.entrySet()) {
            scheduleExtParameters.put(entry.getKey(), entry.getValue());
        }
        schedule.setExtParameterDatas(JSONObject.fromObject((Object)scheduleExtParameters).toString());
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroupServiceImpl pgService = (ProtectGroupServiceImpl)service;
        if (pgService != null) {
            pgService.updateSchedule(protectGroupId, schedule);
        }
    }

    private Map<String, String> getUpdatedTemplateProps(AbstractBaseProtectAction action, Map<String, String> params) {
        HashMap<String, String> updatedTemplateProps = new HashMap<String, String>();
        ArrayList<String> updatedTemplatePropsKeyList = new ArrayList<String>(Arrays.asList("publicParam", "beforeParam", "userBeforeParam", "afterParam", "userAfterParam"));
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            if (!updatedTemplatePropsKeyList.contains(paramEntry.getKey())) continue;
            updatedTemplateProps.put(paramEntry.getKey(), paramEntry.getValue());
        }
        if (params.containsKey("scriptName")) {
            String className = action.getClass().getName();
            JSONArray scriptArr = new JSONArray();
            scriptArr.add((Object)params.get("scriptName"));
            if ("com.huawei.ism.drm.host.protection.action.PreProcessScriptAction".equals(className)) {
                updatedTemplateProps.put("beforeScript", scriptArr.toString());
            } else if ("com.huawei.ism.drm.host.protection.action.PostProcessScriptAction".equals(className)) {
                updatedTemplateProps.put("afterScript", scriptArr.toString());
            }
        }
        return updatedTemplateProps;
    }
}

