/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProtectionJobExtendUtil {
    private static final Log logger = LogFactory.getInstance(ProtectionJobExtendUtil.class);
    private static ProtectionJobExtendUtil jobExtendUtil = new ProtectionJobExtendUtil();

    private ProtectionJobExtendUtil() {
    }

    public static ProtectionJobExtendUtil getInstance() {
        return jobExtendUtil;
    }

    public static void terminateTask(ReplicationRelationBo replicationRelationBo) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)replicationRelationBo)) {
            logger.error((Object)"replicationRelationBo is null!");
            return;
        }
        try {
            logger.info((Object)"start to abort task successful!");
            StorageReplicationManagerProxy.getInstance().splitReplication(replicationRelationBo.getSrcDeviceSn(), replicationRelationBo.getTgtDeviceSn(), replicationRelationBo.getReplicationId(), replicationRelationBo.isConsistentGroup());
            logger.info((Object)"abort task successful!");
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"terminateTask split replication failed. SrcStorageProviderSN:%s,TgtStorageProviderSN:%s.", new Object[]{replicationRelationBo.getSrcDeviceSn(), replicationRelationBo.getTgtDeviceSn()});
            throw ex;
        }
        catch (Exception ex) {
            String errorMsg = "terminateTask split replication failed. SrcStorageProviderSN:" + replicationRelationBo.getSrcDeviceSn() + ",TgtStorageProviderSN:" + replicationRelationBo.getTgtDeviceSn();
            ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public static boolean isHyperMetroInFirstSite(ProtectGroup protectGroup) {
        List siteInfoList;
        if (protectGroup == null) {
            logger.error((Object)"pg is null!");
            throw new LegoCheckedException(1073947394L);
        }
        String siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO");
        return siteInfoListStr != null && (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).size() > 0 && ((SiteInfo)siteInfoList.get(0)).getSiteIdSet().size() >= 2;
    }

    public void checkLunPairStatus(ProtectGroup protectGroup) {
        logger.debug((Object)"checkLunPairStatus when create lun snapshot");
        Set protectObjects = protectGroup.getPolist();
        if (11 != ((ProtectObject)protectObjects.iterator().next()).getPoType()) {
            return;
        }
        String tgtDeviceSn = protectGroup.getPoProviderSN();
        List<String> lunIds = this.getLunIdsByPO(protectObjects);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("tgtDevSN", tgtDeviceSn);
        props.put("tgtLunId", lunIds.toArray());
        List tgtLuns = moDao.findMoBy(ReplicationTargetLun.class, props);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)tgtLuns)) {
            return;
        }
        for (ProtectObject po : protectObjects) {
            Set resourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : resourceSet) {
                ReplicationTargetLun lun;
                List<ReplicationTargetLun> luns;
                String lunId = storageInfo.getResourceId();
                ReplicationTargetLun tgtLun = this.getTargetLuns(tgtLuns, lunId, tgtDeviceSn);
                if (null == tgtLun || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(luns = this.querySyncStatus(tgtLun, tgtDeviceSn)) || 2 != (lun = luns.get(0)).getPairStatus() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != lun.getPairStatus().intValue()) continue;
                logger.info((Object)"lun is synchronizing, can not create snapshot. lunId=%s.", new Object[]{lunId});
                throw new LegoCheckedException(1073948248L);
            }
        }
    }

    private ReplicationTargetLun getTargetLuns(List<ReplicationTargetLun> tgtLuns, String tgtLunId, String tgtDevSn) {
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            if (!tgtLunId.equals(tgtLun.getTgtLunId()) || !tgtDevSn.equals(tgtLun.getTgtDevSN()) || !tgtLun.getTgtDevSN().equals(tgtLun.getDevSn())) continue;
            return tgtLun;
        }
        return null;
    }

    private List<String> getLunIdsByPO(Set<ProtectObject> protectObjects) {
        ArrayList<String> lunIds = new ArrayList<String>();
        for (ProtectObject po : protectObjects) {
            Set resourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : resourceSet) {
                lunIds.add(storageInfo.getResourceId());
            }
        }
        return lunIds;
    }

    private List<ReplicationTargetLun> querySyncStatus(ReplicationTargetLun tgtLun, String tgtDeviceSn) {
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            return proxy.querySyncStatus(tgtLun.getDevSn(), tgtDeviceSn, tgtLun.getReplicationPairId(), false);
        }
        catch (LegoCheckedException e) {
            return null;
        }
    }

    public void checkReplicationPair(ProtectGroup protectGroup, ActionContext context) {
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType)) {
            return;
        }
        int location = NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION"));
        if (location == DrmEnumDefine.ProtectLocation.A_A.getValue()) {
            return;
        }
        ProtectGroupReplica pgReplica = protectGroup.getAnyoneReplicationReplica();
        if (pgReplica == null) {
            return;
        }
        HashSet<String> lunIds = new HashSet<String>();
        String srcDevsn = this.getSrcDevSN(pgReplica, lunIds);
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List pairList = storageService.getReplicationPairsByResourceIds(srcDevsn, new ArrayList<String>(lunIds));
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)"pairList size error! pgName:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948677L, new String[]{this.getLostPairId(pgReplica, pairList)});
        }
        Set<String> pairIds = this.getReplicationPairIds(pgReplica);
        for (ReplicationPair pair : pairList) {
            if (!pairIds.contains(pair.getReplicationId()) || this.isReplicationPairHealthStatusOK(pair)) continue;
            logger.error((Object)"pair status is not allowed.");
            throw new LegoCheckedException(1073948729L);
        }
    }

    private String getSrcDevSN(ProtectGroupReplica pgReplica, Set<String> result) {
        logger.debug((Object)"getAllFileSystemIds");
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getSrcStorageId());
                srcDevSn = storage.getSrcStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    private Set<String> getReplicationPairIds(ProtectGroupReplica pgReplica) {
        HashSet<String> set = new HashSet<String>();
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                if (!(storage instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)storage;
                set.add(remoteStorageReplica.getReplicationPairId());
            }
        }
        return set;
    }

    private String getLostPairId(ProtectGroupReplica pgReplica, List<ReplicationPair> pairList) {
        HashSet<String> pairIdList = new HashSet<String>();
        if (pairList != null) {
            for (ReplicationPair replicationPair : pairList) {
                pairIdList.add(replicationPair.getReplicationId());
            }
        }
        StringBuilder lostPairIds = new StringBuilder();
        for (ProtectObjectReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                String pairId = ((RemoteStorageReplica)storageInfo).getReplicationPairId();
                if (pairIdList.contains(pairId)) continue;
                lostPairIds.append(lostPairIds.length() == 0 ? pairId : ", " + pairId);
            }
        }
        return lostPairIds.toString();
    }

    private boolean isReplicationPairHealthStatusOK(ReplicationPair pair) {
        try {
            ArrayList<Integer> errorRunningStateList = new ArrayList<Integer>();
            errorRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue());
            errorRunningStateList.add(ReplicationConstantDefine.PairStatus.INVALID.getValue());
            errorRunningStateList.add(2);
            errorRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue());
            Integer runningState = Integer.valueOf(pair.getRunningState());
            if (errorRunningStateList.contains(runningState)) {
                return false;
            }
            Integer healthState = Integer.valueOf(pair.getHealthState());
            if (healthState.equals(6) || healthState.equals(XveEuumDefineParent.HEALTH_STATUS_E.FAULT.getValue())) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)("lun's healthState is error. healthState:" + pair.getHealthState() + "runningState:" + pair.getRunningState()), (Throwable)e);
        }
        return true;
    }

    public boolean isFullBackup(Map<String, Object> parameter) {
        if (null == parameter) {
            return false;
        }
        Boolean result = (Boolean)parameter.get("fullBackup");
        return null == result ? false : result;
    }

    public Integer getBackupTypeExcuteSync(Map<String, Object> parameter) {
        if (parameter == null) {
            return null;
        }
        return (Integer)parameter.get("backupTypeAfterSync");
    }
}

