/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupBaseServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.refinement.SynProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class AddProtectObjectsTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(AddProtectObjectsTransaction.class);
    private ProtectGroupBaseServiceImpl service = null;
    private ProtectGroup protectGroup = null;
    private BackTask backTask = null;
    private Set<TaskResultItem> resultSet;
    private ProtectGroupHelper helper = ProtectGroupHelper.getInstance();

    public AddProtectObjectsTransaction(ProtectGroupBaseServiceImpl service, ProtectGroup protectGroup, BackTask backTask, Set<TaskResultItem> resultSet) {
        this.service = service;
        this.protectGroup = protectGroup;
        this.backTask = backTask;
        this.resultSet = resultSet;
    }

    public Object doInTransaction(TransactionStatus status) {
        try {
            this.helper.checkAndBuildReplica(this.protectGroup);
            SynProtectGroupRefineService.getInstance().syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
            this.service.getBaseDao().update((Object)this.protectGroup);
            logger.debug((Object)"Add protect objects success for %s.", new Object[]{this.protectGroup.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"update protect group error", (Throwable)e, e.getErrorCode());
            this.helper.updateBatchTaskResult(this.backTask.getTaskResultSet(), Long.valueOf(e.getErrorCode()), e.getParameters());
            this.backTask.setTaskResultSet(this.resultSet);
            status.setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            this.helper.updateBatchTaskResult(this.backTask.getTaskResultSet(), Long.valueOf(-1L), new String[0]);
            this.backTask.setTaskResultSet(this.resultSet);
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)"update protect group error", (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }
}

