/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.group.util.ProtectGroupExcelOperator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ExcelUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportProtectGroupBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(ExportProtectGroupBackTask.class);
    private static final int MAX_RETAIN_FILE_SIZE = 10;
    private User operator;
    private int poType;
    private Locale locale = Locale.CHINA;
    private SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");

    public ExportProtectGroupBackTask(User operator, int poType, Locale locale) {
        super("ExportProtectGroupBackTask_UUID", BackTaskUtil.buildBackTask((String)"Protected group", (String)"ism.drm.pg.export", (String)operator.getUserName(), (String)"", null), true);
        this.operator = operator;
        this.poType = poType;
        if (locale != null) {
            this.locale = locale;
        }
    }

    protected void doWork() {
        IProtectGroupService pgServices = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgList = pgServices.getProtectGroupByType(this.poType, this.operator.getUserId(), true);
        CommUtil.checkObjectExists((Object[])new Object[]{pgList});
        ArrayList<ProtectGroup> tobeRemove = new ArrayList<ProtectGroup>();
        for (ProtectGroup protectgroup : pgList) {
            if (protectgroup.isPrimary()) continue;
            tobeRemove.add(protectgroup);
        }
        pgList.removeAll(tobeRemove);
        if (!VerifyUtil.isEmpty(tobeRemove) && VerifyUtil.isEmpty((Collection)pgList)) {
            logger.warn((Object)"protectgroups is empty");
            throw new LegoCheckedException(1073948198L);
        }
        this.exportExcel(pgList, new BatchOperationResult());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportExcel(List<ProtectGroup> pgList, BatchOperationResult result) {
        ProtectGroupExcelOperator protectGroupExcelOperator = new ProtectGroupExcelOperator();
        FileOutputStream fileOutputStream = null;
        SXSSFWorkbook wb = null;
        try {
            this.deleteOldFiles();
            logger.info((Object)"Downloading file of protect group info.");
            wb = protectGroupExcelOperator.createExportExcel(pgList, result, this.locale);
            String fileName = CommUtil.combineString((String[])new String[]{String.valueOf(this.operator.getUserId()), this.df.format(new Date()), UUIDGenerator.getUUID()}) + ".xlsx";
            File excelFile = new File(PathUtil.getExportPath() + fileName);
            if (excelFile.getParentFile().mkdirs()) {
                logger.debug((Object)"mkdirs");
            }
            fileOutputStream = new FileOutputStream(excelFile);
            wb.write((OutputStream)fileOutputStream);
            String taskLink = String.format(Locale.ENGLISH, "/protectgroups/action/downloadfile?taskid=%s&file=%s", this.getBackTask().getTaskId(), fileName);
            this.getBackTask().setTaskLink(taskLink);
        }
        catch (LegoCheckedException e) {
            try {
                logger.error((Object)"Creating exported excel failed.", (Throwable)e);
                throw e;
                catch (Throwable ex) {
                    logger.error((Object)"export excel error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    throw new LegoCheckedException(1073948423L, ex);
                }
            }
            catch (Throwable throwable) {
                ExcelUtil.closeExcelExport(wb, fileOutputStream);
                logger.info((Object)"Downloaded file of protect group info.");
                throw throwable;
            }
        }
        ExcelUtil.closeExcelExport((SXSSFWorkbook)wb, (FileOutputStream)fileOutputStream);
        logger.info((Object)"Downloaded file of protect group info.");
    }

    private void deleteOldFiles() {
        File exportFolder = new File(PathUtil.getExportPath());
        if (!exportFolder.exists() || !exportFolder.isDirectory() || null == exportFolder.listFiles()) {
            logger.debug((Object)"exportFolder not exist.");
            return;
        }
        List files = FileUtil.listFile((File)exportFolder);
        TreeMap<String, File> timeFileMap = new TreeMap<String, File>();
        for (File file : files) {
            String userIdStrForSso;
            String fileName = file.getName();
            if (!fileName.contains("-")) continue;
            int index = fileName.indexOf("-");
            if (index == 0 && fileName.length() > 1) {
                index = fileName.indexOf("-", 1);
            }
            if (index == -1) continue;
            String userIdStr = fileName.substring(0, index);
            String timestamp = fileName.substring(index);
            timeFileMap.put(timestamp, file);
            String string = userIdStrForSso = userIdStr.indexOf("-") == 0 ? userIdStr.replaceFirst("-", "") : userIdStr;
            if (!NumberUtils.isDigits((String)userIdStr) && !NumberUtils.isDigits((String)userIdStrForSso) || !this.operator.getUserId().equals(NumberUtils.toLong((String)userIdStr)) || !file.delete()) continue;
            logger.debug((Object)"delete file:%s", new Object[]{fileName});
        }
        List currentFiles = FileUtil.listFile((File)exportFolder);
        if (currentFiles.size() <= 10) {
            return;
        }
        logger.warn((Object)"Retain file more than limit, delete old file.");
        int deleteIndex = currentFiles.size() - 10;
        Iterator keySetIterator = timeFileMap.keySet().iterator();
        while (keySetIterator.hasNext() && deleteIndex > 0) {
            String key = (String)keySetIterator.next();
            File file = (File)timeFileMap.get(key);
            if (!file.delete()) continue;
            --deleteIndex;
        }
    }
}

