/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.protection.framework.service.group.util.ProtectGroupBlockingQueue;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.concurrent.Semaphore;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ProtectGroupAutoBuilderService
implements InitializingBean,
DisposableBean,
Runnable {
    private static final Log logger = LogFactory.getInstance(ProtectGroupAutoBuilderService.class);
    private static boolean threadRuningState;
    private static Semaphore pgBuilderSemaphore;

    private static void setThreadRunningFlag(boolean flag) {
        threadRuningState = flag;
    }

    private static boolean isThreadRunning() {
        return threadRuningState;
    }

    public void destroy() {
        ProtectGroupAutoBuilderService.setThreadRunningFlag(false);
    }

    public void afterPropertiesSet() {
        ProtectGroupAutoBuilderService.setThreadRunningFlag(true);
        ExecutionService.submitTask((Runnable)this);
    }

    @Override
    public void run() {
        while (ProtectGroupAutoBuilderService.isThreadRunning()) {
            ProtectGroup protectGroup = null;
            Boolean isAutoCreateRp = false;
            try {
                pgBuilderSemaphore.acquire();
                protectGroup = ProtectGroupBlockingQueue.take();
                ProtectGroupBlockingQueue.addToExcutingQueue((ProtectGroup)protectGroup);
                String autoCreateRp = (String)protectGroup.getProps().get("isAutoCreateRp");
                if (!VerifyUtil.isEmpty((String)autoCreateRp)) {
                    isAutoCreateRp = autoCreateRp.equalsIgnoreCase("true");
                }
                ServiceLocator.getInstance().getService(IProtectGroupService.class);
                long taskId = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).createProtectGroup(protectGroup, isAutoCreateRp.booleanValue());
                ReleaseSemaphoreTask releaseSemaphoreTask = new ReleaseSemaphoreTask(taskId, pgBuilderSemaphore, protectGroup);
                ExecutionService.submitTask((Runnable)releaseSemaphoreTask);
            }
            catch (Exception e) {
                logger.error((Object)"Auto create ProtectGroup error, pg name(%s)", new Object[]{protectGroup != null ? protectGroup.getName() : ""});
                ProtectGroupBlockingQueue.removeFromExcutingQueue((ProtectGroup)protectGroup);
                pgBuilderSemaphore.release();
            }
        }
    }

    static {
        long excuteNum = LegoConfig.getInstance().getNumber("batch_create_pg_num", 15L);
        pgBuilderSemaphore = new Semaphore((int)excuteNum);
    }

    private static class ReleaseSemaphoreTask
    implements Runnable {
        private long taskId;
        private Semaphore pgBuilderSemaphore;
        private ProtectGroup protectGroup;

        public ReleaseSemaphoreTask(long taskId, Semaphore pgBuilderSemaphore, ProtectGroup protectGroup) {
            this.taskId = taskId;
            this.pgBuilderSemaphore = pgBuilderSemaphore;
            this.protectGroup = protectGroup;
        }

        @Override
        public void run() {
            try {
                BackTaskUtil.monitorTaskResult((long)this.taskId, (long)172800L, (long)5L);
            }
            catch (Exception e) {
                logger.error((Object)"Add task error: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            finally {
                ProtectGroupBlockingQueue.removeFromExcutingQueue((ProtectGroup)this.protectGroup);
                this.pgBuilderSemaphore.release();
            }
        }
    }
}

