/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.AbstractProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.AddProtectObjectsBackTask;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectGroupTask;
import com.huawei.ism.drm.protection.framework.service.group.ExportProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.UpdateProtectGroupInfoTask;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.DiskStoragePool;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.RemoteSiteMonitorTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService", desc="", interfaceClass=IProtectGroupBaseService.class)
public class ProtectGroupBaseServiceImpl
extends AbstractProtectGroupServiceImpl
implements IProtectGroupBaseService {
    private static final Log logger = LogFactory.getInstance(ProtectGroupBaseServiceImpl.class);

    protected List<ProtectLocationPath> initLocalProtectLocationPath(ProtectGroup protectGroup) {
        List storageInfoList = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)storageInfoList)) {
            return new ArrayList<ProtectLocationPath>();
        }
        ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)storageInfoList.iterator().next();
        IStorageService service = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List lunList = service.getStorageResourceByWwn(new String[]{info.getLunWWN()});
        ArrayList<ProtectLocationPath> localProtectionPathList = new ArrayList<ProtectLocationPath>();
        int index = 1;
        for (StorageResource storageResource : lunList) {
            ProtectLocationPath path = new ProtectLocationPath();
            path.setProtectedSiteId(protectGroup.getProductSiteId());
            path.setRecoverySiteId(protectGroup.getProductSiteId());
            int protectionLocation = DrmEnumDefine.ProtectLocation.A_A.getValue();
            if (index == 2) {
                protectionLocation = DrmEnumDefine.ProtectLocation.B_B.getValue();
            }
            path = this.buildProtectionPath(storageResource.getDevSn(), storageResource.getDevSn(), protectionLocation);
            localProtectionPathList.add(path);
            ++index;
        }
        return localProtectionPathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateProtectGroupBasicInfo(ProtectGroup protectGroup, Boolean isFromMachine) {
        ProtectGroupUtil.getInstance().validateProtectGroupObj(protectGroup);
        if (!this.checkGroupNameForUpdate(protectGroup.getUuid(), protectGroup.getName())) {
            logger.error((Object)"failed to update protectGroup because of duplicate groupname.", 90160758786897L);
            throw new LegoCheckedException(1073947392L);
        }
        ProtectGroup oldPg = this.getProtectGroupBasicInfo(protectGroup.getUuid(), false);
        if (oldPg == null) {
            logger.error((Object)"failed to update protectGroup because the oldPg is null.", 90160758786897L);
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkOptStatus(ProtectGroupHelper.ProtectGroupOpt.MOFIFY.getStatus(), oldPg.getStatus());
        if (!oldPg.isPrimary() && !isFromMachine.booleanValue()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", oldPg.getUuid());
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("pgId", oldPg.getUuid());
            obj.put("uuid", oldPg.getUuid());
            obj.put("name", protectGroup.getName());
            obj.put("description", protectGroup.getDescription());
            try {
                long taskId = ProtectGroupExtendUtil.getInstance().invokeProductSiteMethod(oldPg.getProductSiteId(), "/ws/protectgroups/{protectGroupId}", JSONObject.fromObject(obj).toString(), uriVariables, HttpMethod.PUT);
                RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(oldPg.getProductSiteId(), taskId);
                task.setMonitorInterval(3L);
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                return taskId;
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode != 1073947394L) {
                    logger.error((Object)errorCode, (Throwable)e, 90160758787071L);
                    ExceptionUtil.rethrowException((Exception)((Object)e), (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters());
                }
                logger.info((Object)"PG from product site is not existed, so forcibly delete the PG from the disaster site ", 90160758787071L);
            }
        }
        Object object = THREAD_LOCK;
        synchronized (object) {
            UpdateProtectGroupInfoTask task = new UpdateProtectGroupInfoTask((IProtectGroupBaseService)this, protectGroup);
            if (!oldPg.isPrimary() && isFromMachine.booleanValue()) {
                task.doWork();
                return -1L;
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }

    public long deleteProtectGroup(String protectGroupId, Boolean isFromMachine) {
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            logger.error((Object)"cannot get protectGroup", 90160758786893L);
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DELETE, protectGroup);
        boolean isUsedProtectGroupByRp = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedProtectGroupByAllRp(protectGroupId);
        if (isUsedProtectGroupByRp) {
            logger.error((Object)("ProtectGroup(" + protectGroupId + ") is used by RecoveryPlan."), 90160758786893L);
            throw new LegoCheckedException(1073948160L);
        }
        if (!protectGroup.isPrimary() && !isFromMachine.booleanValue()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", protectGroup.getUuid());
            try {
                long taskId = ProtectGroupExtendUtil.getInstance().invokeProductSiteMethod(protectGroup.getProductSiteId(), "/ws/protectgroups/{protectGroupId}", null, uriVariables, HttpMethod.DELETE);
                RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(protectGroup.getProductSiteId(), taskId);
                task.setMonitorInterval(3L);
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                return taskId;
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode != 1073947394L) {
                    logger.error((Object)errorCode, (Throwable)e, 90160758787071L);
                    ExceptionUtil.rethrowException((Exception)((Object)e), (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters());
                }
                logger.info((Object)"PG from product site is not existed, so forcibly delete the PG from the disaster site ", 90160758787071L);
            }
        }
        DeleteProtectGroupTask task = new DeleteProtectGroupTask((IProtectGroupBaseService)this, protectGroup);
        if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
            task.setTimeout(2147483);
        }
        if (!protectGroup.isPrimary() && isFromMachine.booleanValue()) {
            task.doWork();
            return -1L;
        }
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public long exportProtectGroupByType(User user, int poType, Locale locale, boolean isExportChecked) {
        if (isExportChecked) {
            ExportProtectGroupBackTask task = new ExportProtectGroupBackTask(user, poType, locale);
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        List pgList = this.getProtectGroupByType(poType, user.getUserId(), false);
        CommUtil.checkObjectExists((Object[])new Object[]{pgList});
        ArrayList<ProtectGroup> tobeRemove = new ArrayList<ProtectGroup>();
        for (ProtectGroup protectgroup : pgList) {
            if (protectgroup.isPrimary()) continue;
            tobeRemove.add(protectgroup);
        }
        pgList.removeAll(tobeRemove);
        if (!VerifyUtil.isEmpty(tobeRemove) && VerifyUtil.isEmpty((Collection)pgList)) {
            logger.warn((Object)"protectgroups is empty", 90160758786989L);
            throw new LegoCheckedException(1073948198L);
        }
        return 0L;
    }

    public long addProtectObjects(String protectGroupId, Set<ProtectObject> protectObjectSet) {
        logger.debug((Object)"enter addProtectObjects");
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            logger.error((Object)"failed to add ProtectObjects because of invalidity paramiter.", 90160758786898L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectObjectQuantity(protectObjectSet.size());
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)("The pg is locked: " + protectGroupId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.ADD, protectGroup);
            ProtectGroupHelper.getInstance().checkAddOrRemovePoIsAvailable(protectGroup);
            ProtectGroup tempProtectGroup = (ProtectGroup)protectGroup.clone();
            tempProtectGroup.setPolist(new HashSet<ProtectObject>(protectObjectSet));
            tempProtectGroup.setOwnerId(protectObjectSet.iterator().next().getOwnerId());
            this.updateProtectObjectProperties(tempProtectGroup);
            tempProtectGroup.getPolist().addAll(protectGroup.getPolist());
            this.checkProtectObjectsInProtectGroup(tempProtectGroup);
            HashSet logs = new HashSet(protectGroup.getPgHistoryLogs());
            protectGroup.setPgHistoryLogs(logs);
            ProtectGroupHelper.getInstance().validateProtectGroupParameter(protectGroup, false);
            AddProtectObjectsBackTask task = new AddProtectObjectsBackTask(this, protectGroup, protectObjectSet);
            if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
                task.setTimeout(2147483);
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Error to clone ProtectGroup", (Throwable)e, 90160758787071L);
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (LegoCheckedException e1) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw e1;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public List<ProtectGroupLogDetail> queryRunningHistoryLog(String protectGroupId) {
        logger.debug((Object)"queryRunningHistoryLog");
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            throw new LegoCheckedException(1073947394L);
        }
        Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
        if (!VerifyUtil.isEmpty((Object)productSite) && 1 == productSite.getSiteType()) {
            return this.queryPgRunningHistoryLog(protectGroup);
        }
        return this.queryPgRunningHistoryLog(protectGroupId);
    }

    private List<ProtectGroupLogDetail> queryPgRunningHistoryLog(ProtectGroup protectGroup) {
        logger.debug((Object)"queryPgRunningHistoryLog");
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)productSite)) {
            throw new LegoCheckedException(1073947394L);
        }
        RestClient client = SiteUtil.initClient((Site)productSite);
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        uriVariables.put("logId", -1);
        String result = client.invoke("/ws/protectgroups/{protectGroupId}/logs/{logId}/details", uriVariables, HttpMethod.GET);
        List pgLogDetails = ProtectGroupUtil.getInstance().transJsonToLogDetail(result);
        return pgLogDetails;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus status, String ... protectGroupIds) {
        boolean bl;
        logger.debug((Object)"enter updateProtectGroupStatus");
        String currentPgId = "";
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                PolicyTemplate policyTemplate;
                String protectGroupId;
                currentPgId = protectGroupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                ProtectGroupSynchronizer.getInstance().syncProtectGroupStatus(status.getStatus(), protectGroup);
                session.beginTransaction();
                String sql = "UPDATE ti_protectgroup SET STATUS=:pgStatus WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("pgStatus", status.getStatus());
                query.setString("pgid", protectGroupId);
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 != updateResult) {
                    logger.error((Object)"Update protectGroup status failed!", 90160758786989L);
                    throw new LegoCheckedException(-1L);
                }
                if (status.getStatus() == DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus()) {
                    this.protectionTaskService.deleteTasks(protectGroupId);
                    this.deleteSyncRateTask(protectGroupId);
                    continue;
                }
                if (status.getStatus() != DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() || VerifyUtil.isEmpty((Map)(policyTemplate = protectGroup.getTemplate()).getProps())) continue;
                List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)policyTemplate);
                this.getConfigSyncRateService().updateSyncRateTask(protectGroupId, pgsrps);
                this.getConfigSyncRateService().runAtOnce(protectGroup, pgsrps, false);
            }
            bl = true;
        }
        catch (LegoCheckedException le) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("failed to update status of protectgroup(" + currentPgId + ")."), (Throwable)le, 90160758784001L);
                throw le;
                catch (DataAccessException e) {
                    DBOperationUtil.rollbackSession(session);
                    logger.error((Object)("failed to update status of protectgroup(" + currentPgId + ")."), (Throwable)e, 90160758786898L);
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }

    public boolean lockProtectGroup(String ... protectGroupIds) {
        logger.debug((Object)"enter lockProtectGroup");
        String protectGroupId = "";
        try {
            for (int i = 0; i < protectGroupIds.length; ++i) {
                protectGroupId = protectGroupIds[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                if (DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus() == protectGroup.getStatus()) {
                    logger.debug((Object)"no need lock pg:%s", new Object[]{protectGroup.getName()});
                    continue;
                }
                ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.LOCK, protectGroup);
                MessageEvent event = this.constructEnableMessage(protectGroup, 10);
                this.notifyObserverList(event, "before");
                if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == protectGroup.getStatus()) continue;
                this.protectionTaskService.pauseTasks(protectGroupId);
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus());
                protectGroup.setLockTime(Long.valueOf(new Date().getTime()));
                ProtectGroupSynchronizer.getInstance().syncProtectGroupStatus(protectGroup);
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                this.notifyObserverList(event, "after");
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("the protectgroup(" + protectGroupId + ") is failed to lock."), (Throwable)le, 90160758784001L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("the protectgroup(" + protectGroupId + ") is failed to lock."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return true;
    }

    public boolean unlockProtectGroup(String ... protectGroupIds) {
        logger.debug((Object)"enter unlockProtectGroup");
        String protectGroupId = "";
        try {
            for (int i = 0; i < protectGroupIds.length; ++i) {
                protectGroupId = protectGroupIds[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UNLOCK, protectGroup);
                MessageEvent event = this.constructEnableMessage(protectGroup, 11);
                this.notifyObserverList(event, "before");
                if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == protectGroup.getStatus()) continue;
                this.protectionTaskService.resumeTasks(protectGroupId);
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
                protectGroup.setLockTime(null);
                ProtectGroupSynchronizer.getInstance().syncProtectGroupStatus(protectGroup);
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                this.notifyObserverList(event, "after");
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("the protectgroup(" + protectGroupId + ") is failed to unlock."), (Throwable)le, 90160758784001L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("the protectgroup(" + protectGroupId + ") is failed to unlock."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disableProtectGroup(String protectGroupId) {
        logger.debug((Object)"enter disableProtectGroup");
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)("The pg is locked: " + protectGroupId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DISABLE, protectGroup);
            MessageEvent event = this.constructEnableMessage(protectGroup, 8);
            this.notifyObserverList(event, "before");
            this.protectionTaskService.pauseTasks(protectGroupId);
            this.deleteSyncRateTask(protectGroupId);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus());
            ProtectGroupSynchronizer.getInstance().syncProtectGroupStatus(protectGroup);
            ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
            this.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("the protectgroup(" + protectGroupId + ") is failed to disable."), (Throwable)le, 90160758784001L);
            this.protectionTaskService.resumeTasks(protectGroupId);
            throw le;
        }
        catch (Exception e) {
            this.protectionTaskService.resumeTasks(protectGroupId);
            ExceptionUtil.rethrowException((Throwable)e, (String)("the protectgroup(" + protectGroupId + ") is failed to disable."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableProtectGroup(String protectGroupId) {
        logger.debug((Object)"enter enableProtectGroup");
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)("The pg is locked: " + protectGroupId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.ENABLE, protectGroup);
            MessageEvent event = this.constructEnableMessage(protectGroup, 9);
            this.notifyObserverList(event, "before");
            this.protectionTaskService.resumeTasks(protectGroupId);
            this.resumeSyncRateTask(protectGroup);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
            ProtectGroupSynchronizer.getInstance().syncProtectGroupStatus(protectGroup);
            ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
            this.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("the protectgroup(" + protectGroupId + ") is failed to enable."), (Throwable)le, 90160758784001L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("the protectgroup(" + protectGroupId + ") is failed to enable."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        return true;
    }

    public long updateProtectGroupTemplate(String protectGroupId, Map<String, String> policyTemplateProps) {
        if (protectGroupId == null || VerifyUtil.isEmpty(policyTemplateProps)) {
            logger.error((Object)"param is error.", 90160758786893L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(policyTemplateProps)) {
            logger.error((Object)"policyTemplateProps is error.", 90160758786893L);
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate template = ProtectGroupBaseServiceImpl.queryPolicyTemplateByProtectGroup((String)protectGroupId);
        Map props = template.getProps();
        props.putAll(policyTemplateProps);
        ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).filterSensitiveParam(template);
        return this.updateProtectGroupTemplate(protectGroupId, template);
    }

    public List<ProtectObject> getProtectObjectListByRealMoUUID(List<String> moUuIds) {
        if (VerifyUtil.isEmpty(moUuIds)) {
            logger.error((Object)"Failed to getProtectObjectListByMoUUID because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupExtendHelper.getInstance().getProtectObjectListByRealMoUUID(moUuIds);
    }

    public List<DiskInfo> queryDiskInfo(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"Method getUseHyperMetroStorage failed, protectGroupId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"ProtectGroup(%s) not exist.", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073947394L);
        }
        return this.queryDiskInfo(protectGroup);
    }

    public synchronized List<DiskInfo> queryDiskInfo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"GetUseHyperMetroStorage failed, protectGroupId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<StoragePair> storagePairs = new ArrayList<StoragePair>();
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        if (!VerifyUtil.isEmpty((String)replicationCfg)) {
            List pairs = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)replicationCfg), StoragePair.class);
            storagePairs.addAll(pairs);
        }
        HashMap<String, String> poolIdAndNameInfoMap = new HashMap<String, String>();
        List storagePoolInfos = CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePoolInfos)) {
            for (StoragePool pool : storagePoolInfos) {
                poolIdAndNameInfoMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameInfoMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        List<DiskInfo> diskInfos = this.getDiskInfos(protectGroup);
        this.buildRecoveryPool(protectGroup, diskInfos, storagePairs, poolIdAndNameInfoMap);
        if (logger.isDebugEnabled()) {
            ProtectGroupExtendUtil.logDiskInfo(protectGroup.getName(), diskInfos);
        }
        return diskInfos;
    }

    protected void checkExpandLunByHypermetro(List<DiskInfo> diskInfos) {
        diskInfos.stream().filter(diskInfo -> DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskInfo.getStatus())).forEach(diskInfo -> {
            SubDiskInfo subDiskInfo = diskInfo.getSubDiskInfo().stream().findFirst().orElse(null);
            if (subDiskInfo != null && diskInfo.getCapacity() != null && !diskInfo.getCapacity().equals(subDiskInfo.getCapacity())) {
                logger.info((Object)"Src lun id: %s, capacity: %s,targetLun id: %s,capacity: %s.", new Object[]{diskInfo.getResourceId(), diskInfo.getCapacity(), subDiskInfo.getResourceId(), subDiskInfo.getCapacity()});
                diskInfo.setStatus(DiskProtectStatusEnum.EXPANDED.getStatus());
            }
        });
    }

    protected List<DiskInfo> getDiskInfos(ProtectGroup protectGroup) {
        ArrayList<DiskInfo> diskInfos = new ArrayList<DiskInfo>();
        if (ProtectGroupExtendUtil.isHyperMetroOfSmallLun(protectGroup)) {
            this.buildDiskInfoByHypermetro(diskInfos, protectGroup);
            this.checkExpandLunByHypermetro(diskInfos);
        } else {
            HashMap<String, List<ProtectObject>> storagePoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, ProtectObjectStorageInfo> poStorageMap = new HashMap<String, ProtectObjectStorageInfo>();
            HashMap<String, List<RelicaStorageInfo>> storageReplicaMap = new HashMap<String, List<RelicaStorageInfo>>();
            HashMap<String, StorageResource> storageResourceMap = new HashMap<String, StorageResource>();
            this.getStorageMap(protectGroup, storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap);
            this.getDiskInfoFromPo(storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap, diskInfos);
            this.getDiskInfoFromReplica(storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap, diskInfos);
            this.checkLunToBeExpand(diskInfos);
        }
        return diskInfos;
    }

    protected void checkLunToBeExpand(List<DiskInfo> diskInfos) {
        HashMap lunInfo = new HashMap();
        diskInfos.forEach(diskInfo -> diskInfo.getSubDiskInfo().forEach(diskInfo1 -> {
            if (lunInfo.containsKey(diskInfo1.getDevSn())) {
                ((List)lunInfo.get(diskInfo1.getDevSn())).add(diskInfo1.getResourceId());
            } else {
                ArrayList<String> lunId = new ArrayList<String>();
                lunId.add(diskInfo1.getResourceId());
                lunInfo.put(diskInfo1.getDevSn(), lunId);
            }
        }));
        ArrayList lunList = new ArrayList();
        for (Map.Entry entry : lunInfo.entrySet()) {
            String devSn = (String)entry.getKey();
            List targetLuns = (List)entry.getValue();
            logger.info((Object)String.format(Locale.ROOT, "Query lun info, targetLuns : %s.", targetLuns.toString()));
            List lunLists = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSn, targetLuns, Lun.class);
            if (lunLists.isEmpty()) continue;
            lunList.addAll(lunLists);
        }
        diskInfos.stream().filter(diskInfo -> DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskInfo.getStatus())).forEach(diskInfo -> this.checkLunToBeExpandForDiskInfo(lunList, (DiskInfo)diskInfo));
    }

    protected void checkLunToBeExpandForDiskInfo(List<Lun> lunList, DiskInfo diskInfo) {
        diskInfo.getSubDiskInfo().forEach(subDiskInfo -> this.checkLunToBeExpandForSubDiskInfos(lunList, diskInfo, (SubDiskInfo)subDiskInfo));
    }

    protected void checkLunToBeExpandForSubDiskInfos(List<Lun> lunList, DiskInfo diskInfo, SubDiskInfo subDiskInfo) {
        lunList.forEach(lun -> this.checkLunToBeExpandForSubDiskInfo(diskInfo, subDiskInfo, (Lun)lun));
    }

    protected void checkLunToBeExpandForSubDiskInfo(DiskInfo diskInfo, SubDiskInfo subDiskInfo, Lun lun) {
        if (lun.getDevSn().equals(subDiskInfo.getDevSn()) && lun.getResourceId().equals(subDiskInfo.getResourceId()) && lun.getTotalCapacity() < (double)diskInfo.getCapacity().longValue()) {
            logger.info((Object)"Src lun id :%s,capacity :%s, targetLun id:%s, capacity :%s.", new Object[]{diskInfo.getResourceId(), diskInfo.getCapacity(), lun.getResourceId(), lun.getTotalCapacity()});
            subDiskInfo.setCapacity(Long.valueOf(lun.getTotalCapacity().longValue()));
            subDiskInfo.setName(lun.getName());
            diskInfo.setStatus(DiskProtectStatusEnum.EXPANDED.getStatus());
        }
    }

    protected void getDiskInfoFromReplica(Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap, List<DiskInfo> diskInfos) {
        for (Map.Entry<String, List<RelicaStorageInfo>> entry : storageReplicaMap.entrySet()) {
            ProtectObjectStorageInfo poStorageInfo;
            String key = entry.getKey();
            if (storagePoMap.containsKey(key)) continue;
            String deviceName = "--";
            String poolId = "--";
            String poolName = "--";
            StorageResource storageResource = storageResourceMap.get(key);
            if (storageResource != null && storageResource instanceof Lun) {
                Lun lun = (Lun)storageResource;
                poolId = lun.getStoragePoolId();
                poolName = lun.getStoragePoolName();
            }
            if ((poStorageInfo = poStorageMap.get(key)) != null) {
                deviceName = poStorageInfo.getDeviceName();
            }
            List<RelicaStorageInfo> list = entry.getValue();
            ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
            HashSet<String> poMoUuidSet = new HashSet<String>();
            for (RelicaStorageInfo relicaStorageInfo : list) {
                if (relicaStorageInfo.getPoReplica() == null || relicaStorageInfo.getPoReplica().getProtectObject() == null) {
                    logger.error((Object)"can not find protectobject for: %s.", new Object[]{relicaStorageInfo.toJson().toString()});
                    continue;
                }
                ProtectObject po = relicaStorageInfo.getPoReplica().getProtectObject();
                if (poMoUuidSet.contains(po.getMoUuid())) continue;
                poMoUuidSet.add(po.getMoUuid());
                protectObjects.add(po);
            }
            String status = DiskProtectStatusEnum.REMOVED.getStatus();
            String devSn = key.split("-")[0];
            DiskInfo diskInfo = new DiskInfo();
            diskInfo.setDevSn(devSn);
            String resourceId = key.split("-")[1];
            diskInfo.setResourceId(resourceId);
            diskInfo.setDeviceName(deviceName);
            diskInfo.setStatus(status);
            diskInfo.setPoolId(poolId);
            diskInfo.setPoolName(poolName);
            diskInfo.setProtectObjects(protectObjects);
            diskInfos.add(diskInfo);
        }
    }

    protected void getDiskInfoFromPo(Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap, List<DiskInfo> diskInfos) {
        for (Map.Entry<String, List<ProtectObject>> entry : storagePoMap.entrySet()) {
            String key = entry.getKey();
            String poolId = "--";
            String poolName = "--";
            Long capacity = 0L;
            StorageResource storageResource = storageResourceMap.get(key);
            if (storageResource != null && storageResource instanceof Lun) {
                Lun lun = (Lun)storageResource;
                poolId = lun.getStoragePoolId();
                capacity = lun.getTotalCapacity().longValue();
                poolName = lun.getStoragePoolName();
            }
            ProtectObjectStorageInfo poStorageInfo = poStorageMap.get(key);
            String deviceName = "--";
            if (poStorageInfo != null) {
                deviceName = poStorageInfo.getDeviceName();
            }
            String status = DiskProtectStatusEnum.PROTECTED.getStatus();
            DiskInfo diskInfo = new DiskInfo();
            if (!storageReplicaMap.containsKey(key)) {
                status = DiskProtectStatusEnum.UNPROTECTED.getStatus();
            } else {
                storageReplicaMap.get(key).forEach(relicaStorageInfo -> {
                    SubDiskInfo subDiskInfo = new SubDiskInfo();
                    subDiskInfo.setResourceId(relicaStorageInfo.getStorageId());
                    subDiskInfo.setDevSn(relicaStorageInfo.getStorageProviderSN());
                    diskInfo.getSubDiskInfo().add(subDiskInfo);
                });
            }
            String devSn = key.split("-")[0];
            diskInfo.setDevSn(devSn);
            String resourceId = key.split("-")[1];
            diskInfo.setResourceId(resourceId);
            diskInfo.setDeviceName(deviceName);
            diskInfo.setStatus(status);
            diskInfo.setPoolId(poolId);
            diskInfo.setPoolName(poolName);
            diskInfo.setCapacity(capacity);
            diskInfo.setProtectObjects(entry.getValue());
            diskInfos.add(diskInfo);
        }
    }

    protected void getStorageMap(ProtectGroup protectGroup, Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap) {
        HashMap deviceStorageMap = new HashMap();
        Set polist = protectGroup.getPolist();
        for (ProtectObject protectObject : polist) {
            Set set = protectObject.getUsedStorageResourceSet();
            for (Object poStorageInfo : set) {
                if (VerifyUtil.isEmpty((String)poStorageInfo.getResourceProviderSN()) || VerifyUtil.isEmpty((String)poStorageInfo.getResourceId())) continue;
                String key = CommUtil.combineString((String[])new String[]{poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId()});
                CommUtil.addToMap(storagePoMap, (String)key, (Object)protectObject);
                poStorageMap.put(key, (ProtectObjectStorageInfo)poStorageInfo);
                CommUtil.addToMap(deviceStorageMap, (String)poStorageInfo.getResourceProviderSN(), (Object)poStorageInfo.getResourceId());
            }
        }
        Set replicaList = protectGroup.getReplicaList();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set replicas = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : replicas) {
                Set storageInfos = protectObjectReplica.getStorageInfos();
                for (RelicaStorageInfo storageInfo : storageInfos) {
                    String key = CommUtil.combineString((String[])new String[]{storageInfo.getSrcStorageProviderSN(), storageInfo.getSrcStorageId()});
                    CommUtil.addToMap(storageReplicaMap, (String)key, (Object)storageInfo);
                    CommUtil.addToMap(deviceStorageMap, (String)storageInfo.getSrcStorageProviderSN(), (Object)storageInfo.getSrcStorageId());
                }
            }
        }
        for (Map.Entry entry : deviceStorageMap.entrySet()) {
            String deviceSn = (String)entry.getKey();
            List idList = (List)entry.getValue();
            List storageRes = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(deviceSn, idList);
            for (StorageResource storageResource : storageRes) {
                storageResourceMap.put(CommUtil.combineString((String[])new String[]{deviceSn, storageResource.getResourceId()}), storageResource);
            }
        }
    }

    protected void buildDiskInfoByHypermetro(List<DiskInfo> diskInfos, ProtectGroup protectGroup) {
        if (!ProtectGroupExtendUtil.isHyperMetroOfSmallLun(protectGroup)) {
            logger.info((Object)"Not support hypermetro pg.");
            return;
        }
        StoragePair storagePair = null;
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        if (!VerifyUtil.isEmpty((String)replicationCfg)) {
            storagePair = (StoragePair)JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)replicationCfg), StoragePair.class).get(0);
        }
        if (storagePair == null) {
            throw new LegoCheckedException(1073947394L, "StoragePair is null.");
        }
        HashMap<String, ProtectObjectStorageInfo> poStorageMap = new HashMap<String, ProtectObjectStorageInfo>();
        Set poList = protectGroup.getPolist();
        for (ProtectObject protectObject : poList) {
            Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
            Iterator iterator = usedStorageResourceSet.iterator();
            while (iterator.hasNext()) {
                ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)iterator.next();
                poStorageMap.put(poStorageInfo.getResourceName(), poStorageInfo);
            }
        }
        HashMap<String, RelicaStorageInfo> storageReplicaMap = new HashMap<String, RelicaStorageInfo>();
        Set replicaList = protectGroup.getReplicaList();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set replicas = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : replicas) {
                Set storageInfos = protectObjectReplica.getStorageInfos();
                for (RelicaStorageInfo storageInfo : storageInfos) {
                    storageReplicaMap.put(storageInfo.getStorageName(), storageInfo);
                }
            }
        }
        ProtectObject po = protectGroup.getPolist().stream().findFirst().orElse(null);
        this.getDiskFromPoStorage(po, poStorageMap, storageReplicaMap, diskInfos, storagePair);
        this.getDiskFromRelicaStorage(po, poStorageMap, storageReplicaMap, diskInfos, storagePair);
    }

    protected void getDiskFromPoStorage(ProtectObject po, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, RelicaStorageInfo> storageReplicaMap, List<DiskInfo> diskInfos, StoragePair storagePair) {
        String srcDevSn = storagePair.getSrcDevSN();
        String tgtDevSn = storagePair.getTgtDevSN();
        for (Map.Entry<String, ProtectObjectStorageInfo> entry : poStorageMap.entrySet()) {
            String key = entry.getKey();
            DiskInfo diskInfo = new DiskInfo();
            String status = storageReplicaMap.containsKey(key) ? DiskProtectStatusEnum.PROTECTED.getStatus() : DiskProtectStatusEnum.UNPROTECTED.getStatus();
            ArrayList<String> resourceNames = new ArrayList<String>();
            resourceNames.add(key);
            diskInfo.setDevSn(srcDevSn);
            diskInfo.setStatus(status);
            diskInfo.setDeviceName(key);
            ProtectObjectStorageInfo poStorageInfo = entry.getValue();
            diskInfo.setName(poStorageInfo.getDeviceName());
            ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
            poList.add(po);
            diskInfo.setProtectObjects(poList);
            SubDiskInfo subDiskInfo = new SubDiskInfo();
            subDiskInfo.setDevSn(tgtDevSn);
            diskInfo.getSubDiskInfo().add(subDiskInfo);
            StorageResource srcStorage = this.getSrcStorageResource(srcDevSn, resourceNames);
            StorageResource tgtStorage = this.getSrcStorageResource(tgtDevSn, resourceNames);
            if (DiskProtectStatusEnum.PROTECTED.getStatus().equals(status)) {
                this.translateDiskInfo(key, diskInfo, srcStorage);
                this.translateSubDiskInfo(key, tgtStorage, subDiskInfo);
            }
            if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(status)) {
                if (!srcDevSn.equals(poStorageInfo.getResourceProviderSN())) {
                    this.translateSubDiskInfo(key, tgtStorage, subDiskInfo);
                } else {
                    this.translateDiskInfo(key, diskInfo, srcStorage);
                }
            }
            diskInfos.add(diskInfo);
        }
    }

    protected StorageResource getSrcStorageResource(String srcDevSn, List<String> resourceNames) {
        StorageResource storageResource = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(srcDevSn, resourceNames, true).stream().findFirst().orElse(null);
        if (storageResource == null) {
            StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
            IStorageLunBaseManager manager = proxy.getStorageLunMgrByDevId(srcDevSn);
            storageResource = manager.queryLunsByNames(srcDevSn, resourceNames).stream().findFirst().orElse(null);
        }
        return storageResource;
    }

    protected void translateDiskInfo(String key, DiskInfo diskInfo, StorageResource srcStorage) {
        diskInfo.setDeviceName(key);
        if (srcStorage == null) {
            return;
        }
        diskInfo.setResourceId(srcStorage.getResourceId());
        if (srcStorage instanceof Lun) {
            Lun lun = (Lun)srcStorage;
            diskInfo.setResourceId(lun.getLunId());
            diskInfo.setPoolId(lun.getStoragePoolId());
            diskInfo.setCapacity(Long.valueOf(lun.getTotalCapacity().longValue()));
            diskInfo.setPoolName(lun.getStoragePoolName());
        }
    }

    protected void translateSubDiskInfo(String key, StorageResource tgtStorage, SubDiskInfo subDiskInfo) {
        subDiskInfo.setName(key);
        if (tgtStorage == null) {
            return;
        }
        subDiskInfo.setResourceId(tgtStorage.getResourceId());
        if (tgtStorage instanceof Lun) {
            Lun lun = (Lun)tgtStorage;
            subDiskInfo.setResourceId(lun.getLunId());
            subDiskInfo.setPoolId(lun.getStoragePoolId());
            subDiskInfo.setCapacity(Long.valueOf(lun.getTotalCapacity().longValue()));
            subDiskInfo.setPoolName(lun.getStoragePoolName());
        }
    }

    protected void getDiskFromRelicaStorage(ProtectObject po, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, RelicaStorageInfo> storageReplicaMap, List<DiskInfo> diskInfos, StoragePair storagePair) {
        String srcDevSn = storagePair.getSrcDevSN();
        String tgtDevSn = storagePair.getTgtDevSN();
        String currentPoSn = this.getCurrentPoSn(poStorageMap);
        for (Map.Entry<String, RelicaStorageInfo> entry : storageReplicaMap.entrySet()) {
            String key = entry.getKey();
            if (poStorageMap.containsKey(key)) continue;
            String status = DiskProtectStatusEnum.REMOVED.getStatus();
            DiskInfo diskInfo = new DiskInfo();
            diskInfo.setDevSn(srcDevSn);
            diskInfo.setStatus(status);
            diskInfo.setDeviceName(key);
            diskInfo.setName("--");
            ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
            poList.add(po);
            diskInfo.setProtectObjects(poList);
            SubDiskInfo subDiskInfo = new SubDiskInfo();
            subDiskInfo.setDevSn(tgtDevSn);
            diskInfo.getSubDiskInfo().add(subDiskInfo);
            ArrayList<String> resourceNames = new ArrayList<String>();
            resourceNames.add(key);
            if (currentPoSn.equals(srcDevSn)) {
                StorageResource srcStorage = this.getSrcStorageResource(srcDevSn, resourceNames);
                this.translateDiskInfo(key, diskInfo, srcStorage);
            } else {
                StorageResource tgtStorage = this.getSrcStorageResource(tgtDevSn, resourceNames);
                this.translateDiskInfo(key, diskInfo, tgtStorage);
            }
            diskInfos.add(diskInfo);
        }
    }

    protected String getCurrentPoSn(Map<String, ProtectObjectStorageInfo> poStorageMap) {
        return ((ProtectObjectStorageInfo)((Map.Entry)poStorageMap.entrySet().stream().findFirst().orElse(new Map.Entry<String, ProtectObjectStorageInfo>(){

            @Override
            public String getKey() {
                return null;
            }

            @Override
            public ProtectObjectStorageInfo getValue() {
                return new ProtectObjectStorageInfo();
            }

            @Override
            public ProtectObjectStorageInfo setValue(ProtectObjectStorageInfo value) {
                return new ProtectObjectStorageInfo();
            }
        })).getValue()).getResourceProviderSN();
    }

    protected void buildRecoveryPool(ProtectGroup protectGroup, List<DiskInfo> diskInfos, List<StoragePair> storagePairs, Map<String, String> poolIdAndNameInfoMap) {
        if (ProtectGroupExtendUtil.isHyperMetroOfSmallLun(protectGroup)) {
            this.buildHyperMetroRecoveryPool(diskInfos, storagePairs, poolIdAndNameInfoMap);
        } else {
            diskInfos.forEach(diskInfo -> {
                String poolId = diskInfo.getPoolId();
                if (StringUtils.isEmpty((CharSequence)poolId)) {
                    return;
                }
                String poolName = (String)poolIdAndNameInfoMap.get(CommUtil.combineString((String[])new String[]{diskInfo.getDevSn(), poolId}));
                if (StringUtils.isNotEmpty((CharSequence)poolName)) {
                    diskInfo.setPoolName(poolName);
                }
                this.setRecoveryPools(poolIdAndNameInfoMap, (DiskInfo)diskInfo, storagePairs, diskInfo.getDevSn(), diskInfo.getPoolId());
            });
        }
    }

    protected void buildHyperMetroRecoveryPool(List<DiskInfo> diskInfos, List<StoragePair> storagePairs, Map<String, String> poolIdAndNameInfoMap) {
        diskInfos.forEach(diskInfo -> {
            String tgtPoolId;
            String poolId = diskInfo.getPoolId();
            if (CollectionUtils.isEmpty((Collection)diskInfo.getSubDiskInfo())) {
                return;
            }
            List subDiskInfos = diskInfo.getSubDiskInfo();
            String string = tgtPoolId = CollectionUtils.isEmpty((Collection)subDiskInfos) ? null : ((SubDiskInfo)subDiskInfos.get(0)).getPoolId();
            if (poolId == null && tgtPoolId == null) {
                return;
            }
            if (poolId == null && !VerifyUtil.isEmpty((String)tgtPoolId) && DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskInfo.getStatus())) {
                this.setRecoveryPool((DiskInfo)diskInfo, tgtPoolId, poolIdAndNameInfoMap, storagePairs);
                return;
            }
            String poolName = (String)poolIdAndNameInfoMap.get(CommUtil.combineString((String[])new String[]{diskInfo.getDevSn(), poolId}));
            if (poolName != null) {
                diskInfo.setPoolName(poolName);
            }
            this.setRecoveryPools(poolIdAndNameInfoMap, (DiskInfo)diskInfo, storagePairs, diskInfo.getDevSn(), poolId);
        });
    }

    protected void setRecoveryPool(DiskInfo diskInfo, String recoveryPoolId, Map<String, String> poolIdAndNameMap, List<StoragePair> storagePairs) {
        StoragePair storagePair = storagePairs.get(0);
        DiskStoragePool diskStoragePool = new DiskStoragePool();
        diskStoragePool.setDevSn(storagePair.getTgtDevSN());
        diskStoragePool.setPoolId(recoveryPoolId);
        diskStoragePool.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{diskStoragePool.getDevSn(), diskStoragePool.getPoolId()})));
        if (diskInfo.getRecoveryPools() != null) {
            diskInfo.getRecoveryPools().add(diskStoragePool);
        } else {
            diskInfo.setRecoveryPools(Collections.singletonList(diskStoragePool));
        }
        String poolId = storagePair.getTgtStoragePool(storagePair.getTgtDevSN(), recoveryPoolId);
        diskInfo.setPoolId(poolId);
        diskInfo.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{storagePair.getSrcDevSN(), poolId})));
    }

    protected void setRecoveryPools(Map<String, String> poolIdAndNameMap, DiskInfo diskInfo, List<StoragePair> storagePairs, String devSn, String poolId) {
        if (VerifyUtil.isEmpty(storagePairs)) {
            return;
        }
        List recoveryStoragePairs = storagePairs.stream().filter(pair -> pair.getSrcDevSN().equals(devSn)).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(recoveryStoragePairs)) {
            return;
        }
        for (StoragePair pair2 : recoveryStoragePairs) {
            Map storagePools = pair2.getStoragePools();
            String recoveryPoolId = (String)storagePools.get(poolId);
            if (VerifyUtil.isEmpty((String)recoveryPoolId)) {
                logger.error((Object)"Can not find recoveryPoolId for: %s.", new Object[]{poolId});
                continue;
            }
            DiskStoragePool diskStoragePool = new DiskStoragePool();
            diskStoragePool.setDevSn(pair2.getTgtDevSN());
            diskStoragePool.setPoolId(recoveryPoolId);
            diskStoragePool.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{diskStoragePool.getDevSn(), diskStoragePool.getPoolId()})));
            if (diskInfo.getRecoveryPools() != null) {
                diskInfo.getRecoveryPools().add(diskStoragePool);
            } else {
                ArrayList<DiskStoragePool> poolList = new ArrayList<DiskStoragePool>();
                poolList.add(diskStoragePool);
                diskInfo.setRecoveryPools(poolList);
            }
            this.setRecoveryPools(poolIdAndNameMap, diskInfo, storagePairs, diskStoragePool.getDevSn(), diskStoragePool.getPoolId());
        }
    }
}

