/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class ProtectGroupExtendHelper {
    private static final Log logger = LogFactory.getInstance(ProtectGroupExtendHelper.class);
    private static ProtectGroupExtendHelper helperInstance = new ProtectGroupExtendHelper();

    public static ProtectGroupExtendHelper getInstance() {
        return helperInstance;
    }

    public Schedule getManualSchedule(ProtectGroup protectGroup, Map<String, String> params) {
        logger.debug((Object)"getManualSchedule");
        int location = this.getExcuteLocation(protectGroup, params);
        Schedule schedule = null;
        for (Schedule sc : protectGroup.getTemplate().getSchedules()) {
            if (sc.getScheduleMode() != 1) continue;
            if (-1 == location) {
                schedule = sc;
                break;
            }
            if (sc.getProtectLocation() != location) continue;
            schedule = sc;
            break;
        }
        return schedule;
    }

    private int getExcuteLocation(ProtectGroup protectGroup, Map<String, String> params) {
        List<Integer> doubleProtectLocation;
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) && VerifyUtil.isEmpty(params)) {
            params.put("executeProtectLocation_" + DrmEnumDefine.ProtectLocation.A_B.getValue(), "true");
        }
        if ((doubleProtectLocation = Arrays.asList(19, 17, 28, 31, 30, 32)).contains(protectGroup.getTemplate().getType())) {
            HashSet<String> executeProtectLocations = new HashSet<String>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (!param.getKey().startsWith("executeProtectLocation_") || !param.getValue().equals("true")) continue;
                executeProtectLocations.add(param.getKey().trim().substring("executeProtectLocation_".length()));
            }
            if (executeProtectLocations.size() != 1) {
                logger.error((Object)("the protect location to execute not 1" + executeProtectLocations.size()), 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            int location = -1;
            try {
                location = Integer.parseInt((String)executeProtectLocations.iterator().next());
            }
            catch (NumberFormatException e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"the protect location convert error", (long)1073947393L, (String[])new String[0], (Log)logger);
            }
            return location;
        }
        String drringUsedSrc = (String)protectGroup.getProps().get("hyper-dr-ring-used-resources");
        if (protectGroup.getTemplate().getType() == 3) {
            if (!VerifyUtil.isEmpty((String)drringUsedSrc)) {
                return DrmEnumDefine.ProtectLocation.C_C.getValue();
            }
            return DrmEnumDefine.ProtectLocation.B_C.getValue();
        }
        if (protectGroup.getTemplate().getType() == 5) {
            if (!VerifyUtil.isEmpty((String)drringUsedSrc)) {
                return DrmEnumDefine.ProtectLocation.C_C.getValue();
            }
            return DrmEnumDefine.ProtectLocation.A_C.getValue();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectObject> getProtectObjectListByRealMoUUID(List<String> moUuIds) {
        List listResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"moUuid", moUuIds));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            listResult = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"getProtectObjectListByMoUUID failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return listResult;
    }

    public void checkPolicyTemplate(ProtectGroup protectGroup, List<BatchOperation> resultList) {
        HashSet<ProtectObject> protectGroupSet = new HashSet<ProtectObject>();
        Iterator itr = protectGroup.getPolist().iterator();
        while (itr.hasNext()) {
            Long errorCode = 0L;
            ProtectObject po = (ProtectObject)itr.next();
            try {
                if (!ProtectGroupExtendHelper.getInstance().checkPolicyTemplate(protectGroup.getTemplate().getType(), po)) {
                    logger.error((Object)("ProtectObject(" + po.getMoUuid() + ") and PolicyTemplate does not match."));
                    errorCode = 1073948191L;
                }
            }
            catch (LegoCheckedException le) {
                logger.error((Object)"add po error1.", (Throwable)le, 90160758786989L);
                errorCode = 0L == le.getErrorCode() ? -1L : le.getErrorCode();
            }
            catch (Exception e) {
                logger.error((Object)("add po error2." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                errorCode = -1L;
            }
            if (0L == errorCode) continue;
            protectGroupSet.add(po);
            for (BatchOperation opt : resultList) {
                if (0L != opt.getErrorCode() || !po.getMoUuid().equals(opt.getTargetName())) continue;
                opt.setErrorCode(errorCode.longValue());
            }
        }
        protectGroup.getPolist().removeAll(protectGroupSet);
    }

    public boolean checkPolicyTemplate(int policyTemplateType, ProtectObject protectObject) {
        logger.debug((Object)"checkPoListIsEmpty");
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(policyTemplateType);
        if (null == filter) {
            logger.error((Object)("cannot get policyTemplateFilter, policyTemplateType =" + policyTemplateType), 90160758786897L);
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        protectObjects.add(protectObject);
        return filter.isMatch(protectObjects);
    }
}

