/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ProtectGroupExtendUtil {
    private static Log logger = LogFactory.getInstance(ProtectGroupExtendUtil.class);
    private static ProtectGroupExtendUtil instance = new ProtectGroupExtendUtil();
    private static List<Integer> asynReplicationRelatedTemplateTypeList = Arrays.asList(20, 4, 3, 6, 5, 18, 1, 30, 31, 32, 35, 36);
    private static final List<Integer> REPLICATION_TEMPLATE_LIST = Arrays.asList(0, 1, 18, 20, 23, 24, 26, 27);
    private static final List<Integer> HYPER_TEMPLATE_LIST = Arrays.asList(15, 18, 20, 23, 24, 26, 27);
    private static final Set<Integer> SMALL_LUN_REPLICA_TEMPLATES = ImmutableSet.of((Object)39, (Object)33, (Object)52, (Object)51);

    public static ProtectGroupExtendUtil getInstance() {
        return instance;
    }

    public static boolean isUltReplicationTemplate(int templateId) {
        return REPLICATION_TEMPLATE_LIST.contains(templateId);
    }

    public static boolean isUltHyperTemplate(int templateId) {
        return HYPER_TEMPLATE_LIST.contains(templateId);
    }

    public long invokeProductSiteMethod(String productSiteId, String url, String message, Map<String, String> uriVariables, HttpMethod method) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
            throw new LegoCheckedException(1073947440L);
        }
        String errorMsg = "To invoke product site method failed, name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
        String responseStr = ProtectGroupSynchronizer.getInstance().protectGroupInvokeMethod(site, url, message, uriVariables, method, errorMsg);
        return this.extractTaskId(responseStr);
    }

    private long extractTaskId(String responseStr) {
        if (responseStr == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"extract taskId failed!", (Throwable)err, 90160758787071L);
            throw err;
        }
        JSONObject object = JSONObject.fromObject((Object)responseStr);
        Object taskId = object.get("taskId");
        if (taskId == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"taskId is null!", (Throwable)err, 90160758787071L);
            throw err;
        }
        try {
            long backtaskId = Long.parseLong(taskId.toString());
            return backtaskId;
        }
        catch (NumberFormatException e) {
            logger.error((Object)"string type format to long type error!", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException("string type format to long type error!", (Throwable)e);
        }
    }

    public static boolean isReplicationTemplate(int type) {
        return asynReplicationRelatedTemplateTypeList.contains(type);
    }

    public static void logDiskInfo(String pgName, List<DiskInfo> diskInfos) {
        if (diskInfos == null) {
            return;
        }
        JSONArray diskJSONArray = new JSONArray();
        diskInfos.stream().map(diskInfo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"devSn", (Object)diskInfo.getDevSn());
            jsonObject.put((Object)"resourceId", (Object)diskInfo.getResourceId());
            jsonObject.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            jsonObject.put((Object)"poolId", (Object)diskInfo.getPoolId());
            jsonObject.put((Object)"poolName", (Object)diskInfo.getPoolName());
            jsonObject.put((Object)"status", (Object)diskInfo.getStatus());
            JSONArray poArray = new JSONArray();
            diskInfo.getProtectObjects().stream().map(po -> {
                JSONObject poJsonObj = new JSONObject();
                poJsonObj.put((Object)"moUuid", (Object)po.getMoUuid());
                poJsonObj.put((Object)"name", (Object)po.getName());
                return poJsonObj;
            }).forEach(protectPo -> poArray.add(protectPo));
            jsonObject.put((Object)"protectObjects", (Object)poArray);
            jsonObject.put((Object)"recoveryPools", (Object)JSONArray.fromObject((Object)diskInfo.getRecoveryPools()));
            return jsonObject;
        }).forEach(protectPo -> diskJSONArray.add(protectPo));
        String str = diskJSONArray.toString();
        logger.info((Object)"protectGroup:%s,diskInfos:%s", new Object[]{pgName, str});
    }

    public static boolean isHyperMetroOfSmallLun(ProtectGroup pg) {
        int templateType = ProtectGroupExtendUtil.getTemplateTypeFromPg(pg);
        return templateType == 38 || templateType == 53;
    }

    public static boolean isReplicaOfSmallLun(ProtectGroup pg) {
        return SMALL_LUN_REPLICA_TEMPLATES.contains(ProtectGroupExtendUtil.getTemplateTypeFromPg(pg));
    }

    public static boolean isSyncReplicaOfSmallLun(ProtectGroup pg) {
        int templateType = ProtectGroupExtendUtil.getTemplateTypeFromPg(pg);
        return templateType == 39 || templateType == 52;
    }

    public static int getTemplateTypeFromPg(ProtectGroup pg) {
        return Optional.ofNullable(pg).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElseThrow(() -> {
            logger.error((Object)"Fail to get template type from protect group, cause protect group or template type is empty.");
            return new LegoCheckedException(1073947393L);
        });
    }
}

