/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.mo.StorageObjectBo;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupBaseServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupQueryServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineExtendService;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.DiskStoragePool;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;

public abstract class ProtectGroupQueryExtendServiceImpl
extends ProtectGroupBaseServiceImpl
implements IProtectGroupService {
    private static final Log LOGGER = LogFactory.getInstance(ProtectGroupQueryServiceImpl.class);

    protected Map<String, String> getProtectGroupProps(String pgId, Session session) {
        return QueryProtectGroupRefineExtendService.getInstance().getProtectGroupProps(pgId, session);
    }

    public boolean isHostGroupUsedByProtectGroup(String hostGroupId) {
        List result;
        String hql = "from ProtectGroup as pg where pg.poProviderSN = ? order by pg.pgId";
        try {
            result = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{hostGroupId});
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Failed to query potectgroup, error : %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return !VerifyUtil.isEmpty((Collection)result);
    }

    @Override
    protected void checkLunToBeExpand(List<DiskInfo> diskInfos) {
        HashMap lunInfo = new HashMap();
        diskInfos.forEach(diskInfo -> diskInfo.getSubDiskInfo().forEach(diskInfo1 -> {
            if (lunInfo.containsKey(diskInfo1.getDevSn())) {
                ((List)lunInfo.get(diskInfo1.getDevSn())).add(diskInfo1.getResourceId());
            } else {
                ArrayList<String> lunId = new ArrayList<String>();
                lunId.add(diskInfo1.getResourceId());
                lunInfo.put(diskInfo1.getDevSn(), lunId);
            }
        }));
        ArrayList lunList = new ArrayList();
        for (Map.Entry entry : lunInfo.entrySet()) {
            String devSn = (String)entry.getKey();
            List targetLuns = (List)entry.getValue();
            LOGGER.info((Object)String.format(Locale.ROOT, "Query lun info, targetLuns : %s.", targetLuns.toString()));
            List lunLists = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSn, targetLuns, Lun.class);
            if (lunLists.isEmpty()) continue;
            lunList.addAll(lunLists);
        }
        diskInfos.stream().filter(diskInfo -> DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskInfo.getStatus())).forEach(diskInfo -> this.checkLunToBeExpandForDiskInfo(lunList, (DiskInfo)diskInfo));
    }

    @Override
    protected void setRecoveryPool(DiskInfo diskInfo, String recoveryPoolId, Map<String, String> poolIdAndNameMap, List<StoragePair> storagePairs) {
        StoragePair storagePair = storagePairs.get(0);
        DiskStoragePool diskStoragePool = new DiskStoragePool();
        diskStoragePool.setDevSn(storagePair.getTgtDevSN());
        diskStoragePool.setPoolId(recoveryPoolId);
        diskStoragePool.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{diskStoragePool.getDevSn(), diskStoragePool.getPoolId()})));
        if (diskInfo.getRecoveryPools() != null) {
            diskInfo.getRecoveryPools().add(diskStoragePool);
        } else {
            diskInfo.setRecoveryPools(Collections.singletonList(diskStoragePool));
        }
        String poolId = storagePair.getTgtStoragePool(storagePair.getTgtDevSN(), recoveryPoolId);
        diskInfo.setPoolId(poolId);
        diskInfo.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{storagePair.getSrcDevSN(), poolId})));
    }

    @Override
    protected StorageResource getSrcStorageResource(String srcDevSn, List<String> resourceNames) {
        StorageResource storageResource = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(srcDevSn, resourceNames, true).stream().findFirst().orElse(null);
        if (storageResource == null) {
            StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
            IStorageLunBaseManager manager = proxy.getStorageLunMgrByDevId(srcDevSn);
            storageResource = manager.queryLunsByNames(srcDevSn, resourceNames).stream().findFirst().orElse(null);
        }
        return storageResource;
    }

    public List<Lun> getUsedStorageLunsByProtectObject(List<ProtectObject> protectObjects, int poType, int templateType) {
        LOGGER.debug((Object)"Method getUsedStorageLunsByProtectObject start.");
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class);
        IProtectObjectBaseProvider provider = poProvider.getProviderByAppType(poType);
        provider.loadProtectObjectStorageInfo(protectObjects);
        String deviceSn = null;
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (ProtectObject protectObject : protectObjects) {
            Set storageInfos = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfos) {
                deviceSn = storageInfo.getResourceProviderSN();
                resourceIds.add(storageInfo.getResourceId());
            }
        }
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List storageResources = storageResourceService.getStorageResources(deviceSn, resourceIds, Lun.class);
        Map<String, String> poolIdAndNameMap = this.getPoolIdAndNameMap();
        Map<String, String> controllerLocations = this.getControllerLocations();
        for (Lun lun : storageResources) {
            this.fillControllerNameOfLun((StorageResource)lun, controllerLocations);
            if (!(lun instanceof XveLun)) continue;
            XveLun xveLun = (XveLun)lun;
            xveLun.setStoragePoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{xveLun.getDevSn(), xveLun.getStoragePoolId()})));
        }
        LOGGER.debug((Object)"Method getUsedStorageLunsByProtectObject end.");
        return storageResources;
    }

    private Map<String, String> getPoolIdAndNameMap() {
        HashMap<String, String> poolIdAndNameMap = new HashMap<String, String>();
        List storagePools = this.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePools)) {
            for (Object object : storagePools) {
                StoragePool pool = (StoragePool)object;
                poolIdAndNameMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        return poolIdAndNameMap;
    }

    private Map<String, String> getControllerLocations() {
        HashMap<String, String> controllerLocations = new HashMap<String, String>();
        List controllers = this.getMoDao().find("from Controller", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)controllers)) {
            for (Object object : controllers) {
                Controller controller = (Controller)object;
                String location = controller.getLocation();
                if (VerifyUtil.isEmpty((String)location) && !VerifyUtil.isEmpty((String)controller.getControllerType())) {
                    location = controller.getControllerType();
                }
                controllerLocations.put(controller.getUuid(), location);
                LOGGER.info((Object)"Controller uuid:%s, location:%s.", new Object[]{controller.getUuid(), location});
            }
        }
        return controllerLocations;
    }

    private void fillControllerNameOfLun(StorageResource storageResource, Map<String, String> controllerLocations) {
        if (!(storageResource instanceof Lun) || VerifyUtil.isEmpty(controllerLocations)) {
            return;
        }
        Lun lun = (Lun)storageResource;
        String controllerUuid = lun.getDevSn() + "14:0:" + lun.getControllerId();
        if (lun instanceof XveLun) {
            controllerUuid = new XveUUID(lun.getDevSn(), XveMOType.CONTROLLER, lun.getControllerId()).toString();
        }
        if (VerifyUtil.isEmpty((String)controllerLocations.get(controllerUuid))) {
            LOGGER.error((Object)"Controller name is empty! lun id : %s, lun name:%s, devSn : %s, controllerId : %s, controllerUUID : %s, Lun is XveLun? %s.", new Object[]{lun.getLunId(), lun.getName(), SecurityUtil.desensitizeId((String)lun.getDevSn()), lun.getControllerId(), controllerUuid, lun instanceof XveLun});
        }
        lun.setControllerName(controllerLocations.get(controllerUuid));
    }

    public List<ProtectGroup> getTopoAllProtectGroupBasicInfo(Long userId) {
        return QueryProtectGroupRefineExtendService.getInstance().getTopoAllProtectGroupBasicInfo(userId);
    }

    @Override
    public List<ProtectObject> getProtectObjectListByRealMoUUID(List<String> moUuIds) {
        if (VerifyUtil.isEmpty(moUuIds)) {
            LOGGER.error((Object)"Failed to getProtectObjectListByMoUUID because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupExtendHelper.getInstance().getProtectObjectListByRealMoUUID(moUuIds);
    }

    public List<StorageObjectBo> getUseHypermetroStorage(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            LOGGER.error((Object)"Method getUseHyperMetroStorage failed, protectGroupId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.error((Object)"ProtectGroup(%s) not exist.", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073947394L);
        }
        List protectObjectStorageInfoList = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)protectObjectStorageInfoList)) {
            LOGGER.error((Object)"Protect object storage is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)protectObjectStorageInfoList.stream().findAny().get();
        if (VerifyUtil.isEmpty((Object)posi.getResourceType())) {
            LOGGER.error((Object)"The posi.getResourceType() is empty! DeviceName : %s.", new Object[]{posi.getDeviceName()});
            throw new LegoCheckedException(1073947393L);
        }
        if (posi.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.LUN.getValue()) {
            return this.queryLunHyperMetroStorageInfo(posi);
        }
        if (posi.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            String deviceSn = posi.getResourceProviderSN();
            String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            return this.queryNasHyperMetroStorageInfo(deviceSn, vStorePairId);
        }
        LOGGER.error((Object)"Pg use storage resource type illegal, type is: %s.", new Object[]{String.valueOf(posi.getResourceType())});
        throw new LegoCheckedException(1073947393L);
    }

    private List<StorageObjectBo> queryNasHyperMetroStorageInfo(String deviceSn, String vStorePairId) {
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty((String)vStorePairId)) {
            LOGGER.error((Object)"The deviceSn or vStoreId is empty, vStorePairId: %s.", new Object[]{vStorePairId});
            throw new LegoCheckedException(1073947393L);
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(deviceSn, vStorePairId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            LOGGER.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(deviceSn);
        List vstoreHyperMetroPairs = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(site.getServerUuid(), vstoreHyperMetroPair);
        HashSet<String> devSnSet = new HashSet<String>();
        devSnSet.add(deviceSn);
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit)) continue;
            devSnSet.add(((HvsUnit)managedObject).getDevSn());
        }
        if (devSnSet.size() != 2) {
            LOGGER.error((Object)"Method[queryNasHyperMetroStorageInfo()]. DevSNSet is empty or the size is not two! devSNSet size: %s.", new Object[]{String.valueOf(devSnSet.size())});
            throw new LegoCheckedException(1073947393L);
        }
        return this.constructNasStorageObjectBo(deviceSn, vstoreHyperMetroPair.getActiveOrPassive(), devSnSet);
    }

    private List<StorageObjectBo> constructNasStorageObjectBo(String deviceSn, String activeOrPassive, Set<String> devSnSet) {
        HashSet<String> types = new HashSet<String>();
        types.add(String.valueOf(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue()));
        types.add(String.valueOf(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue()));
        if (!types.contains(activeOrPassive)) {
            LOGGER.error((Object)"ActiveOrPassive is error, activeOrPassive: %s.", new Object[]{activeOrPassive});
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<StorageObjectBo> list = new ArrayList<StorageObjectBo>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        for (String devSn : devSnSet) {
            StorageNE storageArray = storageService.getStorageBySn(devSn, null);
            if (VerifyUtil.isEmpty((Object)storageArray)) {
                LOGGER.error((Object)"StorageNE is empty, devSn is: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                throw new LegoCheckedException(1073947393L);
            }
            StorageObjectBo bo = new StorageObjectBo();
            bo.setDevSn(devSn);
            bo.setName(storageArray.getName());
            int srcVstorePairStatus = Integer.parseInt(activeOrPassive);
            if (deviceSn.equals(devSn)) {
                bo.setPriorityStationType(srcVstorePairStatus);
            } else if (XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue() == srcVstorePairStatus) {
                bo.setPriorityStationType(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue());
            } else {
                bo.setPriorityStationType(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue());
            }
            list.add(bo);
        }
        return list;
    }

    private List<StorageObjectBo> queryLunHyperMetroStorageInfo(ProtectObjectStorageInfo posi) {
        String lunWwn = posi.getLunWWN();
        if (VerifyUtil.isEmpty((String)lunWwn)) {
            LOGGER.error((Object)"Param lunWWN is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            LOGGER.error((Object)"Method[getSrcDeviceSN()]. Resources is empty or the size is not two! resources :%s.", new Object[]{resources, 90160758786897L});
            throw new LegoCheckedException(1073947393L);
        }
        StorageObjectBo srcBo = this.constructStorageObjectBo(lunWwn, ((StorageResource)resources.get(0)).getDevSn());
        StorageObjectBo remoteBo = this.constructStorageObjectBo(lunWwn, ((StorageResource)resources.get(1)).getDevSn());
        ArrayList<StorageObjectBo> storage = new ArrayList<StorageObjectBo>();
        storage.add(srcBo);
        storage.add(remoteBo);
        return storage;
    }

    private StorageObjectBo constructStorageObjectBo(String lunWwn, String devSn) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        StorageNE storageArray = storageService.getStorageBySn(devSn, null);
        if (VerifyUtil.isEmpty((Object)storageArray)) {
            LOGGER.error((Object)"StorageNE is empty, devSn is:%s. ", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> wwns = new ArrayList<String>();
        wwns.add(lunWwn);
        List pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(null, wwns, null, devSn, true);
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            LOGGER.error((Object)"HyperMetroPair List is emtpty,wwn= %s.", new Object[]{String.join((CharSequence)";", wwns)});
            throw new LegoCheckedException(1073947393L);
        }
        HyperMetroPair pair = (HyperMetroPair)CommonUtil.getFirstElement((Collection)pairList);
        int priorityStationType = 0;
        if (!pair.getIsPrimary().booleanValue()) {
            priorityStationType = 1;
        }
        StorageObjectBo bo = new StorageObjectBo();
        bo.setDevSn(devSn);
        bo.setName(storageArray.getName());
        bo.setPriorityStationType(priorityStationType);
        return bo;
    }

    @Override
    public List<DiskInfo> queryDiskInfo(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            LOGGER.error((Object)"Method getUseHyperMetroStorage failed, protectGroupId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.error((Object)"ProtectGroup(%s) not exist.", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073947394L);
        }
        return this.queryDiskInfo(protectGroup);
    }

    @Override
    public synchronized List<DiskInfo> queryDiskInfo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.error((Object)"GetUseHyperMetroStorage failed, protectGroupId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<StoragePair> storagePairs = new ArrayList<StoragePair>();
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        if (!VerifyUtil.isEmpty((String)replicationCfg)) {
            List pairs = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)replicationCfg), StoragePair.class);
            storagePairs.addAll(pairs);
        }
        HashMap<String, String> poolIdAndNameInfoMap = new HashMap<String, String>();
        List storagePoolInfos = CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePoolInfos)) {
            for (StoragePool pool : storagePoolInfos) {
                poolIdAndNameInfoMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameInfoMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        List<DiskInfo> diskInfos = this.getDiskInfos(protectGroup);
        this.buildRecoveryPool(protectGroup, diskInfos, storagePairs, poolIdAndNameInfoMap);
        if (LOGGER.isDebugEnabled()) {
            ProtectGroupExtendUtil.logDiskInfo(protectGroup.getName(), diskInfos);
        }
        return diskInfos;
    }
}

