/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.AddScheduleTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupQueryExtendServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.framework.service.group.UpdateDiskProtectedBackTask;
import com.huawei.ism.drm.protection.framework.service.group.UpdateScheduleTask;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.SynProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.util.ProtectGroupBlockingQueue;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.UpdateDiskRequest;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService", desc="", interfaceClass=IProtectGroupService.class)
public class ProtectGroupServiceImpl
extends ProtectGroupQueryExtendServiceImpl
implements IProtectGroupService {
    private static final Log logger = LogFactory.getInstance(ProtectGroupServiceImpl.class);
    private BaseProtectGroupRefineService baseProtectGroupRefineService = new BaseProtectGroupRefineService();

    public void notifyObserverList(MessageEvent event, String notifyType) {
        this.baseProtectGroupRefineService.notifyObserverList(event, notifyType);
    }

    public void createProtectionTask(ProtectGroup protectGroup) {
        logger.debug((Object)"createProtectionTask");
        this.protectionTaskService.createTask(protectGroup);
    }

    public BatchOperationResult batchCreateProtectGroup(List<BatchOperation<ProtectGroup>> bathOprLst) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation<ProtectGroup>> resultList = new ArrayList<BatchOperation<ProtectGroup>>();
        int failCount = 0;
        for (BatchOperation<ProtectGroup> batchOperation : bathOprLst) {
            try {
                ProtectGroup targetObject = (ProtectGroup)batchOperation.getTargetObject();
                Boolean isSuccess = ProtectGroupBlockingQueue.offer((ProtectGroup)targetObject);
                if (!isSuccess.booleanValue()) {
                    logger.error((Object)"Add protectgroup to protectGroupBlockingQueue error.");
                    throw new LegoCheckedException(-1L);
                }
            }
            catch (LegoCheckedException e) {
                ++failCount;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++failCount;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            resultList.add(batchOperation);
        }
        result.setResult(resultList);
        result.setFailCount(failCount);
        result.setTotalCount(bathOprLst.size());
        result.setSucceedCount(bathOprLst.size() - failCount);
        return result;
    }

    public void syncProtectGroup(ProtectGroup protectGroup) {
        logger.debug((Object)"syncProtectGroup");
        SynProtectGroupRefineService.getInstance().syncProtectGroupToLocal(protectGroup);
    }

    public void syncProtectGroupToRemoteSite(ProtectGroup protectGroup, String url) {
        logger.debug((Object)"url:%s", new Object[]{url});
        SynProtectGroupRefineService.getInstance().syncProtectGroupToRemoteSite(protectGroup, url);
    }

    public void createSyncProtectGroup(ProtectGroup protectGroup) {
        logger.debug((Object)"enter createSyncProtectGroup");
        try {
            this.syncProtectGroup(protectGroup);
            ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(protectGroup.getOwnerId(), new String[]{protectGroup.getUuid()});
        }
        catch (Exception e) {
            logger.error((Object)"createSyncProtectGroup error");
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to sync protectGroup:" + protectGroup.getName()), (long)1073947440L, (String[])new String[0], (Log)logger);
        }
    }

    public void enableSchedule(String protectGroupId, String scheduleId) {
        Schedule schedule = this.getSchedule(protectGroupId, scheduleId);
        if (schedule.getScheduleMode() == 0 && schedule.getPeriodType() == 5) {
            logger.info((Object)"schedule is seconds. disable snapshotSchedule.");
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            SnapshotScheduleUtil.enable(protectGroup, schedule, true);
            schedule.setEnable(Boolean.valueOf(true));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)schedule);
            return;
        }
        this.protectionTaskService.enableTask(protectGroupId, scheduleId);
    }

    public void disableSchedule(String protectGroupId, String scheduleId) {
        Schedule schedule = this.getSchedule(protectGroupId, scheduleId);
        if (schedule.getScheduleMode() == 0 && schedule.getPeriodType() == 5) {
            logger.info((Object)"schedule is seconds. disable snapshotSchedule.");
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            SnapshotScheduleUtil.enable(protectGroup, schedule, false);
            schedule.setEnable(Boolean.valueOf(false));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)schedule);
            return;
        }
        this.protectionTaskService.disableTask(protectGroupId, scheduleId);
    }

    private Schedule getSchedule(String protectGroupId, String scheduleId) {
        List scheduleList = this.getAllSchedule(protectGroupId);
        Schedule schedule = scheduleList.stream().filter(schedule1 -> schedule1.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
        if (null == schedule) {
            String errorMsg = String.format(Locale.ROOT, "Schedule[%s] does not exists", scheduleId);
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return schedule;
    }

    public void addSchedule(String protectGroupId, Schedule schedule) {
        ProtectGroup protectGroup = this.checkAndGetProtectGroup(protectGroupId, schedule);
        Set scheduleSet = protectGroup.getTemplate().getSchedules();
        for (Schedule schedule1 : scheduleSet) {
            ScriptParamsUtils.convertUserDefinedParams((Schedule)schedule1);
            if (schedule1.getProtectLocation() != schedule.getProtectLocation() || schedule1.getProtectedType() != schedule.getProtectedType()) continue;
            String errMsg = "The schedule exists in the protection group[{0}] for the protect location[{1}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{protectGroupId, schedule.getProtectLocation()}));
            throw new LegoCheckedException(1073947393L);
        }
        AddScheduleTask task = new AddScheduleTask(this, protectGroup, schedule);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private ProtectGroup checkAndGetProtectGroup(String protectGroupId, Schedule schedule) {
        if (null == schedule) {
            logger.error((Object)"Schedule is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_TEMPLATE, protectGroup);
        return protectGroup;
    }

    public long updateDiskProtect(String protectGroupId, UpdateDiskRequest updateDiskRequest) {
        if (ProtectionJobUtil.getInstance().isPgLocked(protectGroupId)) {
            logger.error((Object)"Protect group(%s) is locked.", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073948196L);
        }
        logger.debug((Object)"enter begin update disk to protect");
        String storagePoolMapping = updateDiskRequest.getStoragePoolMapping();
        JSONArray storagePoolMappingArray = JSONArray.fromObject((Object)storagePoolMapping);
        List storagePairs = JSONArray.toCollection((JSONArray)storagePoolMappingArray, StoragePair.class);
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)((Object)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class));
        HashSet<String> volumeIdSet = new HashSet<String>();
        try {
            for (StoragePair storagePair : storagePairs) {
                List<StoragePool> srcPools = drmStorageService.queryStoragePoolsBySn(storagePair.getSrcDevSN());
                List<StoragePool> tgtPools = drmStorageService.queryStoragePoolsBySn(storagePair.getTgtDevSN());
                logger.debug((Object)"storage pools :%s is secDev :%s", new Object[]{srcPools, true});
                StoragePair.checkStoragePool(srcPools, (StoragePair)storagePair, (boolean)true);
                logger.debug((Object)"storage pools :%s  is secDev :%s", new Object[]{tgtPools, false});
                StoragePair.checkStoragePool(tgtPools, (StoragePair)storagePair, (boolean)false);
                storagePair.checkPair();
            }
            if (!VerifyUtil.isEmpty((String)updateDiskRequest.getVolumeId())) {
                volumeIdSet.add(updateDiskRequest.getVolumeId());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"have poolid invailde..", e.getErrorCode());
            throw e;
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        ProtectGroupServiceImpl.setSrcHyperMetroDomainId(storagePairs, protectGroup);
        UpdateDiskProtectedBackTask task = new UpdateDiskProtectedBackTask(storagePairs, protectGroup, volumeIdSet);
        if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
            task.setTimeout(2147483);
        }
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return task.getBackTask().getTaskId();
    }

    private static void setSrcHyperMetroDomainId(List<StoragePair> storagePairs, ProtectGroup protectGroup) {
        String storagePoolMappingInDb = (String)protectGroup.getProps().get("storagePoolMapping");
        if (VerifyUtil.isEmpty((String)storagePoolMappingInDb)) {
            return;
        }
        JSONArray storagePoolMappingArrayInDb = JSONArray.fromObject((Object)storagePoolMappingInDb);
        List storagePairsInDb = JSONArray.toCollection((JSONArray)storagePoolMappingArrayInDb, StoragePair.class);
        String srcHyperMetroDomainId = storagePairsInDb.stream().filter(pairInDb -> !VerifyUtil.isEmpty((String)pairInDb.getSrcHyperMetroDomainId())).findFirst().map(StoragePair::getSrcHyperMetroDomainId).orElse(null);
        if (!VerifyUtil.isEmpty((String)srcHyperMetroDomainId)) {
            storagePairs.forEach(pair -> pair.setSrcHyperMetroDomainId(srcHyperMetroDomainId));
        }
    }

    public void syncUpdateProtectGroupInfoToRemoteSite(List<String> recoverySiteIds, ProtectGroup pg) {
        logger.debug((Object)"enter syncUpdateProtectGroupInfoToRemoteSite");
        for (String recoverySiteId : recoverySiteIds) {
            Site site = this.getSiteService().getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
                throw new LegoCheckedException(1073947440L);
            }
            if (1 != site.getSiteType()) continue;
            String errorMsg = "sync Protect Group  to remote site,name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", pg.getUuid());
            HashMap<String, String> message = new HashMap<String, String>();
            message.put("pgId", pg.getUuid());
            message.put("uuid", pg.getUuid());
            message.put("name", pg.getName());
            message.put("description", pg.getDescription());
            JSONObject jsonMessage = null;
            try {
                jsonMessage = JSONObject.fromObject(message);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073947440L, (String[])new String[0], (Log)logger);
                return;
            }
            ProtectGroupSynchronizer.getInstance().protectGroupInvokeMethod(site, "/ws/protectgroups/{protectGroupId}", jsonMessage.toString(), uriVariables, HttpMethod.PUT, errorMsg);
        }
    }

    public void updateSchedule(String protectGroupId, Schedule schedule) {
        ProtectGroup protectGroup = this.checkAndGetProtectGroup(protectGroupId, schedule);
        List scheduleList = this.getAllSchedule(protectGroupId);
        List filterList = scheduleList.stream().filter(schedule1 -> schedule1.getScheduleId().equals(schedule.getScheduleId())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(filterList)) {
            String errorMsg = String.format(Locale.ROOT, "Schedule[%s] does not exists", schedule.getScheduleId());
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        Schedule oldSchedule = (Schedule)filterList.stream().findFirst().get();
        if (oldSchedule.getProtectedType() != schedule.getProtectedType()) {
            String errorMsg = "Cannot modify protect type, old protect type is %s and new protect type is %s.";
            errorMsg = String.format(errorMsg, oldSchedule.getPeriodType(), schedule.getProtectedType());
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        ScriptParamsUtils.convertUserDefinedParams((Schedule)schedule);
        UpdateScheduleTask task = new UpdateScheduleTask(this, protectGroup, schedule, oldSchedule);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }
}

