/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProtectGroupSynchronizer {
    private static final Log logger = LogFactory.getInstance(ProtectGroupSynchronizer.class);
    private static final ProtectGroupSynchronizer INSTANCE = new ProtectGroupSynchronizer();

    private ProtectGroupSynchronizer() {
    }

    public static ProtectGroupSynchronizer getInstance() {
        return INSTANCE;
    }

    public void syncProtectGroupStatus(int status, ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"protectGroup is empty", 90160758786989L);
            return;
        }
        if (protectGroup.isPrimary()) {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            uriVariables.put("protectGroupId", protectGroup.getUuid());
            uriVariables.put("status", status);
            this.syncUpdateProtectGroupToRemoteSite(protectGroup, "/ws/protectgroups/{protectGroupId}/action/updateProtectGroupStatus?status={status}", uriVariables, HttpMethod.PUT);
        }
    }

    public void syncProtectGroupStatus(ProtectGroup protectGroup) {
        this.syncProtectGroupStatus(protectGroup.getStatus(), protectGroup);
    }

    public void syncUpdateProtectGroupToRemoteSite(ProtectGroup protectGroup, String url, Map<String, ?> uriVariables, HttpMethod method) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"protectGroup is empty", 90160758786989L);
            return;
        }
        Set<ProtectGroupReplica> replicas = this.filterReplicaByRecoverySite(protectGroup.getReplicaList());
        for (ProtectGroupReplica replica : replicas) {
            String recoverySiteId = replica.getRecoverySite();
            if (VerifyUtil.isEmpty((String)recoverySiteId)) continue;
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
                throw new LegoCheckedException(1073947440L);
            }
            if (1 != site.getSiteType()) continue;
            String errorMsg = "sync Protect Group,name: " + protectGroup.getName() + " to remote site,name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
            this.protectGroupInvokeMethod(site, url, null, uriVariables, method, errorMsg);
        }
    }

    public String protectGroupInvokeMethod(Site site, String url, String message, Map<String, ?> uriVariables, HttpMethod method, String errorInfo) {
        RestClient client = SiteUtil.initClient((Site)site);
        try {
            String response = client.invoke(url, message, uriVariables, method);
            return response;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)this.getErrorMsg(site, errorInfo), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)this.getErrorMsg(site, errorInfo), (long)1073947440L, (String[])new String[0], (Log)logger);
            return null;
        }
    }

    private String getErrorMsg(Site site, String errorInfo) {
        String errorMsg = VerifyUtil.isEmpty((String)errorInfo) ? "sync to remote site,name: " + site.getName() + " ,id: " + site.getSiteId() + " error" : errorInfo;
        return errorMsg;
    }

    private Set<ProtectGroupReplica> filterReplicaByRecoverySite(Set<ProtectGroupReplica> pgReplicas) {
        HashSet<ProtectGroupReplica> result = new HashSet<ProtectGroupReplica>();
        HashSet<String> existSiteId = new HashSet<String>();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (existSiteId.contains(replica.getRecoverySite())) continue;
            result.add(replica);
            existSiteId.add(replica.getRecoverySite());
        }
        return result;
    }
}

