/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.util.RecoveryServiceExtendUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.SynProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

@Service(name="IProtectionRemoteService", desc="", interfaceClass=IProtectionRemoteService.class)
public class ProtectionRemoteServiceImpl
implements IProtectionRemoteService {
    private static final Log logger = LogFactory.getInstance(ProtectionRemoteServiceImpl.class);
    private static final List<Integer> CHECK_HYPERMETRO_MASTER_LUN = Arrays.asList(19, 18, 28, 31, 26);
    private static List<Integer> localPgType = Arrays.asList(15, 2, 14, 17, 28, 19, 25, 29, 30, 31, 32);
    private IBaseDao<?, ?> baseDao;

    public IBaseDao<?, ?> getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(IBaseDao<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void syncProtectGroup(ProtectGroup protectGroup) {
        try {
            logger.info((Object)("job start and begin to sync protectGroup to remote,pgId:" + protectGroup.getUuid() + " name:" + protectGroup.getName()), 90160758786988L);
            SynProtectGroupRefineService.getInstance().syncProtectGroupToRemoteSite(protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
            logger.info((Object)("job start and end to sync protectGroup to remote,pgId:" + protectGroup.getUuid() + " name:" + protectGroup.getName()), 90160758786988L);
        }
        catch (Exception e) {
            logger.error((Object)("Before execute sync protectGroup failed,pgId:" + protectGroup.getUuid() + " name:" + protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 1073947440L);
        }
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context, ProtectGroupReplica pgReplica) {
        int templateType = protectGroup.getTemplate().getType();
        if (templateType == 35 || templateType == 36 ? !ProtectionJobExtendUtil.isHyperMetroInFirstSite(protectGroup) : !CHECK_HYPERMETRO_MASTER_LUN.contains(templateType)) {
            return;
        }
        int resourcetype = this.getResourcetype(protectGroup);
        if (resourcetype == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            if (templateType == 28) {
                List relationList = (List)context.getObject("VAULT_PATH");
                this.checkNasHyperMetro(relationList);
            } else {
                this.checkNasHyperMetro(pgReplica);
            }
            return;
        }
        pgReplica = this.getProtectGroupReplica(protectGroup, templateType, pgReplica);
        ArrayList<String> allWWN = new ArrayList<String>();
        allWWN.addAll(this.getAllStorageWWN(pgReplica));
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List pairList = null;
        try {
            pairList = storageResourceService.getHyperMetroPairByWwn(allWWN, null, true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + allWWN + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RealTime to query hyperMetro pair error! , all wwns:" + allWWN), (long)-1L, null, (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("pairList is empty! pgName:" + protectGroup.getName() + ", allWWN:" + allWWN));
            throw new LegoCheckedException(-1L);
        }
        this.checkSyncDirection(pgReplica, pairList);
    }

    private void checkSyncDirection(ProtectGroupReplica pgReplica, List<HyperMetroPair> pairList) {
        for (HyperMetroPair pair : pairList) {
            if (!pair.getDevSn().equals(pgReplica.getProductArray())) continue;
            Integer syncDirection = pair.getSyncDirection();
            if (VerifyUtil.isEmpty((Object)syncDirection)) {
                logger.error((Object)("The syncDirection is null! pairId:" + pair.getId()));
                throw new LegoCheckedException(-1L);
            }
            if (!String.valueOf(XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()).equals(String.valueOf(syncDirection)) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) continue;
            logger.warn((Object)("hyper metro pair :" + pair.getId() + " pair devsn :" + pair.getDevSn() + " ,execute pg array :" + pgReplica.getProductArray() + ", syncDirection:" + syncDirection));
            throw new LegoCheckedException(1073948228L);
        }
    }

    private Set<String> getAllStorageWWN(ProtectGroupReplica pgReplica) {
        logger.debug((Object)"getAllStorageWWN");
        HashSet<String> result = new HashSet<String>();
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getProtectObjectStorageWwn());
            }
        }
        return result;
    }

    private ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup, int templateType, ProtectGroupReplica pgReplica) {
        ProtectGroupReplica replica;
        if (templateType == 31 && null != (replica = protectGroup.getAnyoneReplicationReplica())) {
            return replica;
        }
        return pgReplica;
    }

    private void checkNasHyperMetro(ProtectGroupReplica pgReplica) {
        ArrayList<String> fileSystemIds = new ArrayList<String>();
        HashSet<String> result = new HashSet<String>();
        String srcDevsn = this.getSrcDevSN(pgReplica, result);
        fileSystemIds.addAll(result);
        this.checkNasHyperMetro(srcDevsn, pgReplica.getProductArray(), fileSystemIds);
    }

    private String getSrcDevSN(ProtectGroupReplica pgReplica, Set<String> result) {
        logger.debug((Object)"getAllFileSystemIds");
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getSrcStorageId());
                srcDevSn = storage.getSrcStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    private void checkNasHyperMetro(List<ProtectionRelation> relationList) {
        HashSet<String> result = new HashSet<String>();
        String devSn = ((ProtectionRelation)CommonUtil.getFirstElement(relationList)).getSrcResourceProviderSn();
        for (ProtectionRelation relation : relationList) {
            result.add(relation.getSrcResourceId());
        }
        this.checkNasHyperMetro(devSn, devSn, new ArrayList<String>(result));
    }

    private void checkNasHyperMetro(String storageDevSn, String productDevSn, List<String> fileSystemIds) {
        HyperMetroPair pair;
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List pairList = null;
        try {
            pairList = storageResourceService.getHyperMetroPairByFileSystems(storageDevSn, fileSystemIds, null, Boolean.valueOf(true));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all fileSystemIds:" + fileSystemIds + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RealTime to query hyperMetro pair error! , all fileSystemIds:" + fileSystemIds), (long)-1L, null, (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("pairList is empty!  fileSystemIds:" + fileSystemIds));
            throw new LegoCheckedException(-1L);
        }
        Iterator iterator = pairList.iterator();
        while (iterator.hasNext() && (pair = (HyperMetroPair)iterator.next()).getDevSn().equals(productDevSn)) {
            Integer syncDirection = pair.getSyncDirection();
            if (VerifyUtil.isEmpty((Object)syncDirection)) {
                logger.error((Object)("The syncDirection is null! pairId:" + pair.getId()));
                throw new LegoCheckedException(-1L);
            }
            if (!String.valueOf(XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()).equals(String.valueOf(syncDirection)) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) continue;
            logger.warn((Object)("hyper metro pair :" + pair.getId() + " pair devsn :" + pair.getDevSn() + " ,execute pg array :" + productDevSn + ", syncDirection:" + syncDirection));
            throw new LegoCheckedException(1073948228L);
        }
    }

    protected int getResourcetype(ProtectGroup protectGroup) {
        int type;
        block2: {
            Set polist = protectGroup.getPolist();
            if (VerifyUtil.isEmpty((Collection)polist)) {
                logger.error((Object)"The Set<ProtectObject> is null!");
                throw new LegoCheckedException(-1L);
            }
            Set allStorageInfo = ((ProtectObject)CommonUtil.getFirstElement((Collection)polist)).getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)allStorageInfo)) {
                logger.error((Object)"The Set<ProtectObjectStorageInfo> is null!");
                throw new LegoCheckedException(-1L);
            }
            type = 1;
            Iterator iterator = allStorageInfo.iterator();
            if (!iterator.hasNext()) break block2;
            ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)iterator.next();
            type = posi.getResourceType();
        }
        return type;
    }

    public boolean checkHyperVault(ProtectGroup protectGroup, ActionContext context) {
        PolicyTemplate template = protectGroup.getTemplate();
        if (VerifyUtil.isEmpty((Object)template)) {
            logger.info((Object)("checkHyperVault empty:" + protectGroup.getUuid()));
            return true;
        }
        if (template.getType() == 28) {
            String prStr = (String)template.getProps().get("protectionRelation");
            if (VerifyUtil.isEmpty((String)prStr)) {
                logger.error((Object)("checkHyperVault protectionRelation is null:" + protectGroup.getUuid()));
                return false;
            }
            List<ProtectionRelation> protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList(prStr);
            if (VerifyUtil.isEmpty(protectionRelations)) {
                logger.error((Object)("checkHyperVault protectionRelations is empty:" + prStr));
                return false;
            }
            context.addObject("VAULT_PATH", protectionRelations);
            ProtectionRelation protectionRelation = (ProtectionRelation)CommonUtil.getFirstElement(protectionRelations);
            String devSn = protectionRelation.getSrcResourceProviderSn();
            String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            if (VerifyUtil.isEmpty((String)vStorePairId) || VerifyUtil.isEmpty((String)devSn)) {
                logger.error((Object)("checkHyperVault vStorePairId or devSn is null:" + protectGroup.getUuid()));
                return false;
            }
            IStorageResourceService srSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            VstoreHyperMetroPair vstoreHyperMetroPair = srSvc.getVstoreHyperMetroPairById(devSn, vStorePairId, Boolean.valueOf(false));
            if (!VerifyUtil.isEmpty((Object)vstoreHyperMetroPair) && String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(vstoreHyperMetroPair.getHealthStatus())) {
                return true;
            }
            Integer activeOrPassive = NumberUtil.convertToInteger((Object)vstoreHyperMetroPair.getActiveOrPassive());
            if (activeOrPassive.equals(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue())) {
                logger.info((Object)("This devSn VstorePair is not activeOrPassive:" + devSn + " ,pairId:" + vStorePairId));
                return false;
            }
        }
        return true;
    }

    public void updateProtectGroupProps(ProtectGroup protectGroup, Map<String, String> props) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        try {
            List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(protectGroup);
            for (Site remoteSite : remoteSites) {
                RestClient client = SiteUtil.initClient((Site)remoteSite);
                JSONObject object = JSONObject.fromObject(props);
                client.put("/ws/protectgroups/{protectGroupId}/action/updateProtectGroupProps", object.toString(), uriVariables);
            }
        }
        catch (Exception e) {
            logger.error((Object)("fail to syncronize protectgroup props to remote site!. PgId:" + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void checkSiteExist(ProtectGroup protectGroup) {
        Set replicas = protectGroup.getReplicaList();
        List<Site> allLocalSite = this.getAllLocalSite(protectGroup);
        for (ProtectGroupReplica replica : replicas) {
            String recoverySiteId = replica.getRecoverySite();
            if (this.isSiteExistInAll(allLocalSite, recoverySiteId)) continue;
            Site recoverSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)recoverSite)) {
                logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
                throw new LegoCheckedException(1073948692L);
            }
            if (1 != recoverSite.getSiteType()) continue;
            this.localSiteCheck(recoverSite, allLocalSite, protectGroup);
            break;
        }
    }

    private void localSiteCheck(Site recoverSite, List<Site> allLocalSite, ProtectGroup protectGroup) {
        Site targetLocalSite = new Site();
        try {
            RestClient client = SiteUtil.initClient((Site)recoverSite);
            List allRemoteSite = client.getForObjects("/ws/sites", null, Site.class);
            Iterator<Site> iterator = allLocalSite.iterator();
            while (iterator.hasNext()) {
                Site localSite;
                targetLocalSite = localSite = iterator.next();
                if (VerifyUtil.isEmpty((Object)localSite)) {
                    logger.error((Object)("local Site is not exsit,id:" + localSite.getSiteId()), 90160758786989L);
                    throw new LegoCheckedException(1073948692L);
                }
                if (this.isSiteExistInAll(allRemoteSite, localSite.getSiteId())) continue;
                throw new LegoCheckedException(1073948209L, new String[]{localSite.getName(), recoverSite.getName()});
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073948209L) {
                logger.error((Object)("there is no local site,name:" + targetLocalSite.getName() + " in remote site,name:" + recoverSite.getName()), 90160758787071L);
            } else {
                logger.error((Object)"to get remote site error!", 90160758787071L);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "find Protect Group,name: " + protectGroup.getName() + " in remote site,name: " + recoverSite.getName() + " ,id: " + recoverSite.getSiteId() + " error";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948209L, (String[])new String[]{targetLocalSite.getName(), recoverSite.getName()}, (Log)logger);
        }
    }

    private boolean isSiteExistInAll(List<Site> allSite, String siteId) {
        if (VerifyUtil.isEmpty(allSite)) {
            return false;
        }
        for (Site localSite : allSite) {
            if (localSite.getSiteType() != 1 || !localSite.getSiteId().equals(siteId)) continue;
            return true;
        }
        return false;
    }

    private List<Site> getAllLocalSite(ProtectGroup protectGroup) {
        ArrayList<Site> allLocalSite = new ArrayList<Site>();
        Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)productSite)) {
            logger.error((Object)"product Site is not exsit", 90160758786989L);
            throw new LegoCheckedException(1073948692L);
        }
        allLocalSite.add(productSite);
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            String recoverySiteId = replica.getRecoverySite();
            if (VerifyUtil.isEmpty((String)recoverySiteId)) {
                logger.error((Object)("Recovery Site is not exsit,id:" + recoverySiteId), 90160758786989L);
                throw new LegoCheckedException(1073948692L);
            }
            Site recoverSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)recoverSite)) {
                logger.error((Object)("Recovery Site is not exsit,id:" + recoverySiteId), 90160758786989L);
                throw new LegoCheckedException(1073948692L);
            }
            if (0 != recoverSite.getSiteType() || allLocalSite.contains(recoverSite)) continue;
            allLocalSite.add(recoverSite);
        }
        return allLocalSite;
    }

    public void syncProtectGroupToRemoteSite(ProtectGroup protectGroup, String url) {
        logger.debug((Object)("url:" + url));
        SynProtectGroupRefineService.getInstance().syncProtectGroupToRemoteSite(protectGroup, url);
    }

    public void synDeletePgToRemote(ProtectGroup protectGroup) {
        if (protectGroup.isPrimary()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", protectGroup.getUuid());
            ProtectGroupSynchronizer.getInstance().syncUpdateProtectGroupToRemoteSite(protectGroup, "/ws/protectgroups/{protectGroupId}", uriVariables, HttpMethod.DELETE);
        }
    }

    public void checkRemoteGroupStatus(ProtectGroup protectGroup) {
        Set disasterSites = RecoveryServiceUtil.getDisasterSiteIds((ProtectGroup)protectGroup);
        if (null == disasterSites || disasterSites.isEmpty()) {
            return;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        String url = "/ws/protectgroups/{protectGroupId}";
        for (String recoverySiteId : disasterSites) {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (site.getSiteType() != 1) continue;
            RestClient client = SiteUtil.initClient((Site)site);
            String str = client.invoke(url, uriVariables, HttpMethod.GET);
            JSONObject jSONObject = JSONObject.fromObject((Object)str);
            Integer remoteStatus = null;
            if (jSONObject.containsKey((Object)"status")) {
                remoteStatus = jSONObject.getInt("status");
            }
            if (null == remoteStatus) {
                logger.error((Object)"remote status unavailable");
                throw new LegoCheckedException(1073948178L);
            }
            ProtectGroup pg = new ProtectGroup();
            pg.setStatus(remoteStatus.intValue());
            if (ProtectionJobUtil.getInstance().isStatusAvailable(pg)) continue;
            logger.error((Object)"remote status unavailable");
            throw new LegoCheckedException(1073948178L);
        }
    }

    public void syncInfoPgToRemote(ProtectGroup protectGroup) {
        if (this.getTemplateType(protectGroup.getUuid()) && this.checkGroupIsPrimary(protectGroup)) {
            this.syncInfo(protectGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void syncInfo(ProtectGroup protectGroup) {
        block11: {
            Session session = null;
            try {
                PolicyTemplate template;
                ProtectGroup oldPg = QueryProtectGroupRefineService.getInstance().getProtectGroupBasicInfo(protectGroup.getUuid(), false);
                if (null != oldPg && null != (template = oldPg.getTemplate()) && 16 == template.getType()) {
                    logger.debug((Object)("the pg template type is array_hyper_clone, no need sync info to remote, type=" + template.getType()));
                    DBOperationUtil.closeSession((Session)session);
                    return;
                }
                session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
                String replicaSql = "SELECT DISTINCT RECSITEID FROM ti_protectgroupreplica WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(replicaSql);
                query.setString("pgid", protectGroup.getUuid());
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) {
                    logger.error((Object)"Get recoverySite from database failed!", 90160758786989L);
                    throw new LegoCheckedException(-1L);
                }
                ArrayList<String> recoverySiteIds = new ArrayList<String>();
                for (int i = 0; i < results.size(); ++i) {
                    Object obj = results.get(i);
                    if (!(obj instanceof String)) continue;
                    recoverySiteIds.add((String)obj);
                }
                ProtectGroup pg = new ProtectGroup();
                pg.setUuid(protectGroup.getUuid());
                pg.setName(protectGroup.getName());
                pg.setDescription(protectGroup.getDescription());
                IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
                protectGroupService.syncUpdateProtectGroupInfoToRemoteSite(recoverySiteIds, pg);
                DBOperationUtil.closeSession((Session)session);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Update protectGroup basic info failed!", e.getErrorCode());
                ExceptionUtil.rethrowException((Exception)((Object)e), (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters());
                DBOperationUtil.closeSession((Session)session);
            }
            catch (Exception ex) {
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Update protectGroup basic info failed!", (long)-1L, (String[])new String[0], (Log)logger);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBOperationUtil.closeSession(session);
            }
        }
    }

    private boolean checkGroupIsPrimary(ProtectGroup protectGroup) {
        boolean bl;
        Session session;
        block5: {
            session = null;
            session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select PGID from ti_protectgroup where ISPRIMARY=:primary and PGID=:pgid";
            NativeQuery query = session.createSQLQuery(sql);
            query.setBoolean("primary", true);
            query.setString("pgid", protectGroup.getUuid());
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) break block5;
            boolean bl2 = true;
            DBOperationUtil.closeSession((Session)session);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to check GroupName because of query error.", (Throwable)e, 90160758786894L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }

    private boolean getTemplateType(String id) {
        boolean bl;
        Session session = null;
        try {
            session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select pt.TYPE from ti_protectgroup pg, ti_policytemplate pt where pg.PGID=:id and pg.PTID=pt.PTID";
            NativeQuery query = session.createSQLQuery(sql);
            query.setString("id", id);
            List results = query.list();
            int type = 2;
            int i = 0;
            if (i < results.size()) {
                type = (Integer)results.get(i);
            }
            bl = !localPgType.contains(type);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to getTemplateType because of database error.", (Throwable)e, 90160758786894L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }
}

