/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SnapshotScheduleObserver
implements IObjectObserver {
    private static Log logger = LogFactory.getInstance(SnapshotScheduleObserver.class);
    private StorageSnapshotScheduleManagerProxy proxy = StorageSnapshotScheduleManagerProxy.getInstance();
    private ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();

    public void before(MessageEvent event) {
        logger.debug((Object)"SnapshotScheduleObserver before start.");
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup) || !this.checkPolicyTemplateType((ProtectGroup)object)) continue;
            this.dealSnapshotScheduleBeforeOperation((ProtectGroup)object, event);
        }
        logger.debug((Object)"SnapshotScheduleObserver before end.");
    }

    public void after(MessageEvent event) {
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private boolean isNeedOperateSnapshotSchedule(Schedule schedule) {
        return SnapshotScheduleUtil.isExistsSecondSchedule(schedule);
    }

    private void dealSnapshotScheduleBeforeOperation(ProtectGroup protectGroup, MessageEvent event) {
        int messageType = event.getMessageType();
        switch (messageType) {
            case 1: {
                this.checkSnapshotSchedule(protectGroup);
                break;
            }
            case 2: {
                this.deleteSnapshotSchedule(protectGroup);
                break;
            }
            case 9: 
            case 11: {
                this.enableSnapshotSchedule(protectGroup, true);
                break;
            }
            case 8: 
            case 10: {
                this.enableSnapshotSchedule(protectGroup, false);
                break;
            }
        }
    }

    private void checkSnapshotSchedule(ProtectGroup protectGroup) {
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (!this.isNeedOperateSnapshotSchedule(schedule)) continue;
            String devSn = (String)devSns.get(schedule.getProtectLocation());
            String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(protectGroup, devSn);
            if (VerifyUtil.isEmpty((String)snapshotScheduleId)) {
                logger.info((Object)"second shcedules not exists.");
                return;
            }
            String snapshotScheduleName = (String)protectGroup.getProps().get("PROP_KEY_SNAPSHOT_SCHEDULE_NAME" + devSn);
            if (VerifyUtil.isEmpty((String)snapshotScheduleName)) {
                snapshotScheduleName = (String)protectGroup.getProps().get("PROP_KEY_SNAPSHOT_SCHEDULE_NAME");
            }
            IStorageSnapshotScheduleManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
            SnapshotSchedule newSchedule = manager.query(devSn, snapshotScheduleId);
            SnapshotSchedule oldSchedule = schedule.getProtectedType() == ScheduleProtectedType.SNAPSHOT.getValue() ? SnapshotScheduleUtil.constructNewSnapshotSchedule(protectGroup.getTemplate(), devSn, schedule) : SnapshotScheduleUtil.constructNewHyperCDPSchedule(protectGroup, devSn, schedule);
            if (VerifyUtil.isEmpty((Object)oldSchedule)) {
                logger.info((Object)"second shcedules not exists.");
                return;
            }
            this.checkSchedule(protectGroup, snapshotScheduleId, snapshotScheduleName, newSchedule, oldSchedule);
        }
    }

    private void checkSchedule(ProtectGroup protectGroup, String snapshotScheduleId, String snapshotScheduleName, SnapshotSchedule newSchedule, SnapshotSchedule oldSchedule) {
        if (null == newSchedule) {
            AlarmReporter.sendAlarm((long)52625488L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{snapshotScheduleId, protectGroup.getName(), snapshotScheduleName});
            throw new LegoCheckedException(-1L);
        }
        if (!this.checkScheduleRunningResult(newSchedule)) {
            AlarmReporter.sendAlarm((long)52625510L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{protectGroup.getName(), newSchedule.getName(), this.getDeviceIp(newSchedule.getDevSn())});
            logger.error((Object)("snapshotSchedule run failed.snapshotScheduleId:" + snapshotScheduleId));
        } else {
            AlarmReporter.restoreAlarm((long)52625489L, (String[])new String[]{snapshotScheduleId});
        }
        if (this.isSnapshotScheduleChanged(protectGroup, oldSchedule, newSchedule)) {
            AlarmReporter.sendAlarm((long)52625489L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{snapshotScheduleId, protectGroup.getName(), newSchedule.getName()});
            logger.error((Object)("snapshotSchedule has changed.snapshotScheduleId:" + snapshotScheduleId));
        } else {
            AlarmReporter.restoreAlarm((long)52625489L, (String[])new String[]{snapshotScheduleId});
        }
    }

    private void deleteSnapshotSchedule(ProtectGroup protectGroup) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            return;
        }
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            String devSn = schedule.getSourceSn();
            String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(protectGroup, devSn);
            if (VerifyUtil.isEmpty((String)snapshotScheduleId)) continue;
            String lunConsistencyGroupId = (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
            String str = (String)protectGroup.getProps().get("PROP_KEY_OLD_SNAPSHOT_SCHEDULE");
            JSONObject obj = JSONObject.fromObject((Object)str);
            try {
                IStorageSnapshotScheduleManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
                manager.delete(devSn, snapshotScheduleId, lunConsistencyGroupId);
                if (obj.isEmpty()) continue;
                Iterator iterator = obj.keys();
                while (iterator.hasNext()) {
                    String deviceSn = (String)iterator.next();
                    String oldSnapshotScheduleId = (String)obj.get(deviceSn);
                    manager.delete(deviceSn, oldSnapshotScheduleId, lunConsistencyGroupId);
                }
            }
            catch (Exception e) {
                logger.error((Object)("delete snapShotSchedule failed." + snapshotScheduleId), (Throwable)e);
            }
        }
    }

    private void enableSnapshotSchedule(ProtectGroup protectGroup, boolean enabled) {
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (!this.isNeedOperateSnapshotSchedule(schedule) || protectGroup.isInvalid() && enabled) continue;
            String devSn = (String)devSns.get(schedule.getProtectLocation());
            String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(protectGroup, devSn);
            if (VerifyUtil.isEmpty((String)snapshotScheduleId)) {
                logger.info((Object)"second shcedules not exists.");
                return;
            }
            IStorageSnapshotScheduleManager manager = this.proxy.getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
            SnapshotSchedule snapshotSchedule = manager.query(devSn, snapshotScheduleId);
            if (null == snapshotSchedule) {
                logger.error((Object)("snapshotSchedule has been deleted." + snapshotScheduleId));
                return;
            }
            manager.enable(devSn, snapshotScheduleId, enabled);
        }
    }

    private boolean checkPolicyTemplateType(ProtectGroup protectGroup) {
        return PolicyTemplateType.ARRAY_SECOND_SNAPSHOT.contains(protectGroup.getTemplate().getType());
    }

    private boolean isSnapshotScheduleChanged(ProtectGroup protectGroup, SnapshotSchedule oldSchedule, SnapshotSchedule newSchedule) {
        if (this.checkLunConsistentGroup(protectGroup, newSchedule)) {
            return true;
        }
        if (!oldSchedule.getSnapshotMaxNum().equals(newSchedule.getSnapshotMaxNum())) {
            return true;
        }
        if (!oldSchedule.getFrequencyValue().equals(newSchedule.getFrequencyValue())) {
            return true;
        }
        Map oldScheduleProps = oldSchedule.getProps();
        Map newScheduleProps = newSchedule.getProps();
        if (!this.isSameToOther((String)oldScheduleProps.get("WEEKLYDAYS"), (String)newScheduleProps.get("WEEKLYDAYS"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("STARTTIMEOFWEEK"), (String)newScheduleProps.get("STARTTIMEOFWEEK"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("WEEKLYSNAPSHOTNUM"), (String)newScheduleProps.get("WEEKLYSNAPSHOTNUM"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("DAYHOURS"), (String)newScheduleProps.get("DAYHOURS"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("DAYMINUTE"), (String)newScheduleProps.get("DAYMINUTE"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("DAILYSNAPSHOTNUM"), (String)newScheduleProps.get("DAILYSNAPSHOTNUM"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("MONTHDAYS"), (String)newScheduleProps.get("MONTHDAYS"))) {
            return true;
        }
        if (!this.isSameToOther((String)oldScheduleProps.get("STARTTIMEOFMONTH"), (String)newScheduleProps.get("STARTTIMEOFMONTH"))) {
            return true;
        }
        return !this.isSameToOther((String)oldScheduleProps.get("MONTHSNAPSHOTNUM"), (String)newScheduleProps.get("MONTHSNAPSHOTNUM"));
    }

    private boolean isSameToOther(String str1, String str2) {
        if (VerifyUtil.isEmpty((String)str1) && (VerifyUtil.isEmpty((String)str2) || "[]".equals(str2) || "-1".equals(str2))) {
            return true;
        }
        return !VerifyUtil.isEmpty((String)str1) && !VerifyUtil.isEmpty((String)str2) && str1.equals(str2);
    }

    private boolean checkLunConsistentGroup(ProtectGroup protectGroup, SnapshotSchedule schedule) {
        if (SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue() != schedule.getScheduleType()) {
            return false;
        }
        String devSn = schedule.getDevSn();
        IStorageLunGroupManager lunGroupManager = StorageLunGroupManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
        List list = lunGroupManager.queryConsistencyGroups(devSn, XveMOType.SNAPSHOTSCHEDULE, schedule.getId());
        if (VerifyUtil.isEmpty((Collection)list)) {
            logger.error((Object)("lunConsistentGroup of schedule is removed. scheduleId:" + schedule.getId()));
            return true;
        }
        String lunConsistencyGroupId = (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        if (VerifyUtil.isEmpty((String)lunConsistencyGroupId)) {
            return false;
        }
        for (LunConsistencyGroup lunConsistencyGroup : list) {
            if (!lunConsistencyGroupId.equals(lunConsistencyGroup.getId())) continue;
            return false;
        }
        logger.error((Object)("lunConsistentGroup of schedule is removed. scheduleId:" + schedule.getId()));
        return true;
    }

    private boolean checkScheduleRunningResult(SnapshotSchedule schedule) {
        if (null == schedule) {
            return true;
        }
        return schedule.getLastExecutionResult() != 2;
    }

    private String getDeviceIp(String devSn) {
        Map info = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageAddressInfo(devSn);
        String deviceIp = "";
        if (info.containsKey("linkIp")) {
            deviceIp = String.valueOf(info.get("linkIp"));
        }
        return deviceIp;
    }
}

