/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdateDiskProtectedBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UpdateDiskProtectedBackTask.class);
    private ProtectGroup protectGroup;
    private List<StoragePair> storagePairs;
    private IReplicaBuilder replicaBuilder;
    private ProtectGroupServiceImpl service;
    private Set<String> volumeIdSet;

    public UpdateDiskProtectedBackTask(List<StoragePair> storagePairs, ProtectGroup protectGroup, Set<String> volumeIdSet) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.instance.disk.update", (String)"System", (String)"", null), true);
        this.storagePairs = storagePairs;
        this.protectGroup = protectGroup;
        this.service = (ProtectGroupServiceImpl)((Object)ServiceLocator.getInstance().getService(ProtectGroupServiceImpl.class));
        this.volumeIdSet = volumeIdSet;
        this.replicaBuilder = ReplicaBuilderFactory.getInstance().getTemplateByType(protectGroup.getTemplate().getType());
    }

    protected void doWork() {
        boolean lockFlag;
        JSONArray jsonArray = new JSONArray();
        if (!VerifyUtil.isEmpty(this.storagePairs)) {
            jsonArray.addAll((Collection)JSONArray.fromObject(this.storagePairs));
            this.protectGroup.getProps().put("storagePoolMapping", jsonArray.toString());
        }
        if (!(lockFlag = ProtectionJobUtil.getInstance().getLockPg(this.protectGroup.getUuid()))) {
            logger.error((Object)"The pg is locked, pgUuid: %s.", new Object[]{this.protectGroup.getUuid()});
            throw new LegoCheckedException(1073948196L);
        }
        try {
            this.refreshProtectObjectStorageInfo();
            MessageEvent event = new MessageEvent();
            event.setMessageType(3);
            ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
            objectList.add(this.protectGroup);
            event.setObjectList(objectList);
            CreateProtectGroupRefineService instanceService = CreateProtectGroupRefineService.getInstance();
            instanceService.notifyObserverList(event, "before");
            this.dealExpandLun();
            this.replicaBuilder.buildReplica(this.protectGroup);
            this.service.syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
            this.service.getBaseDao().update((Object)this.protectGroup);
            logger.debug((Object)"Build replica success for %s.", new Object[]{this.protectGroup.getName()});
            this.syncConsistentGroup();
            logger.debug((Object)"Add protect objects success for %s.", new Object[]{this.protectGroup.getName()});
            ProtectionJobUtil.getInstance().releaseLockPg(this.protectGroup.getUuid());
            instanceService.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Update disk protect error, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(this.protectGroup.getUuid());
        }
    }

    private void refreshProtectObjectStorageInfo() {
        List newStorageInfoSet = this.protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)newStorageInfoSet)) {
            logger.error((Object)"Param newStorageInfoSet is empty.");
            throw new LegoCheckedException(1073948417L);
        }
        if (VerifyUtil.isEmpty(this.volumeIdSet)) {
            newStorageInfoSet.forEach(storageInfo -> storageInfo.setNeedRelease(false));
            return;
        }
        newStorageInfoSet.forEach(storageInfo -> {
            if (this.volumeIdSet.contains(storageInfo.getResourceName())) {
                storageInfo.setNeedRelease(true);
            }
        });
    }

    private void dealExpandLun() {
        IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List diskInfoList = groupService.queryDiskInfo(this.protectGroup);
        for (DiskInfo diskInfo : diskInfoList) {
            String diskStatus = diskInfo.getStatus();
            if (!DiskProtectStatusEnum.EXPANDED.getStatus().equals(diskStatus)) continue;
            try {
                this.expandTargetLun(diskInfo);
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)"Expand target lun failed id :%s,error is %s.", new Object[]{diskInfo.getResourceId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw ex;
            }
            catch (Exception ex) {
                logger.error((Object)"Expand target lun failed id :%s, error is %s.", new Object[]{diskInfo.getResourceId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw new LegoCheckedException(100664655L, (Throwable)ex);
            }
        }
    }

    private void syncHypermetroGroup(Set<String> cgIds, Set<RelicaStorageInfo> relicaStorageInfoList) {
        StoragePair storagePair = this.getStoragePair();
        for (RelicaStorageInfo relicaStorageInfo : relicaStorageInfoList) {
            if (!(relicaStorageInfo instanceof RemoteStorageReplica)) continue;
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)relicaStorageInfo;
            String cgId = remoteStorageReplica.getConsistentGroupId();
            String srcSn = remoteStorageReplica.getSrcStorageProviderSN();
            this.startHypermetroCg(cgIds, storagePair, cgId, srcSn);
        }
    }

    private void startHypermetroCg(Set<String> cgIds, StoragePair storagePair, String cgId, String srcSn) {
        if (!cgIds.contains(cgId)) {
            try {
                StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(srcSn).startHypermetroCGroup(srcSn, storagePair.getSrcControlClusterId(), cgId);
            }
            catch (Exception ex) {
                logger.error((Object)"sync hypermetroCGroup failed. SN:%s, cgId: %s", new Object[]{srcSn, cgId});
                throw ex;
            }
            cgIds.add(cgId);
        }
    }

    private StoragePair getStoragePair() {
        StoragePair storagePair = null;
        String replicationCfg = (String)this.protectGroup.getProps().get("storagePoolMapping");
        if (!VerifyUtil.isEmpty((String)replicationCfg)) {
            storagePair = (StoragePair)JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)replicationCfg), StoragePair.class).get(0);
        }
        if (storagePair == null) {
            throw new LegoCheckedException(1073947394L, "StoragePair is null.");
        }
        return storagePair;
    }

    private void syncConsistentGroup() {
        HashSet<String> cgIds = new HashSet<String>();
        Set replicaList = this.protectGroup.getReplicaList();
        int templateType = this.protectGroup.getTemplate().getType();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set protectObjectReplicaList = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaList) {
                Set relicaStorageInfoList = protectObjectReplica.getStorageInfos();
                if (templateType == 33 || templateType == 39) {
                    this.syncConsistentGroup(cgIds, relicaStorageInfoList);
                }
                if (templateType != 38) continue;
                this.syncHypermetroGroup(cgIds, relicaStorageInfoList);
            }
        }
    }

    private void syncConsistentGroup(Set<String> cgIds, Set<RelicaStorageInfo> relicaStorageInfoList) {
        for (RelicaStorageInfo relicaStorageInfo : relicaStorageInfoList) {
            OperationResult result;
            if (!(relicaStorageInfo instanceof RemoteStorageReplica)) continue;
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)relicaStorageInfo;
            String consistentGroupId = remoteStorageReplica.getConsistentGroupId();
            String srcSn = remoteStorageReplica.getSrcStorageProviderSN();
            String tgtSn = remoteStorageReplica.getStorageProviderSN();
            String cgIdSrcSnTagSn = consistentGroupId + "@" + srcSn + "@" + tgtSn;
            if (cgIds.contains(cgIdSrcSnTagSn)) continue;
            try {
                StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
                result = sraProxy.getStorageReplicationAdapter(srcSn).syncOnce(srcSn, tgtSn, consistentGroupId, true);
            }
            catch (Exception ex) {
                logger.error((Object)"Sync consistentGroup failed. SN:%s, error is %s.", new Object[]{SecurityUtil.desensitizeId((String)cgIdSrcSnTagSn), ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw ex;
            }
            if (result == null) {
                logger.error((Object)"Sync consistentGroup result is null. SN:%s.", new Object[]{SecurityUtil.desensitizeId((String)cgIdSrcSnTagSn)});
                throw new LegoCheckedException(0x300001L);
            }
            if (!result.isSuccess()) {
                logger.error((Object)"Sync consistentGroup failed. SN:%s.", new Object[]{SecurityUtil.desensitizeId((String)cgIdSrcSnTagSn)});
                throw new LegoCheckedException(result.getErrorCode());
            }
            cgIds.add(cgIdSrcSnTagSn);
        }
    }

    private void expandTargetLun(DiskInfo diskInfo) {
        for (SubDiskInfo subDiskInfo : diskInfo.getSubDiskInfo()) {
            try {
                if (subDiskInfo.getCapacity() == null || diskInfo.getCapacity().equals(subDiskInfo.getCapacity())) continue;
                Lun subLun = new Lun();
                if (diskInfo.getCapacity() > subDiskInfo.getCapacity()) {
                    subLun.setDevSn(subDiskInfo.getDevSn());
                    subLun.setName(subDiskInfo.getName());
                    subLun.setCapacity(diskInfo.getCapacity());
                } else {
                    subLun.setDevSn(diskInfo.getDevSn());
                    subLun.setName(diskInfo.getDeviceName());
                    subLun.setCapacity(subDiskInfo.getCapacity());
                }
                DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)((Object)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class));
                if (!drmStorageService.expandLun(subLun.getDevSn(), subLun)) {
                    logger.error((Object)"Expand target lun failed sn:%s, name:%s.", new Object[]{SecurityUtil.desensitizeId((String)subLun.getDevSn()), subLun.getName()});
                    throw new LegoCheckedException(100664655L);
                }
                drmStorageService.queryLunByDevSnAndLunIds(subDiskInfo.getDevSn(), Collections.singletonList(subDiskInfo.getResourceId()));
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)"Expand target lun failed, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw new LegoCheckedException(100664655L, (Throwable)ex);
            }
        }
    }
}

