/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class QueryProtectGroupRefineExtendService {
    private static final QueryProtectGroupRefineExtendService INSTANCE = new QueryProtectGroupRefineExtendService();
    private static final ConcurrentHashMap<String, Site> SITE_CACHE = new ConcurrentHashMap();
    private static final Log logger = LogFactory.getInstance(QueryProtectGroupRefineExtendService.class);
    private static final String QUERY_ALL_PG_SQL = "select pg.PGID, pg.UUID, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pg.PGPROVIDERSN, pt.ptId, pg.PGDESC, pg.LASTEXECTIME from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId";

    private QueryProtectGroupRefineExtendService() {
    }

    public static QueryProtectGroupRefineExtendService getInstance() {
        logger.debug((Object)"getInstance");
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ProtectGroup> getTopoAllProtectGroupBasicInfo(Long userId) {
        List list;
        List results;
        Session session;
        block8: {
            session = null;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(QUERY_ALL_PG_SQL);
            results = query.list();
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)results)) break block8;
            List<ProtectGroup> list2 = Collections.emptyList();
            DBOperationUtil.closeSession((Session)session);
            return list2;
        }
        try {
            List pgs = QueryProtectGroupRefineService.getInstance().constructProtectGroups(results);
            for (ProtectGroup protectGroup : pgs) {
                if (protectGroup.getTemplate().getType() == 38) {
                    Set pgReplicas = QueryProtectGroupRefineService.getInstance().getProtectGroupReplicas(protectGroup.getUuid(), session);
                    protectGroup.setReplicaList(pgReplicas);
                }
                if (protectGroup.getTemplate().getType() != 38) {
                    protectGroup.setProps(this.getProtectGroupProps(protectGroup.getUuid(), session));
                    this.updateProductSiteName(protectGroup);
                    continue;
                }
                this.updateProductSiteNameWithCache(protectGroup);
                protectGroup.setProps(new HashMap());
            }
            list = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, pgs);
        }
        catch (Exception err) {
            try {
                logger.error((Object)"Getting pg failed, err msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err), 90160758784001L});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return Collections.emptyList();
        }
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    private void updateProductSiteName(ProtectGroup protectGroup) {
        logger.debug((Object)"updateProductSiteName");
        String productSiteName = "--";
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)site)) {
            productSiteName = site.getName();
        }
        protectGroup.setProductSiteName(productSiteName);
    }

    private void updateProductSiteNameWithCache(ProtectGroup protectGroup) {
        String productSiteName = "--";
        if (SITE_CACHE.containsKey(protectGroup.getProductSiteId())) {
            productSiteName = SITE_CACHE.get(protectGroup.getProductSiteId()).getName();
        } else {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
            if (!VerifyUtil.isEmpty((Object)site)) {
                productSiteName = site.getName();
                SITE_CACHE.put(protectGroup.getProductSiteId(), site);
            }
        }
        protectGroup.setProductSiteName(productSiteName);
    }

    public Map<String, String> getProtectGroupProps(String pgId, Session session) {
        logger.debug((Object)"pgId:%s", new Object[]{pgId});
        Map<String, String> props = new HashMap<String, String>();
        String strSql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID=:pgId";
        NativeQuery query = session.createSQLQuery(strSql);
        query.setString("pgId", pgId);
        List results = query.list();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)results)) {
            props = this.constructExtendProperties(results);
        }
        return props;
    }

    private Map<String, String> constructExtendProperties(List<?> result) {
        logger.debug((Object)"constructExtendProperties");
        HashMap<String, String> props = new HashMap<String, String>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 3) continue;
            String propName = CommUtil.convertToString((Object)values[1]);
            String propValue = CommUtil.convertToString((Object)values[2]);
            props.put(propName, propValue);
        }
        String instProtectType = (String)props.get("serviceInstanceType");
        ServiceInstaceEnumDefine.ServiceInstanceTypeE filterValue = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)instProtectType);
        if (filterValue != null) {
            props.put("instProtectType", filterValue.getFrontValue());
        }
        return props;
    }
}

