/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.subscriber;

import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.subscriber.AbstractExecuteSuccessSubscriber;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackupSubscriber
extends AbstractExecuteSuccessSubscriber {
    private static final Log logger = LogFactory.getInstance(BackupSubscriber.class);

    public BackupSubscriber(IMessageCenter messageCenter) {
        messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    @Override
    protected void handleProtectGroup(ProtectGroup protectGroup, Map<String, Object> parameter) {
        ProtectGroupReplica replica = protectGroup.getLatestRepica();
        logger.info((Object)("replica type is" + replica.getType()));
        if (!replica.isStorageReplicationReplica()) {
            return;
        }
        if (null == parameter) {
            parameter = new HashMap<String, Object>();
        }
        parameter.put("REPLICA_TIMESTANP", replica.getTimeStamp());
        Integer protectedType = ProtectionJobExtendUtil.getInstance().getBackupTypeExcuteSync(parameter);
        List<Schedule> schedules = this.getSchedules(protectGroup.getTemplate(), protectedType, replica.getProtectLocation());
        for (Schedule schedule : schedules) {
            logger.info((Object)("excute schedule:" + schedule.getScheduleId()));
            IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
            service.runTask(protectGroup.getUuid(), schedule.getScheduleId(), parameter);
        }
    }

    private List<Schedule> getSchedules(PolicyTemplate template, Integer protectedType, int location) {
        ArrayList<Schedule> list = new ArrayList<Schedule>();
        for (Schedule schedule : template.getSchedules()) {
            if (schedule.getProtectLocation() != location || schedule.getProtectedType() == -1 || schedule.isEnable() == null || !schedule.isEnable().booleanValue()) continue;
            if (null == protectedType) {
                if (!ScheduleProtectedType.getAllProtectedTypes().contains(schedule.getProtectedType())) continue;
                list.add(schedule);
                continue;
            }
            if (schedule.getProtectedType() != protectedType.intValue()) continue;
            list.add(schedule);
        }
        return list;
    }
}

