/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.util;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.framework.service.group.util.AbstractProtectGroupExcelOperator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ProtectGroupExcelOperator
extends AbstractProtectGroupExcelOperator {
    private static final Log logger = FELogFactory.getInstance((String)"ui");
    private static List<Integer> notLoadReplicaTemplateTypeList = Arrays.asList(2, 19, 17, 28, 30, 31, 32);

    protected void createDataArea(XSSFSheet sheet, List<ProtectGroup> protectgroups) {
        Map<String, List<List<String>>> dataMap = this.getInfoByPo(protectgroups);
        int rowIndex = 2;
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        this.initialDataAreaCellStyle(sheet, cs);
        HashMap<String, List<String>> groupResourceIds = new HashMap<String, List<String>>();
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        for (ProtectGroup protectgroup : protectgroups) {
            if (inSensitiveToStorageTemplateTypeList.contains(protectgroup.getTemplate().getType()) || notLoadReplicaTemplateTypeList.contains(protectgroup.getTemplate().getType())) continue;
            List replicaList = replicaService.queryProtectGroupReplicaByGroup(protectgroup.getUuid(), null, false, null);
            if (VerifyUtil.isEmpty((Collection)replicaList)) {
                logger.debug((Object)("replicaList is empty! pg name :" + protectgroup.getName()));
                continue;
            }
            protectgroup.getReplicaList().clear();
            protectgroup.getReplicaList().addAll(replicaList);
            for (ProtectGroupReplica pgr : replicaList) {
                this.groupingResourceIdsByDeviceSN(pgr, groupResourceIds);
            }
        }
        Set entrySet = groupResourceIds.entrySet();
        ArrayList<BatchOperation> counterror = new ArrayList<BatchOperation>();
        for (Map.Entry entry : entrySet) {
            String deviceSn = (String)entry.getKey();
            List<StorageResource> resources = this.getStorageResources(deviceSn, (List)entry.getValue());
            for (StorageResource storageResource : resources) {
                this.storageResources.put(storageResource.getDevSn() + storageResource.getResourceId(), storageResource);
            }
        }
        for (ProtectGroup protectgroup : protectgroups) {
            List<List<String>> poRows = dataMap.get(protectgroup.getUuid());
            int mergeCnt = VerifyUtil.isEmpty(poRows) ? 1 : poRows.size();
            int rowMergeIndex = rowIndex + mergeCnt - 1;
            BatchOperation batchOperation = this.generatePgInExcelCell(sheet, rowIndex, rowMergeIndex, cs, protectgroup);
            this.generatePoInExcelCell(sheet, rowIndex, cs, poRows);
            rowIndex += mergeCnt;
            if (VerifyUtil.isEmpty((String)batchOperation.getTargetName())) continue;
            counterror.add(batchOperation);
        }
        this.result.setResult(counterror);
        this.result.setFailCount(counterror.size());
        this.result.setTotalCount(protectgroups.size());
    }

    private void groupingResourceIdsByDeviceSN(ProtectGroupReplica pgr, Map<String, List<String>> deviceLuns) {
        logger.debug((Object)"to groupingResourceIdsByDeviceSN start.. pgr uuid:%s, deviceLuns:%s", new Object[]{pgr.getId(), deviceLuns});
        for (ProtectObjectReplica por : pgr.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                String deviceSn = rsi.getSrcStorageProviderSN();
                String lunId = rsi.getSrcStorageId();
                String tgtDeviceSn = rsi.getStorageProviderSN();
                String tgtLunId = rsi.getStorageId();
                if (deviceLuns.containsKey(deviceSn)) {
                    if (!deviceLuns.get(deviceSn).contains(lunId)) {
                        deviceLuns.get(deviceSn).add(lunId);
                    }
                } else {
                    deviceLuns.put(deviceSn, new ArrayList());
                    deviceLuns.get(deviceSn).add(lunId);
                }
                if (deviceLuns.containsKey(tgtDeviceSn)) {
                    if (deviceLuns.get(tgtDeviceSn).contains(tgtLunId)) continue;
                    deviceLuns.get(tgtDeviceSn).add(tgtLunId);
                    continue;
                }
                deviceLuns.put(tgtDeviceSn, new ArrayList());
                deviceLuns.get(tgtDeviceSn).add(tgtLunId);
            }
        }
    }

    protected List<StorageResource> getStorageResources(String deviceSn, List<String> resourceIds) {
        logger.debug((Object)("to getStorageResources. deviceSn:" + deviceSn + ", resourceIds:" + resourceIds));
        CommUtil.checkParamEmpty((Object[])new Object[]{deviceSn, resourceIds});
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List srList = storageService.getStorageResources(deviceSn, resourceIds);
        return srList;
    }

    protected Map<String, List<List<String>>> getInfoByPo(List<ProtectGroup> protectgroups) {
        logger.debug((Object)"to getInfoByPo start..");
        HashMap<String, List<List<String>>> dataMap = new HashMap<String, List<List<String>>>();
        for (ProtectGroup protectgroup : protectgroups) {
            String key = protectgroup.getUuid();
            ArrayList data = new ArrayList();
            DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(protectgroup.getPoProviderSN());
            for (ProtectObject protectobject : protectgroup.getPolist()) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(protectobject.getName());
                data.add(row);
                if (protectobject.getPoType() == 14) {
                    DrResource nasSource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(protectobject.getProviderSN());
                    row.add(this.getText(nasSource.getClass().getName()));
                    row.add(nasSource.getIpAddress());
                    continue;
                }
                row.add(this.getText(dr.getClass().getName()));
                if (dr instanceof DrHostGroup) {
                    StringBuffer ipList = new StringBuffer();
                    for (DrResource dRes : dr.getChildResources()) {
                        ipList.append(dRes.getIpAddress());
                        ipList.append("\n");
                    }
                    row.add(ipList.toString().trim());
                    continue;
                }
                row.add(dr.getIpAddress());
            }
            dataMap.put(key, data);
        }
        return dataMap;
    }
}

