/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractBaseProtectObjectProvider;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.model.VMConfigs;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProtectObjectProvider
extends AbstractBaseProtectObjectProvider
implements IProtectObjectProvider {
    private static final Log logger = LogFactory.getInstance(AbstractProtectObjectProvider.class);

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        return null;
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int replicationType) {
        return this.getSupportPolicyTemplate(protectObjectList);
    }

    public void refreshProtectGroup(ProtectGroup protectGroup) {
        this.updateProtectObjectsProps(protectGroup);
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        Map changes = service.getStorageInfoChangedProtectObjectList(protectGroup);
        ProtectGroupHelper helper = ProtectGroupHelper.getInstance();
        PolicyTemplate newTemplate = helper.matchAvailableTemplate(protectGroup);
        if (!VerifyUtil.isEmpty((Object)newTemplate)) {
            protectGroup.setTemplate(newTemplate);
        } else {
            helper.checkPolicyTemplate(protectGroup);
        }
        boolean replicaRebuilded = false;
        if (!VerifyUtil.isEmpty((Map)changes) || 16 == protectGroup.getTemplate().getType()) {
            int oldSubType = protectGroup.getTemplate().getSubType();
            helper.buildReplica(protectGroup, false);
            this.refreshPolicyTemplate(protectGroup, oldSubType);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus());
            replicaRebuilded = true;
        }
        if (!replicaRebuilded && (ProtectGroupExtendUtil.isReplicationTemplate(protectGroup.getTemplate().getType()) || 2 == protectGroup.getTemplate().getType() || 19 == protectGroup.getTemplate().getType())) {
            Set oldReplicaList = this.getOldProtectGroupReplica(protectGroup.getReplicaList());
            helper.buildReplica(protectGroup, false);
            this.recoveryReplicaStatus(oldReplicaList, protectGroup.getReplicaList());
        }
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(protectGroup.getTemplate().getType());
        filter.refreshPolicy(protectGroup);
    }

    public BatchOperationResult multiSetVmBlockIoHangTimeout(String cloudSn, List<VMConfigs> vmConfigsList) {
        throw new LegoCheckedException("Not supported.");
    }
}

