/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.provider.ProtectObjectProviderBaseDelegateImpl;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.model.QueryPOPage;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageAppManagerProxy;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate", desc="", interfaceClass=IProtectObjectProviderDelegate.class)
public class ProtectObjectProviderDelegateImpl
extends ProtectObjectProviderBaseDelegateImpl
implements IProtectObjectProviderDelegate {
    private static final Log logger = LogFactory.getInstance(ProtectObjectProviderDelegateImpl.class);
    private static final String CONFIGURE_ENABLE_4DC_TEMPLATE = "enable_4dc_template";
    private static Map<Integer, List<Integer>> mutexTemplateMap = new HashMap<Integer, List<Integer>>();
    private static Map<Integer, List<Integer>> priorityTemplateMap = new HashMap<Integer, List<Integer>>();
    private static List<Integer> doubleActiveTempateList = Arrays.asList(15, 18, 23, 19, 26, 27, 28, 31, 31, 32, 35, 36);

    public ProtectObjectProviderDelegateImpl() {
        this.providerList = new ConcurrentHashMap();
    }

    public QueryPOPage getAvailableProtectObjectPage(int applicationType, String poProviderSn, Map<String, Object> extendCondition) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAvailableProtectObjectPage(poProviderSn, extendCondition);
    }

    public List<PolicyTemplate> getAvailablePolicyTemplate(int appType, List<ProtectObject> poList, int replicationType) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(appType);
        provider.loadProtectObjectStorageInfo(poList);
        List ptList = provider.getSupportPolicyTemplate(poList, replicationType);
        if (null != ptList && !ptList.isEmpty()) {
            return this.filterAvailablePolicyTemplate(ptList, poList, appType);
        }
        return new ArrayList<PolicyTemplate>();
    }

    private List<PolicyTemplate> filterAvailablePolicyTemplate(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        ArrayList<PolicyTemplate> result = new ArrayList<PolicyTemplate>();
        Set<Integer> mutexTemplateSet = this.exludeMutexTemplate(poList);
        this.filterOutTemplateByStorageInfo(ptList, poList, appType);
        ptList = this.filterStorageSupportProtectType(ptList, poList, appType);
        ptList = this.filterForConfig(ptList);
        ArrayList<PolicyTemplate> policyTemplateToFilter = new ArrayList<PolicyTemplate>();
        for (PolicyTemplate template : ptList) {
            int type = template.getType();
            if (mutexTemplateSet.contains(type)) {
                template.setAvailable(false);
                template.setErrorCode(1073948214L);
                result.add(template);
                continue;
            }
            if (!template.isAvailable()) {
                result.add(template);
                continue;
            }
            policyTemplateToFilter.add(template);
        }
        result.addAll(PolicyTemplateTools.getInstance().filterAvaiableTemplate(poList, policyTemplateToFilter));
        this.hideLowPriorityTemplate(result);
        return this.classifyPolicyTemplate(result);
    }

    private List<PolicyTemplate> classifyPolicyTemplate(List<PolicyTemplate> result) {
        HashMap<Integer, PolicyTemplate> classifiedTemplateMap = new HashMap<Integer, PolicyTemplate>();
        for (PolicyTemplate pt : result) {
            PolicyTemplate policyTemplate;
            int type = pt.getType();
            if (type == 29 || type == 25) continue;
            Integer classifiedType = (Integer)ProtectGroupHelper.getInstance().getClassifiedPolicyTemplates().get(type);
            if (classifiedType == null) {
                logger.error((Object)"The type of the policytemplate is not added to PolicyTemplateType.CLASSIFIED_POLICYTEMPLATE! ");
            }
            if ((policyTemplate = (PolicyTemplate)classifiedTemplateMap.get(classifiedType)) != null && !pt.isAvailable()) continue;
            classifiedTemplateMap.put(classifiedType, pt);
        }
        return new ArrayList<PolicyTemplate>(classifiedTemplateMap.values());
    }

    private void hideLowPriorityTemplate(List<PolicyTemplate> result) {
        HashSet<Integer> allType = new HashSet<Integer>();
        for (PolicyTemplate pt : result) {
            if (!pt.isAvailable()) continue;
            allType.add(pt.getType());
        }
        block1: for (PolicyTemplate pt : result) {
            int type = pt.getType();
            List<Integer> highPriorityTypes = priorityTemplateMap.get(type);
            if (VerifyUtil.isEmpty(highPriorityTypes)) continue;
            for (Integer highPriorityType : highPriorityTypes) {
                if (!allType.contains(highPriorityType)) continue;
                pt.setAvailable(false);
                pt.setErrorCode(1073948191L);
                continue block1;
            }
        }
    }

    private List<PolicyTemplate> filterForConfig(List<PolicyTemplate> ptList) {
        if (VerifyUtil.isEmpty(ptList)) {
            return ptList;
        }
        Boolean enable4DC = Boolean.valueOf(LegoConfig.getInstance().getKeyValue(CONFIGURE_ENABLE_4DC_TEMPLATE));
        Iterator<PolicyTemplate> it = ptList.iterator();
        while (it.hasNext()) {
            PolicyTemplate template = it.next();
            if (enable4DC.booleanValue() || 35 != template.getType() && 36 != template.getType()) continue;
            it.remove();
        }
        ptList.removeIf(policyTemplate -> policyTemplate.getType() == 19);
        return ptList;
    }

    private List<PolicyTemplate> filterStorageSupportProtectType(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        Set resourceSet = poList.get(0).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)resourceSet)) {
            return ptList;
        }
        String deviceId = ((ProtectObjectStorageInfo)resourceSet.iterator().next()).getResourceProviderSN();
        Map<Integer, List> appMap = StorageAppManagerProxy.getInstance().getSupportedApp(deviceId);
        if (null == appMap) {
            return ptList;
        }
        List appPoTypes = appMap.get(appType);
        ArrayList<PolicyTemplate> ptListTmp = new ArrayList<PolicyTemplate>();
        if (!VerifyUtil.isEmpty((Collection)appPoTypes)) {
            for (PolicyTemplate template : ptList) {
                if (!appPoTypes.contains(template.getType())) continue;
                ptListTmp.add(template);
            }
        }
        return ptListTmp;
    }

    private void filterOutTemplateByStorageInfo(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        for (ProtectObject po : poList) {
            if (VerifyUtil.isEmpty((Object)po)) {
                logger.error((Object)"The protectObject is empty!", 90160758787071L);
                continue;
            }
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
                logger.error((Object)("The usedStorageResourceSet is empty! po,MoUuid: " + po.getMoUuid() + ", poName:" + po.getName()), 90160758787071L);
                continue;
            }
            Boolean isDoubleActiveResourceExisted = this.isDoubleActiveResourceExisted(usedStorageResourceSet);
            if (!isDoubleActiveResourceExisted.booleanValue()) continue;
            for (PolicyTemplate pt : ptList) {
                this.checkPolicyTemple(pt);
            }
        }
        this.checkNasHyperMetorAsyncRep(ptList, poList, appType);
        this.checkNasHyperMetorSnapshot(ptList, poList);
    }

    private void checkNasHyperMetorSnapshot(List<PolicyTemplate> ptList, List<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList) || VerifyUtil.isEmpty(ptList)) {
            return;
        }
        Set usedStorageResourceSet = ((ProtectObject)CommonUtil.getFirstElement(poList)).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            return;
        }
        Integer resourceType = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)usedStorageResourceSet)).getResourceType();
        if (null != resourceType && resourceType.equals(DrmEnumDefine.ResourceTypeE.NAS.getValue())) {
            for (PolicyTemplate pt : ptList) {
                int type = pt.getType();
                if (19 != type) continue;
                pt.setAvailable(false);
                pt.setErrorCode(1073948191L);
                logger.debug((Object)"Nas not surrpot Hyper snapshot");
                break;
            }
        }
    }

    private void checkNasHyperMetorAsyncRep(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        if (VerifyUtil.isEmpty(poList) || VerifyUtil.isEmpty(ptList)) {
            return;
        }
        Set usedStorageResourceSet = ((ProtectObject)CommonUtil.getFirstElement(poList)).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            return;
        }
        Integer resourceType = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)usedStorageResourceSet)).getResourceType();
        if (12 == appType && null != resourceType && resourceType.equals(DrmEnumDefine.ResourceTypeE.NAS.getValue())) {
            for (PolicyTemplate pt : ptList) {
                int type = pt.getType();
                if (18 != type && 20 != type) continue;
                pt.setAvailable(false);
                pt.setErrorCode(1073948191L);
                logger.debug((Object)"Nas not surrpot Hyper asyncReplication");
            }
        }
    }

    private void checkPolicyTemple(PolicyTemplate pt) {
        int type = pt.getType();
        if (!doubleActiveTempateList.contains(type)) {
            pt.setAvailable(false);
            pt.setErrorCode(1073948191L);
        }
    }

    private Boolean isDoubleActiveResourceExisted(Set<ProtectObjectStorageInfo> usedStorageResourceSet) {
        Boolean isDoubleActiveResourceExisted = false;
        for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
            List pairList;
            if (Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()).equals(protectObjectStorageInfo.getResourceType())) {
                pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByFileSystemIds(null, protectObjectStorageInfo.getResourceProviderSN(), Arrays.asList(protectObjectStorageInfo.getResourceId()), null, true);
                if (!this.isAllPairNormal(pairList)) continue;
                logger.info((Object)"The nas resource is double Active Resource!");
                isDoubleActiveResourceExisted = true;
                break;
            }
            String wwn = protectObjectStorageInfo.getLunWWN();
            if (VerifyUtil.isEmpty((String)wwn)) continue;
            List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{wwn});
            ArrayList<String> wwnList = new ArrayList<String>();
            wwnList.add(wwn);
            pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(null, wwnList, null, true);
            if (!this.isAllPairNormal(pairList) || resources.size() != 2) continue;
            logger.info((Object)"The resource is double Active Resource!", 90160758786897L);
            isDoubleActiveResourceExisted = true;
            break;
        }
        return isDoubleActiveResourceExisted;
    }

    private boolean isAllPairNormal(List<HyperMetroPair> pairList) {
        if (!VerifyUtil.isEmpty(pairList)) {
            for (HyperMetroPair hyperMetroPair : pairList) {
                if (String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(hyperMetroPair.getRunningState())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<Integer> exludeMutexTemplate(List<ProtectObject> poList) {
        HashSet<Integer> mutexTemplateSet = new HashSet<Integer>();
        for (ProtectObject po : poList) {
            List<ProtectObject> tmpPolist = this.getProtectObjectBymoUuid(po.getMoUuid());
            if (tmpPolist.isEmpty()) continue;
            for (ProtectObject tpo : tmpPolist) {
                ProtectGroup pg = tpo.getProtectGroup();
                int templateType = pg.getTemplate().getType();
                List<Integer> mutexTemplateList = mutexTemplateMap.get(templateType);
                if (VerifyUtil.isEmpty(mutexTemplateList)) {
                    List<Integer> allowTypes = Arrays.asList(16);
                    if (allowTypes.contains(templateType)) continue;
                    mutexTemplateSet.add(templateType);
                    continue;
                }
                mutexTemplateSet.addAll(mutexTemplateList);
            }
        }
        return mutexTemplateSet;
    }

    private List<ProtectObject> getProtectObjectBymoUuid(String moUuid) {
        if (VerifyUtil.isEmpty((String)moUuid)) {
            logger.error((Object)"getting databaseinstance is error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        Session session = null;
        List result = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"moUuid", (Object)moUuid));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            crit.addOrder(Order.asc((String)"name"));
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject by host.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    public boolean validateDbAuthInfo(int applicationType, ProtectObject po) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        provider.updateProtectObjectProps(po, po.getProps());
        return this.testProtectObject(applicationType, po);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectLocationPath> getScheduleSiteInfo(int poType, String ptUuid, List<ProtectObject> poList) {
        List pathList;
        ProtectGroup protectGroup;
        IPolicyTemplateFilter filter;
        Session session;
        block7: {
            List list;
            IProtectObjectBaseProvider provider = this.getProviderByAppType(poType);
            IBaseDao baseDao = CommonDAOLocator.getBaseDao();
            session = null;
            try {
                session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(PolicyTemplate.class);
                criteria.add((Criterion)Restrictions.eq((String)"ptId", (Object)ptUuid));
                List policyTemplates = criteria.list();
                if (VerifyUtil.isEmpty((Collection)policyTemplates)) {
                    throw new LegoCheckedException(-1L);
                }
                PolicyTemplate pt = (PolicyTemplate)policyTemplates.get(0);
                TemplateFilterManager manager = TemplateFilterManager.getInstance();
                filter = manager.getTemplateFilterByType(pt.getType());
                if (null == filter) {
                    logger.error((Object)("The policyTemplateFilter is null! PtType = " + pt.getType()), 90160758787071L);
                    throw new LegoCheckedException(-1L);
                }
                protectGroup = this.getProtectGroupByPolicytemplate(pt);
                if (null != protectGroup) break block7;
                provider.loadProtectObjectStorageInfo(poList);
                list = filter.getProtectLocationPaths(poList);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return list;
        }
        String protectionPathJson = (String)protectGroup.getProps().get("PROTECTGROUP_PROTECTLOCATIONPATH");
        if (VerifyUtil.isEmpty((String)protectionPathJson)) {
            pathList = filter.getProtectLocationPaths(new ArrayList(protectGroup.getPolist()));
            protectGroup.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject((Object)pathList).toString());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
        } else {
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            JSONArray array = JSONArray.fromObject((Object)protectionPathJson);
            pathList = JSONArray.toCollection((JSONArray)array, ProtectLocationPath.class);
            pathList.stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
                Site protectedSite;
                Site recoverySite = siteService.getSiteById(item.getRecoverySiteId());
                if (!VerifyUtil.isEmpty((Object)recoverySite)) {
                    item.setRecoverySiteName(recoverySite.getName());
                }
                if (!VerifyUtil.isEmpty((Object)(protectedSite = siteService.getSiteById(item.getProtectedSiteId())))) {
                    item.setProtectedSiteName(protectedSite.getName());
                }
            });
        }
        List list = pathList;
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectGroup getProtectGroupByPolicytemplate(PolicyTemplate pt) {
        Session session;
        block2: {
            ProtectGroup protectGroup;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(ProtectGroup.class);
                criteria.add((Criterion)Restrictions.eq((String)"template", (Object)pt));
                List protectGroups = criteria.list();
                if (VerifyUtil.isEmpty((Collection)protectGroups)) break block2;
                protectGroup = (ProtectGroup)protectGroups.iterator().next();
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return protectGroup;
        }
        DBOperationUtil.closeSession((Session)session);
        return null;
    }

    static {
        mutexTemplateMap.put(2, Arrays.asList(2));
        mutexTemplateMap.put(1, Arrays.asList(1, 17, 30));
        mutexTemplateMap.put(15, Arrays.asList(15, 1, 16));
        mutexTemplateMap.put(18, Arrays.asList(18, 1, 2, 19, 16, 31, 30));
        mutexTemplateMap.put(23, Arrays.asList(23, 0, 2, 19, 16));
        mutexTemplateMap.put(19, Arrays.asList(18, 23, 1, 2, 19, 16));
        mutexTemplateMap.put(14, Arrays.asList(14, 17));
        mutexTemplateMap.put(17, Arrays.asList(17, 14, 1));
        mutexTemplateMap.put(30, Arrays.asList(1, 31));
        mutexTemplateMap.put(31, Arrays.asList(18, 30, 1));
        mutexTemplateMap.put(32, Arrays.asList(20, 30, 1));
        mutexTemplateMap.put(20, Arrays.asList(32, 30));
        mutexTemplateMap.put(33, Arrays.asList(1, 33));
        mutexTemplateMap.put(39, Arrays.asList(0, 39));
        mutexTemplateMap.put(52, Arrays.asList(0, 52));
        mutexTemplateMap.put(51, Arrays.asList(1, 51));
        priorityTemplateMap.put(1, Arrays.asList(6, 15, 18, 19, 20, 36));
        priorityTemplateMap.put(2, Arrays.asList(18, 19));
        priorityTemplateMap.put(16, Arrays.asList(18, 19, 15));
        priorityTemplateMap.put(0, Arrays.asList(24));
        priorityTemplateMap.put(18, Arrays.asList(26));
        priorityTemplateMap.put(20, Arrays.asList(27));
    }
}

