/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.protection.framework.service.replica.ReplicaBaseServiceImpl;
import com.huawei.ism.drm.protection.framework.service.task.CloneReplicaTask;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.task.CreateMountReplicaPlanTask;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.framework.task.UmountReplicaTask;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

@Service(name="com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService", desc="", interfaceClass=IReplicaService.class)
public class ReplicaServiceImpl
extends ReplicaBaseServiceImpl
implements IReplicaService {
    private static final Log logger = LogFactory.getInstance(ReplicaServiceImpl.class);

    public void mountReplica(User user, String protectGroupId, String replicaId, String mountConfigs) {
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        if (VerifyUtil.isEmpty((Object)mountConfiguration)) {
            logger.error((Object)"the mountConfiguration is null");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroupReplica srcReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        this.verifyReplica(srcReplica);
        srcReplica.addProperty("mountConfigs", mountConfigs);
        String mountHost = mountConfiguration.getHostOrGroupSn();
        if (VerifyUtil.isEmpty((String)mountHost)) {
            logger.error((Object)"mountHost is null");
            throw new LegoCheckedException(1073947393L);
        }
        int replicaType = srcReplica.getType();
        int configTargetReplicaType = mountConfiguration.getTargetReplicaType();
        if (configTargetReplicaType != -1 && 101 != replicaType) {
            if (configTargetReplicaType == 5) {
                String errorMsg = "Clone replica is not supported in the current version";
                logger.error((Object)errorMsg);
                throw new LegoCheckedException(1073947393L, errorMsg);
            }
            CloneReplicaTask task = new CloneReplicaTask(user, srcReplica, true, mountConfiguration);
            MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        } else {
            if (Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(srcReplica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()).equals(srcReplica.getMountStatus())) {
                logger.error((Object)("srcReplica is not valid: " + srcReplica.getId()));
                throw new LegoCheckedException(1073948693L);
            }
            if (srcReplica.isStorageSnapshotReplica() && !Integer.valueOf(2).equals(srcReplica.getGeneration())) {
                logger.error((Object)"not second generation copy");
                long errorCode = 1073948254L;
                throw new LegoCheckedException(errorCode);
            }
            CreateMountReplicaPlanTask task = new CreateMountReplicaPlanTask(srcReplica, mountHost, user, mountConfiguration);
            MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }

    public void unmountReplica(User user, String protectGroupId, String replicaId, boolean deleteReplica) {
        ProtectGroupReplica srcReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        if (!(Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(srcReplica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()).equals(srcReplica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.MOUNT_FAILED.getStatus()).equals(srcReplica.getMountStatus()))) {
            logger.error((Object)"srcReplica is not valid. replicaId:[%s], status:[%s]", new Object[]{srcReplica.getId(), srcReplica.getMountStatus()});
            throw new LegoCheckedException(1073948693L);
        }
        UmountReplicaTask task = new UmountReplicaTask(srcReplica, user, deleteReplica);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }
}

