/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.util;

import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaInfoBean;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckReplicaExtendTools {
    private static final Log logger = LogFactory.getInstance(CheckReplicaExtendTools.class);
    private static final List<Long> SNAPSHOT_ERR_CODES = Arrays.asList(1077937880L, 50337543L, 1077948996L);
    private static final List<Integer> SUPPORT_TEMPLATE_TYPE = Arrays.asList(2, 19, 14, 17, 28, 30, 31, 32);

    public static boolean checkSnapshotCorrect(ProtectGroupReplica replica, boolean isDisableSnap) {
        int ptType = replica.getPg().getTemplate().getType();
        logger.debug((Object)"begin check replica(%s), and Template is %s.", new Object[]{replica.getId(), ptType});
        if (!SUPPORT_TEMPLATE_TYPE.contains(ptType)) {
            return true;
        }
        HashMap<String, CheckReplicaInfoBean> checkedDev = new HashMap<String, CheckReplicaInfoBean>();
        for (ProtectObjectReplica protectObjectReplica : replica.getReplicas()) {
            for (RelicaStorageInfo rsi : protectObjectReplica.getStorageInfos()) {
                if (!(rsi instanceof LocalStorageReplica)) {
                    logger.debug((Object)" %s. is not local storage replica", new Object[]{rsi.getId()});
                    continue;
                }
                LocalStorageReplica lsr = (LocalStorageReplica)LocalStorageReplica.class.cast(rsi);
                String devStr = VerifyUtil.isEmpty((String)lsr.getConsistentGroupId()) ? lsr.getSrcStorageProviderSN() + "#" + lsr.getSrcStorageId() : lsr.getStorageProviderSN() + "#" + lsr.getConsistentGroupId();
                if (checkedDev.containsKey(devStr)) {
                    ((CheckReplicaInfoBean)checkedDev.get(devStr)).getSnapName().add(lsr.getSnapshotName());
                    continue;
                }
                CheckReplicaInfoBean checkInfo = new CheckReplicaInfoBean();
                checkInfo.setProviderSn(lsr.getStorageProviderSN());
                checkInfo.setDevId(lsr.getSrcStorageId());
                checkInfo.setSnapId(lsr.getStorageId());
                checkInfo.getSnapName().add(lsr.getSnapshotName());
                checkInfo.setType(replica.getType());
                if (lsr instanceof HyperVaultReplica) {
                    checkInfo.setPairId(((HyperVaultReplica)HyperVaultReplica.class.cast(lsr)).getPairId());
                }
                checkInfo.setConsistentGroupId(lsr.getConsistentGroupId());
                checkedDev.put(devStr, checkInfo);
            }
        }
        for (Map.Entry entry : checkedDev.entrySet()) {
            CheckReplicaInfoBean checkInfo = (CheckReplicaInfoBean)entry.getValue();
            String logParam = (String)entry.getKey() + "#" + checkInfo.getSnapId();
            try {
                if (!VerifyUtil.isEmpty((String)checkInfo.getConsistentGroupId())) {
                    return CheckReplicaExtendTools.checkConsistentGroup(checkInfo);
                }
                if (CheckReplicaExtendTools.checkSnapshotCorrect(checkInfo, ptType)) continue;
                return false;
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"check Snapshot (%s) error:%s.", new Object[]{logParam, ExceptionUtil.getErrorMessage((Throwable)e)});
                if (!isDisableSnap) {
                    return false;
                }
                if (!SNAPSHOT_ERR_CODES.contains(e.getErrorCode())) continue;
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"check Snapshot (%s) error:%s.", new Object[]{logParam, ExceptionUtil.getErrorMessage((Throwable)e)});
                if (isDisableSnap) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkSnapshotCorrect(CheckReplicaInfoBean checkInfo, int templateType) {
        String sn = checkInfo.getProviderSn();
        String id = checkInfo.getSnapId();
        String srcId = checkInfo.getDevId();
        int type = checkInfo.getType();
        if (CheckReplicaExtendTools.isEmptySnapshotId(id)) {
            logger.warn((Object)"array snapshot id is null or empty. id: %s.", new Object[]{sn + "#" + srcId});
            return false;
        }
        List<Snapshot> items = null;
        List<Lun> luns = null;
        String snapshot = sn + "#" + id;
        if (CheckReplicaExtendTools.isSanSnapshotReplica(templateType)) {
            logger.debug((Object)"snapshot is array snapshot: %s", new Object[]{snapshot});
            if (type == 9 && !VerifyUtil.isEmpty(luns = CheckReplicaExtendTools.getCloneVolume(sn, id))) {
                return true;
            }
            items = CheckReplicaExtendTools.getSanSnapshot(sn, id);
        } else if (templateType == 14) {
            logger.debug((Object)"snapshot is nas snapshot: %s.", new Object[]{snapshot});
            items = CheckReplicaExtendTools.getNasSnapshot(sn, srcId, id);
        } else {
            if (templateType == 17 || templateType == 28) {
                logger.debug((Object)"snapshot is  hypervault:%s. ", new Object[]{snapshot});
                return CheckReplicaExtendTools.checkHyperVaultSnapshot(checkInfo);
            }
            logger.debug((Object)"snapshot is not need to check: %s.", new Object[]{snapshot});
            return true;
        }
        if (VerifyUtil.isEmpty(items)) {
            logger.warn((Object)"snapshot is already not exists. sn: %s, snapshot id: %s.", new Object[]{sn, id});
            return false;
        }
        if (!checkInfo.getSnapName().contains(items.get(0).getName())) {
            logger.warn((Object)"snapshot name was bean changed. sn: %s, snapshot id: %s, saved name: %s, query name: %s.", new Object[]{sn, id, checkInfo.getSnapName(), items.get(0).getName()});
            return false;
        }
        return true;
    }

    private static List<Snapshot> getSanSnapshot(String sn, String id) {
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevId(sn);
        if (null == proxy) {
            logger.warn((Object)"Not found snapshot manager proxy. sn: %s, id: %s.", new Object[]{sn, id});
            throw new LegoCheckedException(1073947395L);
        }
        Snapshot snapshot = new Snapshot();
        snapshot.setSnapshotId(id);
        return proxy.getSnapshot(sn, snapshot);
    }

    private static List<Lun> getCloneVolume(String sn, String volumeName) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunBaseManager manager = proxy.getStorageLunMgrByDevId(sn);
        if (manager == null) {
            logger.warn((Object)"Not found snapshot manager proxy. sn: %s, id: %s.", new Object[]{sn, volumeName});
            throw new LegoCheckedException(1073947395L);
        }
        ArrayList<String> volumeNames = new ArrayList<String>();
        volumeNames.add(volumeName);
        return manager.queryLunsByNames(sn, volumeNames);
    }

    private static List<Snapshot> getNasSnapshot(String sn, String srcFsId, String id) {
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        StorageFileSystemSnapshotManagerProxy storageManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance();
        IStorageFileSystemSnapshotManager proxy = storageManagerProxy.getStorageFileSystemSnapshotManager(sn);
        if (proxy == null) {
            logger.warn((Object)"not found snapshot manager proxy. sn: %s, id: %s.", new Object[]{sn, id});
            throw new LegoCheckedException(1073947395L);
        }
        List temp = proxy.querySnapshot(sn, srcFsId);
        logger.debug((Object)"there are %s snaps under %s # %s.", new Object[]{String.valueOf(temp.size()), sn, srcFsId});
        for (Snapshot snap : temp) {
            if (!id.equals(snap.getId())) continue;
            result.add(snap);
            break;
        }
        return result;
    }

    private static boolean checkHyperVaultSnapshot(CheckReplicaInfoBean checkInfo) {
        String vaultId = checkInfo.getPairId();
        String deviceSn = checkInfo.getProviderSn();
        String copyId = checkInfo.getSnapId();
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(deviceSn);
        if (mgr == null) {
            logger.error((Object)"IStorageHyperVaultManager is null.deviceSn:%s.", new Object[]{deviceSn});
            throw new LegoCheckedException(1073947395L);
        }
        List copies = mgr.queryCopysByHyperVault(deviceSn, vaultId);
        for (HyperVaultCopy copy : copies) {
            if (!copyId.equals(copy.getId())) continue;
            for (String rdSnapName : checkInfo.getSnapName()) {
                if (!rdSnapName.startsWith("RD") && !rdSnapName.equals(copy.getName())) continue;
                return true;
            }
        }
        logger.warn((Object)"not match HyperVaultCopy:%s ## %s", new Object[]{copyId, checkInfo.getSnapName()});
        return false;
    }

    private static boolean checkConsistentGroup(CheckReplicaInfoBean checkInfo) {
        String deviceSn = checkInfo.getProviderSn();
        String consistentGroupId = checkInfo.getConsistentGroupId();
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty((String)consistentGroupId)) {
            logger.warn((Object)"deviceSn or consistentGroupId is null.");
            return false;
        }
        HyperCDPConsistencyGroup consistentGroup = null;
        if (4 == checkInfo.getType()) {
            consistentGroup = CheckReplicaExtendTools.getHyperCDPConsistentGroup(deviceSn, consistentGroupId);
        } else if (3 == checkInfo.getType()) {
            consistentGroup = CheckReplicaExtendTools.getSnapshotConsistentGroup(deviceSn, consistentGroupId);
        }
        if (consistentGroup == null) {
            logger.error((Object)"SnapshotConsistentGroup not exists,consistentGroupId :%s.", new Object[]{checkInfo.getConsistentGroupId()});
            return false;
        }
        return true;
    }

    private static SnapshotConsistentGroup getSnapshotConsistentGroup(String sn, String id) {
        StorageSnapshotGroupManagerProxy proxy = StorageSnapshotGroupManagerProxy.getInstance();
        IStorageSnapshotGroupManager mgr = proxy.getStorageSnapshotGroupMgrByDevId(sn);
        if (mgr == null) {
            logger.warn((Object)"not found snapshot manager proxy. sn: %s, id: %s.", new Object[]{sn, id});
            throw new LegoCheckedException(1073947395L);
        }
        return mgr.query(sn, id);
    }

    private static HyperCDPConsistencyGroup getHyperCDPConsistentGroup(String sn, String id) {
        StorageHyperCDPGroupManagerProxy proxy = StorageHyperCDPGroupManagerProxy.getInstance();
        IStorageHyperCDPGroupManager mgr = proxy.getStorageHyperCDPGroupMgrByDevId(sn);
        if (mgr == null) {
            logger.warn((Object)"not found snapshot manager proxy. sn: %s , id: %s.", new Object[]{sn, id});
            throw new LegoCheckedException(1073947395L);
        }
        return mgr.query(sn, id);
    }

    private static boolean isSanSnapshotReplica(int templateType) {
        return templateType == 2 || templateType == 19 || PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType);
    }

    private static boolean isEmptySnapshotId(String snapshotId) {
        return snapshotId == null || snapshotId.isEmpty() || snapshotId.equals("NONE");
    }
}

