/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.manager;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.template.manager.AbstractPolicyTemplateManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager", desc="", interfaceClass=IPolicyTemplateManager.class)
public class PolicyTemplateManagerImpl
extends AbstractPolicyTemplateManager
implements IPolicyTemplateManager {
    private static final Log logger = LogFactory.getInstance(PolicyTemplateManagerImpl.class);
    private static final Map<Integer, String[]> SKETCH_FOR_4DC = new HashMap<Integer, String[]>(){
        {
            this.put(35, new String[]{"policy_template_35_cascaded_aa_0.png", "policy_template_35_cascaded_aa_1.png", "policy_template_35_cascaded_aa_2.png"});
            this.put(36, new String[]{"policy_template_36_concurrent_aa_0.png", "policy_template_36_concurrent_aa_1.png", "policy_template_36_concurrent_aa_2.png"});
        }
    };

    public void updateTemplate(PolicyTemplate policyTemplate) {
        if (null == policyTemplate) {
            logger.error((Object)"invalid parameter");
            throw new LegoCheckedException(1073947393L);
        }
        for (Schedule schedule : policyTemplate.getSchedules()) {
            PolicyTemplateTools.getInstance().checkSchedule(schedule);
        }
        try {
            if (policyTemplate.getType() == 11) {
                this.baseDao.getHibernateTemplate().saveOrUpdate((Object)policyTemplate);
            } else {
                this.baseDao.getHibernateTemplate().merge((Object)policyTemplate);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"update PolicyTemplate failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public PolicyTemplate getPtByUuid(String uuid) {
        if (null == uuid) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate dbPolicyTemplate = null;
        try {
            dbPolicyTemplate = (PolicyTemplate)this.baseDao.getHibernateTemplate().get(PolicyTemplate.class, (Serializable)((Object)uuid));
        }
        catch (DataAccessException e) {
            logger.error((Object)("get PolicyTemplate by uuid failed, PolicyTemplate uuid=" + uuid), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        this.fillProps(dbPolicyTemplate);
        this.filterSensitiveParam(dbPolicyTemplate);
        this.resetSketch(uuid, dbPolicyTemplate);
        return dbPolicyTemplate;
    }

    private void fillProps(PolicyTemplate dbPolicyTemplate) {
        if (dbPolicyTemplate == null) {
            logger.debug((Object)"dbPolicyTemplate is null,not fillProps.");
            return;
        }
        Map props = dbPolicyTemplate.getProps();
        String prStr = (String)props.get("protectionRelation");
        if (!VerifyUtil.isEmpty((String)prStr)) {
            if (dbPolicyTemplate.getType() == 28) {
                List<ProtectionRelation> protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList(prStr);
                props.put("protectionRelation", ProtectionRelationJsonConverter.toJsonStr(protectionRelations, false));
            } else {
                ProtectionRelation protectionRelation = ProtectionRelationJsonConverter.toProtectionRelation(prStr);
                props.put("protectionRelation", ProtectionRelationJsonConverter.toJsonStr(protectionRelation, false));
            }
        }
    }

    private void resetSketch(String uuid, PolicyTemplate dbPolicyTemplate) {
        List siteInfoList;
        Optional<SiteInfo> hyperOptional;
        String siteInfoListStr;
        List valueList;
        if (dbPolicyTemplate == null) {
            logger.debug((Object)"dbPolicyTemplate is null,not resetSketch.");
            return;
        }
        if ((dbPolicyTemplate.getType() == 35 || dbPolicyTemplate.getType() == 36) && !VerifyUtil.isEmpty((Collection)(valueList = CommonDAOLocator.getMoDao().executeNativeSql("select p.PROPVALUE from ti_policytemplate t left join ti_protectgroup g  on g.PTID = t.PTID left join ti_protectgroup_prop p on p.PGID = g.PGID where t.PTID = ?  and p.PROPNAME = 'PROP_KEY_SITE_INFO'", new Object[]{uuid}))) && null != (siteInfoListStr = (String)valueList.stream().findFirst().orElse(null)) && (hyperOptional = (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).stream().filter(siteInfo -> siteInfo.getSiteIdSet().size() >= 2).findFirst()).isPresent()) {
            SiteInfo hyperSiteInfo = hyperOptional.get();
            int index = siteInfoList.indexOf(hyperSiteInfo);
            dbPolicyTemplate.setSketch(SKETCH_FOR_4DC.get(dbPolicyTemplate.getType())[index]);
        }
    }
}

