/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.service;

import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public class PolicyTemplateFilterCallable
implements Callable<PolicyTemplate> {
    private static final Log logger = LogFactory.getInstance(PolicyTemplateFilterCallable.class);
    private static final TemplateFilterManager MANAGER = TemplateFilterManager.getInstance();
    private static final List<Integer> NEED_MODIFY_TEMPLATE = Arrays.asList(17, 28, 3, 5);
    private PolicyTemplate template;
    private List<ProtectObject> poList;
    private CountDownLatch countDownLatch;

    public PolicyTemplateFilterCallable(List<ProtectObject> poList, PolicyTemplate template, CountDownLatch latch) {
        this.template = template;
        this.poList = poList;
        this.countDownLatch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyTemplate call() {
        long beginTime = Calendar.getInstance().getTimeInMillis();
        try {
            IPolicyTemplateFilter filter = MANAGER.getTemplateFilterByType(this.template.getType());
            if (null == filter) {
                PolicyTemplate policyTemplate = null;
                return policyTemplate;
            }
            if (NEED_MODIFY_TEMPLATE.contains(this.template.getType())) {
                filter.isMatch(this.poList, this.template);
            } else {
                filter.isMatch(this.poList);
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"policy template is not available.", (Throwable)ex, 90160758787071L);
            this.template.setAvailable(false);
            this.template.setErrorCode(ex.getErrorCode());
            this.template.setParameters(ex.getParameters());
        }
        catch (Exception e) {
            logger.error((Object)"getAvailablePolicyTemplate isMatch throw error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.template.setAvailable(false);
            this.template.setErrorCode(1073948191L);
        }
        finally {
            logger.info((Object)("policy template filter time , policy type :" + this.template.getType() + ";time: " + (Calendar.getInstance().getTimeInMillis() - beginTime)), 90160758786988L);
            this.countDownLatch.countDown();
        }
        return this.template;
    }
}

