/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.template.service.PolicyTemplateFilterCallable;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateBaseTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class PolicyTemplateTools
extends PolicyTemplateBaseTools {
    private static final Log logger = LogFactory.getInstance(PolicyTemplateBaseTools.class);
    private static PolicyTemplateTools instance = new PolicyTemplateTools();

    public static PolicyTemplateTools getInstance() {
        return instance;
    }

    public List<PolicyTemplate> filterAvaiableTemplate(List<ProtectObject> poList, List<PolicyTemplate> policyTemplates) {
        CountDownLatch latch = new CountDownLatch(policyTemplates.size());
        ArrayList<Future> futures = new ArrayList<Future>();
        for (PolicyTemplate policyTemplate : policyTemplates) {
            Future future = FixedProtectionThreadPool.submit((FixedProtectionThreadPool.FixedProtectionThreadPoolEnum)FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.POLICY_TEMPLATE_EXECUTOR, (Callable)new PolicyTemplateFilterCallable(poList, policyTemplate, latch));
            futures.add(future);
        }
        ArrayList<PolicyTemplate> result = new ArrayList<PolicyTemplate>();
        try {
            latch.await();
            for (Future future : futures) {
                result.add((PolicyTemplate)future.get());
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error((Object)"Get policy template error,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
        }
        return result;
    }

    public boolean checkScheduleName(String scheduleName) {
        return !VerifyUtil.isEmpty((String)scheduleName) && scheduleName.contains(";") && scheduleName.split(";").length == 2;
    }

    public String generateSnapshotName(String lunId) {
        String tmpName = new StringBuffer().append("RD").append("-").append(lunId).append("-").append(System.currentTimeMillis()).toString();
        return tmpName.length() > 31 ? tmpName.substring(0, 31) : tmpName;
    }
}

