/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HyperMetroRecoveryProcessChecker
implements IRecoveryProcessChecker {
    private static Log logger = LogFactory.getInstance(HyperMetroRecoveryProcessChecker.class);
    private static HyperMetroRecoveryProcessChecker rpChecker = new HyperMetroRecoveryProcessChecker();
    private static final List<Integer> ASYNC_HYPERMETRO_TEMPLATE = new ArrayList<Integer>();
    private static final List<Integer> HYPERMETRO_ASYNC_TEMPLATE = new ArrayList<Integer>();
    private static final List<Integer> ARRAY_4DC_TEMPLATE = Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_4DC_ASYNC_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_4DC_ASYNC_ASYNC.getValue());
    private static final List<Integer> AVAILABLE_RUNNING_STATUS = new ArrayList<Integer>();
    private static final ThreadLocal<CheckParam> CHECK_PARAM;

    public String getDeviceId() {
        logger.debug((Object)"getDeviceId");
        return CHECK_PARAM.get().getDeviceId();
    }

    public void setDeviceId(String deviceId) {
        logger.debug((Object)"setDeviceId");
        CHECK_PARAM.get().setDeviceId(deviceId);
    }

    public DrmEnumDefine.RecoveryPlanExecuteTypeE getExProcType() {
        return CHECK_PARAM.get().getExProcType();
    }

    public void setExProcType(DrmEnumDefine.RecoveryPlanExecuteTypeE exProcType) {
        CHECK_PARAM.get().setExProcType(exProcType);
    }

    public static HyperMetroRecoveryProcessChecker getInstance() {
        logger.debug((Object)"getInstance");
        return rpChecker;
    }

    public String getName() {
        logger.debug((Object)"getName");
        return this.getClass().getName();
    }

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        this.setExProcType(procType);
        this.checkContext(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        this.checkRecoveryPlan(recoveryPlan);
        Iterator<ProtectGroup> iterator = recoveryPlan.getProtectGroups().iterator();
        this.checkProtectGroup(iterator);
        ProtectGroup pg = iterator.next();
        int templateType = pg.getTemplate().getType();
        HashSet<Integer> checkProcType4DCSet = new HashSet<Integer>(Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()));
        if (checkProcType4DCSet.contains(procType.getValue()) && ARRAY_4DC_TEMPLATE.contains(templateType)) {
            this.checkHyperMetroFor4DC(context, procType, pg, templateType);
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == procType.getValue() && PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SNAPSHOT.getValue() == templateType) {
            String replicaId = (String)recoveryPlan.getGlobalSettings().get("REPLICA_ID");
            String deviceID = this.getDeviceSnOfReplica(recoveryPlan, replicaId);
            this.setDeviceId(deviceID);
            Set poList = context.getRecoveryProtectObjects();
            if (!this.checkHyperMetroAvailable(context, RecoveryProcessUtil.getAllWwn(poList))) {
                logger.error((Object)("the hypermetro pair status or director is not ok!templateType:" + templateType));
                throw new LegoCheckedException(1073948754L);
            }
        } else if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == procType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == procType.getValue()) && HyperMetroRecoveryProcessChecker.isHyperMetroReplicationMode(templateType)) {
            this.setDeviceId(this.getRecoveryTaskFromContext(context).getSrcDeviceId());
            Set poList = context.getRecoveryProtectObjects();
            Set<String> wwnSet = RecoveryProcessUtil.getAllWwn(poList);
            this.checkHyperMetro(pg, context, wwnSet, templateType, false);
        } else if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == procType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == procType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == procType.getValue()) && HyperMetroRecoveryProcessChecker.isReplicationHyperMetroMode(templateType)) {
            this.setDeviceId(this.getRecoveryTaskFromContext(context).getTgtDevcieId());
            Set<String> wwnSet = RecoveryProcessUtil.getAllSecondaryLunWwn(pg);
            this.checkHyperMetro(pg, context, wwnSet, templateType, false);
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == procType.getValue() && PolicyTemplateType.PolicyTemplateE.ARRAY_HYPERMETRO_VAULT.getValue() == templateType) {
            List<ProtectionRelation> protectionRelationList = this.getProtectionRelationFromTemple(pg.getTemplate());
            this.setDeviceId(((ProtectionRelation)CommonUtil.getFirstElement(protectionRelationList)).getSrcResourceProviderSn());
            HashSet<String> wwnSet = new HashSet<String>();
            for (ProtectionRelation relation : protectionRelationList) {
                wwnSet.add(relation.getSrcResourceId());
            }
            this.checkHyperMetro(pg, context, wwnSet, templateType, false);
            this.checkHyperVault(wwnSet);
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == procType.getValue() && PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_HYPERMETRO_VAULT.getValue() == templateType) {
            ProtectGroupReplica replica = context.getProtectGroupReplica();
            if (VerifyUtil.isEmpty((Object)replica)) {
                logger.error((Object)"the SAN replica is empty!");
                throw new LegoCheckedException(1073947394L);
            }
            this.setDeviceId(replica.getProductArray());
            Set poList = context.getRecoveryProtectObjects();
            if (!this.checkHyperMetroAvailable(context, RecoveryProcessUtil.getAllWwn(poList))) {
                logger.error((Object)("the SAN hypermetro pair status or director is not ok!templateType:" + templateType));
                throw new LegoCheckedException(1073948754L);
            }
        }
    }

    private void checkHyperMetroFor4DC(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, ProtectGroup pg, int templateType) {
        List siteInfoList;
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (null == siteInfoListStr) {
            logger.error((Object)("4DC no site info:" + pg.getName()));
            return;
        }
        Set replicaList = pg.getReplicaList();
        ProtectGroupReplica curRecoveryReplica = (ProtectGroupReplica)replicaList.stream().findFirst().get();
        for (ProtectGroupReplica replica2 : replicaList) {
            if (!replica2.getRecoverySite().equals(context.getDisasterSiteId())) continue;
            curRecoveryReplica = replica2;
            break;
        }
        if (((SiteInfo)(siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).get(0)).getSiteIdSet().size() >= 2) {
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != procType.getValue()) {
                if (!((SiteInfo)siteInfoList.get(0)).getDevSnSet().contains(curRecoveryReplica.getProductArray())) {
                    curRecoveryReplica = replicaList.stream().filter(replica -> ((SiteInfo)siteInfoList.get(0)).getDevSnSet().contains(replica.getProductArray())).findFirst().orElse(curRecoveryReplica);
                }
                this.setDeviceId(curRecoveryReplica.getProductArray());
                Set poList = context.getRecoveryProtectObjects();
                Set<String> wwnSet = RecoveryProcessUtil.getAllWwn(poList);
                this.checkHyperMetro(pg, context, wwnSet, templateType, false);
            }
        } else {
            SiteInfo disSiteInfo = siteInfoList.stream().filter(siteInfo -> siteInfo.getSiteIdSet().contains(context.getDisasterSiteId())).findFirst().get();
            Set siteIdSet = disSiteInfo.getSiteIdSet();
            if (null != siteIdSet && siteIdSet.size() >= 2) {
                Set<String> wwnSet = RecoveryProcessUtil.getSecondaryLunWwn(pg, siteIdSet);
                this.setDeviceId(curRecoveryReplica.getRecoveryArray());
                this.checkHyperMetro(pg, context, wwnSet, templateType, false);
            }
        }
    }

    private void checkHyperVault(Set<String> wwnSet) {
        List vaultList = this.getHyperVaultService(this.getDeviceId()).queryHyperVaultListByResourceIds(this.getDeviceId(), new ArrayList<String>(wwnSet));
        if (VerifyUtil.isEmpty((Collection)vaultList) || vaultList.size() != wwnSet.size()) {
            logger.error((Object)("checkHyperVault vaultList is empty,or size not equal resource size :" + wwnSet));
            throw new LegoCheckedException(1073948239L);
        }
        String normalStateStr = String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue());
        for (HyperVault vault : vaultList) {
            String healthStateStr = vault.getHealthState();
            if (normalStateStr.equals(healthStateStr)) continue;
            logger.error((Object)("the health status is not normal! healthStatus:" + healthStateStr));
            throw new LegoCheckedException(1073948239L);
        }
    }

    private IStorageHyperVaultManager getHyperVaultService(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return service;
    }

    private List<ProtectionRelation> getProtectionRelationFromTemple(PolicyTemplate template) {
        String prStr = (String)template.getProps().get("protectionRelation");
        if (VerifyUtil.isEmpty((String)prStr)) {
            logger.error((Object)("getProtectionRelationFromTemple protectionRelation is null:" + template.getUuid()));
            throw new LegoCheckedException(1073947393L);
        }
        List<ProtectionRelation> protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList(prStr);
        if (VerifyUtil.isEmpty(protectionRelations)) {
            logger.error((Object)("getProtectionRelationFromTemple protectionRelations is empty:" + prStr));
            throw new LegoCheckedException(1073947393L);
        }
        return protectionRelations;
    }

    private void checkHyperMetro(ProtectGroup pg, RecoveryProcessorContext context, Set<String> wwnSet, int templateType, boolean checkVstorePair) {
        boolean checkResult;
        if (this.isProtectGroupUseNasFileSystem(pg)) {
            if (PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue() == templateType) {
                wwnSet = this.getWwnFromContext(context);
            }
            checkResult = this.checkVstoreHyperMetroAvailable(context, wwnSet, checkVstorePair);
        } else {
            checkResult = this.checkHyperMetroAvailable(context, wwnSet);
        }
        if (!checkResult) {
            logger.error((Object)("the hypermetro pair status or director is not ok!templateType:" + templateType));
            throw new LegoCheckedException(1073948754L);
        }
    }

    public static boolean isHyperMetroReplicationMode(int templateType) {
        return Arrays.asList(18, 23, 26, 31).contains(templateType);
    }

    public static boolean isReplicationHyperMetroMode(int templateType) {
        return Arrays.asList(20, 24, 27, 32).contains(templateType);
    }

    private RecoveryTask getRecoveryTaskFromContext(RecoveryProcessorContext context) {
        Collection<Object> recoveryTasks = RecoveryTaskUtil.getRootRecoveryTasks((Collection)((Collection)context.getAttribute("recoveryTasks")));
        Iterator<RecoveryTask> taskIterator = this.getRecoveryTask(recoveryTasks = this.getRecoveryTaskWhichIsNotStandy(recoveryTasks));
        if (!taskIterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        return taskIterator.next();
    }

    private Collection<RecoveryTask> getRecoveryTaskWhichIsNotStandy(Collection<RecoveryTask> recoveryTasks) {
        HashSet<RecoveryTask> results = new HashSet<RecoveryTask>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map params = recoveryTask.getParams();
            if (params == null) {
                results.add(recoveryTask);
                continue;
            }
            Object standby = params.get("standby");
            if (standby == null) continue;
            if (Boolean.FALSE.equals(standby)) {
                results.add(recoveryTask);
                continue;
            }
            results.addAll(this.getRecoveryTaskWhichIsNotStandy(recoveryTask.getParallelTasks()));
        }
        return results;
    }

    private void checkProtectGroup(Iterator<ProtectGroup> iterator) {
        if (!iterator.hasNext()) {
            logger.error((Object)"iterator is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkContext(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Iterator<RecoveryTask> getRecoveryTask(Collection<RecoveryTask> recoveryTasks) {
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            logger.error((Object)"recoveryTasks is empty");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator<RecoveryTask> taskIterator = recoveryTasks.iterator();
        if (!taskIterator.hasNext()) {
            logger.error((Object)"taskIterator is empty");
            throw new LegoCheckedException(1073947393L);
        }
        return taskIterator;
    }

    private boolean checkVstoreHyperMetroAvailable(RecoveryProcessorContext context, Set<String> wwnSet, boolean checkVstorePair) {
        List pairList = null;
        ArrayList<String> wwnList = new ArrayList<String>(wwnSet);
        VstoreHyperMetroPair vstoreHyperMetroPair = null;
        String vstoreId = null;
        try {
            DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
            if (null == drResource) {
                logger.error((Object)("DrResource is null, sn=" + this.getDeviceId()));
                return false;
            }
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
            if (null == site) {
                logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
                return false;
            }
            StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
            pairList = router.getHyperMetroPairsByFileSystemIds(site.getServerUuid(), this.getDeviceId(), wwnList, null, true);
            if (VerifyUtil.isEmpty((Collection)pairList)) {
                logger.error((Object)"The hypermetro pairList is empty.");
                return false;
            }
            String vstorePairId = ((HyperMetroPair)pairList.iterator().next()).getVstorePairId();
            vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(this.getDeviceId(), vstorePairId);
            if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
                logger.error((Object)"The vstoreHyperMetroPair does not exist.");
                return false;
            }
            if (!checkVstorePair) {
                Integer activeOrPassive = NumberUtil.convertToInteger((Object)vstoreHyperMetroPair.getActiveOrPassive());
                int pass = XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue();
                if (!this.isHyperMetroNormal(vstoreHyperMetroPair, pairList) && activeOrPassive.equals(pass)) {
                    logger.error((Object)("check vstoreHyperMetroPair status error and this devsn is not active:" + vstoreHyperMetroPair.getHealthStatus()));
                    return false;
                }
            } else if (!this.checkVstorePairHealthStatus(vstoreHyperMetroPair)) {
                logger.error((Object)("check vstoreHyperMetroPair status error:" + vstoreHyperMetroPair.getHealthStatus()));
                return false;
            }
            if (VerifyUtil.isEmpty((String)(vstoreId = vstoreHyperMetroPair.getLocalVstoreId()))) {
                logger.error((Object)("vstoreId is Empty" + vstoreId));
                throw new LegoCheckedException(1073947393L);
            }
            if (!this.checkNasHyperPair(this.getDeviceId(), vstoreId, pairList)) {
                logger.error((Object)("vstoreHyperMetroPair status is not right:" + vstoreHyperMetroPair.getHealthStatus()));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + wwnSet + ",deviceId:" + this.getDeviceId()), (Throwable)e);
            return false;
        }
        this.updateContext(context, pairList, wwnList, vstoreHyperMetroPair, vstoreId);
        return true;
    }

    private void updateContext(RecoveryProcessorContext context, List<HyperMetroPair> pairList, List<String> wwnList, VstoreHyperMetroPair vstoreHyperMetroPair, String vstoreId) {
        HashMap<String, Boolean> pairIdMap = new HashMap<String, Boolean>();
        for (HyperMetroPair hyperMetroPair : pairList) {
            pairIdMap.put(hyperMetroPair.getId(), false);
        }
        context.setAttribute("hyperMetroDeviceSn", (Object)this.getDeviceId());
        context.setAttribute("wwnList", wwnList);
        context.setAttribute("pairIdMap", pairIdMap);
        context.setAttribute("vstoreHyperMetroPair", (Object)vstoreHyperMetroPair);
        context.setAttribute("pairListInVstorePair", pairList);
        context.setAttribute("hyperMetroVstoreId", (Object)vstoreId);
    }

    private boolean isHyperMetroNormal(VstoreHyperMetroPair vstoreHyperMetroPair, List<HyperMetroPair> hyperMetroPairs) {
        if (!String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(vstoreHyperMetroPair.getHealthStatus())) {
            return false;
        }
        for (HyperMetroPair hyperMetroPair : hyperMetroPairs) {
            if (String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(hyperMetroPair.getHealthState())) continue;
            return false;
        }
        return true;
    }

    private boolean checkHyperMetroAvailable(RecoveryProcessorContext context, Set<String> wwnSet) {
        ArrayList<String> wwnList = new ArrayList<String>(wwnSet);
        List<HyperMetroPair> pairList = this.getHyperMetroPairsByWwns(wwnList);
        return this.checkHyperMetroAvailable(context, wwnList, pairList);
    }

    private boolean checkHyperMetroAvailable(RecoveryProcessorContext context, List<String> wwnList, List<HyperMetroPair> pairList) {
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)("HyperMetroPair List is emtpty." + wwnList));
            return false;
        }
        RecoveryPlan plan = context.getRecoveryPlan();
        Set protectGroups = plan.getProtectGroups();
        if (protectGroups == null || protectGroups.isEmpty()) {
            return false;
        }
        ProtectGroup protectGroup = (ProtectGroup)new ArrayList(protectGroups).get(0);
        int templateType = protectGroup.getTemplate().getType();
        List<Integer> ringTemplateTypes = Arrays.asList(27, 26);
        if (!ringTemplateTypes.contains(templateType)) {
            return this.checkHyperMetroAvailable(context, wwnList, pairList, 1);
        }
        Set protectObjectList = protectGroup.getPolist();
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            for (ProtectObjectReplica protectObjectReplica : replica.getReplicas()) {
                ProtectObject po = this.getProtectObjectByPoId(protectObjectList, protectObjectReplica.getPoId());
                if (po == null) {
                    logger.error((Object)("not found protect object for [poid, replicaid]: " + Arrays.asList(protectObjectReplica.getPoId(), protectObjectReplica.getId())));
                    return false;
                }
                List<String> relatedWwns = this.getTargetLunWwnOfStorageResource(protectGroup, protectObjectReplica);
                List<HyperMetroPair> relatedPairs = this.getHyperMetroPairByWwn(pairList, relatedWwns);
                if (relatedPairs.isEmpty()) {
                    relatedWwns = this.getSourceLunWwnOfStorageResource(protectObjectReplica);
                    relatedPairs = this.getHyperMetroPairByWwn(pairList, relatedWwns);
                }
                if (relatedPairs.isEmpty()) {
                    logger.error((Object)("not found hyper metro pairs for po " + po.getName()));
                    return false;
                }
                int drRingLimits = this.getDRRingLimits(po);
                if (this.checkHyperMetroAvailable(context, relatedWwns, relatedPairs, drRingLimits)) continue;
                logger.error((Object)("check hyper metro available for po failed: " + po.getName()));
                return false;
            }
        }
        return true;
    }

    private ProtectObject getProtectObjectByPoId(Collection<ProtectObject> protectObjects, String poId) {
        if (protectObjects == null || poId == null) {
            return null;
        }
        for (ProtectObject protectObject : protectObjects) {
            if (protectObject == null || !poId.equals(protectObject.getUuid())) continue;
            return protectObject;
        }
        return null;
    }

    private int getDRRingLimits(ProtectObject protectObject) {
        String limitsKey;
        if (protectObject == null) {
            return 0;
        }
        Map props = protectObject.getProps();
        String drRingLimits = (String)props.get(limitsKey = "DrRing.Limits");
        drRingLimits = drRingLimits != null ? drRingLimits : "1";
        return NumberUtil.convertToInteger((Object)drRingLimits, (int)0);
    }

    private List<String> getTargetLunWwnOfStorageResource(ProtectGroup protectGroup, ProtectObjectReplica replica) {
        if (protectGroup == null || replica == null) {
            return Collections.emptyList();
        }
        HashSet<ProtectObjectReplica> replicas = new HashSet<ProtectObjectReplica>(Arrays.asList(replica));
        List relations = protectGroup.getReplicationRelationBos(replicas);
        if (relations == null || relations.isEmpty()) {
            return Collections.emptyList();
        }
        String deviceSn = null;
        HashSet resourceIds = new HashSet();
        for (ReplicationRelationBo relation : relations) {
            deviceSn = relation.getTgtDeviceSn();
            resourceIds.addAll(relation.getTgtLuns().values());
        }
        if (deviceSn == null) {
            return Collections.emptyList();
        }
        List targetLuns = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResources(deviceSn, new ArrayList(resourceIds), Lun.class);
        HashSet<String> allWwn = new HashSet<String>();
        if (!VerifyUtil.isEmpty((Collection)targetLuns)) {
            for (Lun lun : targetLuns) {
                allWwn.add(lun.getWwn());
            }
        }
        return new ArrayList<String>(allWwn);
    }

    private List<String> getSourceLunWwnOfStorageResource(ProtectObjectReplica replica) {
        if (replica == null) {
            return Collections.emptyList();
        }
        Set storages = replica.getStorageInfos();
        if (storages == null) {
            return Collections.emptyList();
        }
        HashSet<String> allWwn = new HashSet<String>();
        for (RelicaStorageInfo storage : storages) {
            allWwn.add(storage.getProtectObjectStorageWwn());
        }
        return new ArrayList<String>(allWwn);
    }

    private List<HyperMetroPair> getHyperMetroPairByWwn(List<HyperMetroPair> pairList, List<String> wwns) {
        ArrayList<HyperMetroPair> results = new ArrayList<HyperMetroPair>();
        if (pairList == null || wwns == null) {
            return results;
        }
        for (HyperMetroPair pair : pairList) {
            if (!wwns.contains(pair.getResourceWwn())) continue;
            results.add(pair);
        }
        return results;
    }

    private List<HyperMetroPair> getHyperMetroPairsByWwns(List<String> wwnList) {
        List pairList;
        try {
            DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
            if (null == drResource) {
                logger.error((Object)("DrResource is null, sn=" + this.getDeviceId()));
                List<HyperMetroPair> pairList2 = null;
                return pairList2;
            }
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
            if (null == site) {
                logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
                List<HyperMetroPair> pairList3 = null;
                return pairList3;
            }
            pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(site.getServerUuid(), wwnList, null, this.getDeviceId(), true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + wwnList + ",deviceId:" + this.getDeviceId()), (Throwable)e);
            pairList = null;
        }
        return pairList;
    }

    private boolean checkHyperMetroAvailable(RecoveryProcessorContext context, List<String> wwnList, List<HyperMetroPair> pairList, int limit) {
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)("HyperMetroPair List is emtpty." + wwnList));
            return false;
        }
        HashMap<String, Boolean> pairIdMap = new HashMap<String, Boolean>();
        boolean isConsistentGroup = false;
        HashSet<String> cgIds = new HashSet<String>();
        for (HyperMetroPair pair : pairList) {
            if (!VerifyUtil.isEmpty((String)pair.getCgId()) && !"--".equals(pair.getCgId())) {
                logger.info((Object)("Group: deviceId:" + this.getDeviceId() + " cgId:" + pair.getCgId() + " inCg:" + pair.getInCg() + " pairId:" + pair.getId() + " isPrimary:" + pair.getIsPrimary() + " syncDirection:" + pair.getSyncDirection()));
                isConsistentGroup = true;
                pairIdMap.put(pair.getCgId(), isConsistentGroup);
                cgIds.add(pair.getCgId());
                continue;
            }
            logger.info((Object)("Pair: deviceId:" + this.getDeviceId() + " cgId:" + pair.getCgId() + " inCg:" + pair.getInCg() + " pairId:" + pair.getId() + " isPrimary:" + pair.getIsPrimary() + " syncDirection:" + pair.getSyncDirection()));
            isConsistentGroup = false;
            pairIdMap.put(pair.getId(), isConsistentGroup);
        }
        if (pairIdMap.size() <= 0) {
            logger.error((Object)("HyperMetro has none pair or consistent group! all wwns:" + wwnList + ",deviceId:" + this.getDeviceId()));
            return false;
        }
        if (pairIdMap.size() > limit) {
            logger.error((Object)("HyperMetro has more than one pair or consistent group! all wwns:" + wwnList + ",deviceId:" + this.getDeviceId()), 1073948246L);
            return false;
        }
        if (isConsistentGroup ? !this.isConsistentGroupAvailable(context, cgIds) : !this.isPairAvailable(context, pairList)) {
            return false;
        }
        context.setAttribute("hyperMetroDeviceSn", (Object)this.getDeviceId());
        context.setAttribute("pairIdMap", this.combinaPairIdMap(context, pairIdMap));
        context.setAttribute("pairList", this.combinaPairList(context, pairList));
        context.setAttribute("wwnList", this.combinaWWWList(context, wwnList));
        return true;
    }

    private Map<String, Boolean> combinaPairIdMap(RecoveryProcessorContext context, Map<String, Boolean> pairIdMap) {
        HashMap<String, Boolean> newIdMap = new HashMap<String, Boolean>();
        Object obj = context.getAttribute("pairIdMap");
        if (obj == null || !(obj instanceof Map)) {
            newIdMap.putAll(pairIdMap);
            return newIdMap;
        }
        newIdMap.putAll((Map)obj);
        newIdMap.putAll(pairIdMap);
        return newIdMap;
    }

    private List<HyperMetroPair> combinaPairList(RecoveryProcessorContext context, List<HyperMetroPair> addList) {
        ArrayList<HyperMetroPair> pairList = new ArrayList<HyperMetroPair>();
        Object obj = context.getAttribute("pairList");
        if (obj == null || !(obj instanceof List)) {
            pairList.addAll(addList);
            return pairList;
        }
        pairList.addAll((List)obj);
        pairList.addAll(addList);
        return pairList;
    }

    private List<String> combinaWWWList(RecoveryProcessorContext context, List<String> addList) {
        ArrayList<String> wwwList = new ArrayList<String>();
        Object obj = context.getAttribute("wwnList");
        if (obj == null || !(obj instanceof List)) {
            wwwList.addAll(addList);
            return wwwList;
        }
        wwwList.addAll((List)obj);
        wwwList.addAll(addList);
        return wwwList;
    }

    private boolean isPairAvailable(RecoveryProcessorContext context, List<HyperMetroPair> pairList) {
        ArrayList<HyperMetroPair> hyperMetroPairs = new ArrayList<HyperMetroPair>();
        for (HyperMetroPair pair : pairList) {
            Integer syncDirection = pair.getSyncDirection();
            String runningStatus = pair.getRunningState();
            Integer status = null;
            try {
                status = Integer.valueOf(runningStatus);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("The pair running status is not ok! pair running status[" + runningStatus + "]."), 1073948223L);
                return false;
            }
            if (this.checkHyperPairStatus(context, syncDirection, status, pair.getId(), pair.getIsPrimary())) {
                hyperMetroPairs.add(pair);
                continue;
            }
            logger.error((Object)("The pair running status is not ok! pair running status[" + status + "]."), 1073948754L);
            return false;
        }
        context.setAttribute("hyperMetroPairs", hyperMetroPairs);
        return true;
    }

    private boolean isConsistentGroupAvailable(RecoveryProcessorContext context, Collection<String> cgIds) {
        for (String cgId : cgIds) {
            if (this.isConsistentGroupAvailable(context, cgId)) continue;
            return false;
        }
        return true;
    }

    private boolean isConsistentGroupAvailable(RecoveryProcessorContext context, String cgId) {
        if (VerifyUtil.isEmpty((String)cgId) || "--".equals(cgId)) {
            return false;
        }
        HyperMetroConsistentGroup group = StorageResourceServiceRouter.getInstance().getHyperMetroConsistentGroup(this.getDeviceId(), cgId, true);
        Integer syncDirection = group.getSyncDirection();
        String runningStatus = group.getRunningState();
        Integer status = null;
        try {
            status = Integer.valueOf(runningStatus);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("The consistent group running status is not ok! running status[" + runningStatus + "]."), 1073948223L);
            return false;
        }
        if (this.checkHyperPairStatus(context, syncDirection, status, cgId, DrmEnumDefine.RoleType.PRIORITY.getValue() == group.getPriorityStationType())) {
            this.addHyperMetroConsistentGroupToContext(context, group);
            return true;
        }
        logger.error((Object)("The consistent group running status is not ok! running status[" + status + "]."), 1073948754L);
        return false;
    }

    private boolean checkHyperPairStatus(RecoveryProcessorContext context, Integer syncDirection, Integer status, String pairOrCgId, Boolean isPrimary) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        int templateType = pg.getTemplate().getType();
        if (HyperMetroRecoveryProcessChecker.isHyperMetroReplicationMode(templateType) && null != this.getExProcType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getExProcType().getValue()) {
            if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == status.intValue() || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == status.intValue() || AVAILABLE_RUNNING_STATUS.contains(status) && XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_LOCAL_TO_REMOTE.getValue() != syncDirection.intValue()) {
                logger.error((Object)"reprotect HyperMetroReplication pg:%s,hyper pair status can not be normal", new Object[]{pg.getName()});
                Map info = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageAddressInfo(this.getDeviceId());
                String devIp = this.getDeviceId();
                if (info.containsKey("linkIp")) {
                    devIp = String.valueOf(info.get("linkIp"));
                }
                throw new LegoCheckedException(1073948808L, new String[]{devIp, pairOrCgId, Boolean.TRUE.equals(isPrimary) ? "NONE_PRIORITY" : "PRIORITY"});
            }
            return true;
        }
        return XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == status.intValue() || AVAILABLE_RUNNING_STATUS.contains(status) && XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_LOCAL_TO_REMOTE.getValue() == syncDirection.intValue();
    }

    private void addHyperMetroConsistentGroupToContext(RecoveryProcessorContext context, HyperMetroConsistentGroup group) {
        String name = "hyperMetroConsistentGroup";
        Object data = context.getAttribute(name);
        if (data == null) {
            context.setAttribute(name, (Object)group);
        } else {
            HashSet<HyperMetroConsistentGroup> list;
            if (data instanceof HashSet) {
                list = (HashSet<HyperMetroConsistentGroup>)data;
            } else {
                list = new HashSet<HyperMetroConsistentGroup>();
                if (data instanceof HyperMetroConsistentGroup) {
                    list.add((HyperMetroConsistentGroup)data);
                }
                context.setAttribute(name, list);
            }
            list.add(group);
        }
    }

    private String getDeviceSnOfReplica(RecoveryPlan recoveryPlan, String replicaId) {
        ProtectGroupReplica pgReplicas = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId((ProtectGroup)recoveryPlan.getProtectGroup(), (String)replicaId);
        if (VerifyUtil.isEmpty((Object)pgReplicas)) {
            logger.error((Object)("The replicas is empty or null! Recovery Plan ID:" + recoveryPlan.getPlanId()), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
        return pgReplicas.getStorageDeviceId();
    }

    private boolean checkNasHyperPair(String devSN, String vstoreId, List<HyperMetroPair> pairList) {
        List pairs;
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        List vstoreNasList = router.getFileSystemByVstore(devSN, vstoreId);
        HashSet<String> vstoreNasIds = new HashSet<String>();
        for (NasFileSystem nasFileSystem : vstoreNasList) {
            vstoreNasIds.add(nasFileSystem.getResourceId());
        }
        for (HyperMetroPair pair : pairList) {
            if (vstoreNasIds.contains(pair.getLocalObjId())) continue;
            logger.error((Object)"nas hyperpair is not all in one vstorepair.", 1073948246L);
            return false;
        }
        if (pairList.size() != vstoreNasList.size() && !VerifyUtil.isEmpty((Collection)(pairs = router.getHyperMetroPairsByVstore(this.getDeviceId(), vstoreId)))) {
            pairList.clear();
            pairList.addAll(pairs);
        }
        return true;
    }

    private boolean checkVstorePairHealthStatus(VstoreHyperMetroPair vstoreHyperMetroPair) {
        int status;
        String healthStatus = vstoreHyperMetroPair.getHealthStatus();
        if (VerifyUtil.isEmpty((String)healthStatus)) {
            logger.error((Object)"The healthStatus is null! ");
            return false;
        }
        try {
            status = Integer.parseInt(healthStatus);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("The pair health status is not ok! healthPair status[" + healthStatus + "]."), 1073948223L);
            return false;
        }
        if (XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue() != status) {
            logger.error((Object)("The pair health status is not ok! pair status[" + status + "]."), 1073948223L);
            return false;
        }
        return true;
    }

    private boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        logger.debug((Object)"enter isProtectGroupUseNasFileSystem ");
        boolean isNas = false;
        if (PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue() == pg.getTemplate().getType() || PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO.getValue() == pg.getTemplate().getType() || PolicyTemplateType.PolicyTemplateE.ARRAY_HYPERMETRO_VAULT.getValue() == pg.getTemplate().getType()) {
            ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)((ProtectObject)pg.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next();
            if (DrmEnumDefine.ResourceTypeE.NAS.getValue() == storageInfo.getResourceType().intValue()) {
                isNas = true;
            }
        }
        return isNas;
    }

    private Set<String> getWwnFromContext(RecoveryProcessorContext context) {
        HashSet<String> set = new HashSet<String>();
        Set recoveryTasks = RecoveryTaskUtil.getRootRecoveryTasks((Collection)((Collection)context.getAttribute("recoveryTasks")));
        for (RecoveryTask task : recoveryTasks) {
            Set ids = task.getSrcStorageIds();
            for (String storageId : ids) {
                if (null == storageId || storageId.split(":").length != 2) continue;
                set.add(storageId.split(":")[1]);
            }
        }
        return set;
    }

    static {
        AVAILABLE_RUNNING_STATUS.add(XveEuumDefineParent.RUNNING_STATUS_E.PAUSE.getValue());
        ASYNC_HYPERMETRO_TEMPLATE.add(PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO.getValue());
        ASYNC_HYPERMETRO_TEMPLATE.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SYNC_HYPER_METRO.getValue());
        ASYNC_HYPERMETRO_TEMPLATE.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_VAULT_HYPERMETRO.getValue());
        HYPERMETRO_ASYNC_TEMPLATE.add(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue());
        HYPERMETRO_ASYNC_TEMPLATE.add(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SYNC_REPLICATION.getValue());
        HYPERMETRO_ASYNC_TEMPLATE.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_HYPERMETRO_VAULT.getValue());
        CHECK_PARAM = new ThreadLocal<CheckParam>(){

            @Override
            protected CheckParam initialValue() {
                return new CheckParam();
            }
        };
    }

    public static class CheckParam {
        private String deviceId;
        private DrmEnumDefine.RecoveryPlanExecuteTypeE exProcType;

        public String getDeviceId() {
            return this.deviceId;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public DrmEnumDefine.RecoveryPlanExecuteTypeE getExProcType() {
            return this.exProcType;
        }

        public void setExProcType(DrmEnumDefine.RecoveryPlanExecuteTypeE exProcType) {
            this.exProcType = exProcType;
        }
    }
}

