/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReplicationPairChecker
implements IRecoveryProcessChecker {
    private static final Log logger = LogFactory.getInstance(ReplicationPairChecker.class);

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (this.skipCheck(context, procType)) {
            return;
        }
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica");
        Set poReplicas = pgReplica.getReplicas();
        String productSn = null;
        String recoverySn = null;
        HashSet<String> srcLunIds = new HashSet<String>();
        HashSet<String> tgtLunIds = new HashSet<String>();
        Site site = (Site)context.getAttribute("productionSite");
        for (ProtectObjectReplica poReplica : poReplicas) {
            Set storageInfos = poReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) {
                logger.error((Object)"ReplicaStorageInfo is not exist.");
                throw new LegoCheckedException(1073948466L);
            }
            for (RelicaStorageInfo info : storageInfos) {
                srcLunIds.add(info.getSrcStorageId());
                tgtLunIds.add(info.getStorageId());
                productSn = info.getSrcStorageProviderSN();
                recoverySn = info.getStorageProviderSN();
            }
        }
        boolean isLocal = site.getSiteType() == 0;
        String deviceSn = isLocal ? productSn : recoverySn;
        HashSet<String> lunIds = isLocal ? srcLunIds : tgtLunIds;
        List<ReplicationPair> pairs = this.getReplicationPairs(srcLunIds, tgtLunIds, deviceSn, lunIds);
        for (ReplicationPair pair : pairs) {
            String pairSrcSn = pair.getSrcDevSN();
            String pairDecSn = pair.getTgtDevSN();
            if (VerifyUtil.isEmpty((String)pairSrcSn) || VerifyUtil.isEmpty((String)pairDecSn)) {
                logger.error((Object)"pairSrcSn or pairDecSn is empty. pairId(%s).", new Object[]{pair.getId()});
                throw new LegoCheckedException(1073948462L);
            }
            if (!pairSrcSn.equals(recoverySn) || !pairDecSn.equals(productSn)) continue;
            logger.error((Object)"Pair(%s) has been switched.productSn: %s, recoverySn: %s", new Object[]{pair.getId(), productSn, recoverySn});
            throw new LegoCheckedException(1073948462L);
        }
    }

    private List<ReplicationPair> getReplicationPairs(Set<String> srcLunIds, Set<String> tgtLunIds, String deviceSn, Set<String> lunIds) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        List<ReplicationPair> pairs = sraProxy.queryReplications(deviceSn, lunIds);
        if (VerifyUtil.isEmpty(pairs = pairs.stream().filter(pair -> pair != null && srcLunIds.contains(pair.getSrcLunId()) && tgtLunIds.contains(pair.getTgtLunId())).collect(Collectors.toList()))) {
            logger.error((Object)"Query pairs failed.");
            throw new LegoCheckedException(1073948462L);
        }
        return pairs;
    }

    private boolean skipCheck(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (context == null || procType == null) {
            logger.error((Object)"Invalid parameters.");
            return true;
        }
        if (!DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)procType)) {
            return true;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        int type = protectGroup.getTemplate().getType();
        if (type == 33 || type == 39) {
            return true;
        }
        LegoConfig.updateInstance();
        String reprotectCheck = LegoConfig.getInstance().getKeyValue("reprotect_check");
        if (!VerifyUtil.isEmpty((String)reprotectCheck) && !Boolean.parseBoolean(reprotectCheck)) {
            logger.debug((Object)"Skip replication check.");
            return true;
        }
        return false;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int priority() {
        return 10;
    }
}

