/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.IBackTaskListener;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.framework.task.UmountReplicaTask;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class UmountPreviousReplicaSubProcessor
extends BaseRecoveryProcessor
implements IBackTaskListener {
    private static final long serialVersionUID = 2706027616955003389L;
    private static final long TIMEOUT = 1800L;
    private static final long INTERVAL = 10L;
    private ProtectGroupReplica srcReplica;
    private boolean deleteReplica = false;
    private Boolean umountResult = null;

    protected boolean execute(RecoveryProcessorContext context) {
        User operaUser = RecoveryTaskUtil.getAdminUser();
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(this.srcReplica.getId());
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String hostName = "";
        if (10 == replica.getPg().getPoType()) {
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("uuid", replica.getMountedHost());
            List moLists = recoveryService.queryMoList(ManagedObject.class, querys);
            if (!VerifyUtil.isEmpty((Collection)moLists)) {
                ManagedObject mo = (ManagedObject)moLists.get(0);
                hostName = mo.getName();
            }
        } else {
            DrResource drResource = recoveryService.getDrResourceByID(replica.getMountedHost());
            if (null != drResource) {
                hostName = drResource.getName();
            }
        }
        this.updateProcessNameParams(new String[]{replica.getName(), hostName});
        UmountReplicaTask task = new UmountReplicaTask(replica, operaUser, this.deleteReplica, this);
        task.setNeedLock(false);
        MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        boolean success = this.waitTaskResult();
        if (success) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return success;
    }

    protected String generateResultKey() {
        return null;
    }

    public ProtectGroupReplica getSrcReplica() {
        return this.srcReplica;
    }

    public void setSrcReplica(ProtectGroupReplica srcReplica) {
        this.srcReplica = srcReplica;
    }

    public boolean isDeleteReplica() {
        return this.deleteReplica;
    }

    public void setDeleteReplica(boolean deleteReplica) {
        this.deleteReplica = deleteReplica;
    }

    public void notify(boolean result) {
        this.setUmountResult(result);
    }

    private boolean waitTaskResult() {
        boolean taskResult = false;
        for (long times = 180L; times > 0L; --times) {
            CommonUtil.sleep((long)10000L);
            Boolean result = this.getUmountResult();
            if (null == result) continue;
            taskResult = result;
            break;
        }
        return taskResult;
    }

    private synchronized Boolean getUmountResult() {
        return this.umountResult;
    }

    private synchronized void setUmountResult(Boolean umountResult) {
        this.umountResult = umountResult;
    }
}

