/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class CheckRemoteSiteSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = -7023976631396089571L;
    private static final Log logger = LogFactory.getInstance(CheckRemoteSiteSubProcessor.class);
    private static final long USER_ADMIN_ID = 1L;

    public CheckRemoteSiteSubProcessor() {
        this.setIsNeedSave(false);
    }

    public CheckRemoteSiteSubProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    public boolean execute(RecoveryProcessorContext context) {
        try {
            Site remoteSite = (Site)context.getAttribute("productionSite");
            if (null == remoteSite) {
                throw new LegoCheckedException(1073947393L);
            }
            if (1 == remoteSite.getSiteType()) {
                ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
                siteService.updateSite(remoteSite, remoteSite.getName(), Long.valueOf(1L));
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Checking remote site failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Checking remote site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }
}

