/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefreshStorageProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectBaseManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

public class CheckStorageRelationSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = -7759898517444187750L;
    private static final Log logger = LogFactory.getInstance(CheckStorageRelationSubProcessor.class);
    private String recoveryArray;
    private List<String> lunIds;

    public CheckStorageRelationSubProcessor() {
        this.setIsNeedSave(false);
    }

    public CheckStorageRelationSubProcessor(RecoveryProcessor parentProcess, String recoveryArray, List<String> lunIds) {
        super(parentProcess);
        this.recoveryArray = recoveryArray;
        this.lunIds = lunIds;
        this.setIsNeedSave(false);
    }

    public String getRecoveryArray() {
        return this.recoveryArray;
    }

    public void setRecoveryArray(String recoveryArray) {
        this.recoveryArray = recoveryArray;
    }

    public List<String> getLunIds() {
        return this.lunIds;
    }

    public void setLunIds(List<String> lunIds) {
        this.lunIds = lunIds;
    }

    public boolean execute(RecoveryProcessorContext context) {
        RefreshStorageProcessor refreshStorageProcessor = new RefreshStorageProcessor((RecoveryProcessor)this);
        refreshStorageProcessor.setIsNeedCreateDetail(false);
        boolean result = refreshStorageProcessor.execute(context);
        if (!result) {
            this.updateProcessDetail("lego.err.1073948761", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        try {
            logger.debug((Object)("Need to check lunIds:" + this.lunIds.toString()), 90160758786816L);
            IStorageReprotectBaseManager manager = StorageReprotectManagerProxy.getInstance().getStorageReprotectMgrByDevId(this.recoveryArray);
            manager.checkStorageReplication(this.recoveryArray, this.lunIds);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Checking storage replication failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Checking storage replication failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

