/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreReplicationPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class RefactorReplicationSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = -2715459610241826383L;
    private static final Log logger = LogFactory.getInstance(RefactorReplicationSubProcessor.class);
    private static final int TIME_OUT = 180;

    public RefactorReplicationSubProcessor() {
        this.setIsNeedSave(false);
    }

    public RefactorReplicationSubProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    public boolean execute(RecoveryProcessorContext context) {
        try {
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            String disasterSiteId = this.getDisasterSiteId(context);
            boolean result = this.refactorReplication(context, recoveryPlan, disasterSiteId);
            if (!result) {
                return false;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Refactoring replication failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Refactoring replication failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String getDisasterSiteId(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        return disasterSiteId;
    }

    private boolean refactorReplication(RecoveryProcessorContext context, RecoveryPlan recoveryPlan, String disasterSiteId) {
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            String recoveryArray = this.getRecoveryArrayByPg(protectGroup, disasterSiteId);
            if (null == recoveryArray) {
                logger.error((Object)("There is no recovery array. pg:" + protectGroup.getName() + ",SiteID:" + disasterSiteId), 90160758784001L);
                continue;
            }
            List<RemoteStorageReplica> remoteReplicas = this.getRemoteReplicas(context, protectGroup, disasterSiteId);
            if (null == remoteReplicas || remoteReplicas.isEmpty()) {
                logger.error((Object)("The remote stor replicas is null. pg:" + protectGroup.getName() + ",SiteID:" + disasterSiteId), 90160758784001L);
                continue;
            }
            HashMap<String, RemoteStorageReplica> replicas = new HashMap<String, RemoteStorageReplica>();
            for (RemoteStorageReplica remoteReplica : remoteReplicas) {
                boolean isConsistentGroup = RecoveryProcessUtil.isConsistentGroup((RemoteStorageReplica)remoteReplica);
                boolean isVstorePair = RecoveryProcessUtil.isVstorePair((RemoteStorageReplica)remoteReplica);
                if (isConsistentGroup) {
                    replicas.put(ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.name() + remoteReplica.getConsistentGroupId(), remoteReplica);
                    continue;
                }
                if (isVstorePair) {
                    replicas.put(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.name() + remoteReplica.getVstorePairId(), remoteReplica);
                    continue;
                }
                replicas.put(remoteReplica.getReplicationPairId(), remoteReplica);
            }
            long startA = System.currentTimeMillis();
            long startB = 0L;
            ArrayList<ReverseTask> reverseTasks = new ArrayList<ReverseTask>();
            for (RemoteStorageReplica remoteReplica : replicas.values()) {
                ReverseTask reverseTask = new ReverseTask(protectGroup, recoveryArray, remoteReplica);
                reverseTasks.add(reverseTask);
            }
            List results = ExecutionService.batchSubmit(reverseTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)180, (int)20);
            startB = System.currentTimeMillis();
            logger.debug((Object)("update ReplicationPairsByMasterLun cost time:" + (startA - startB)));
            if (results.size() != reverseTasks.size()) {
                logger.error((Object)"The reverse tasks exsist failed task.", 90160758784001L);
                this.updateProcessDetail("lego.err.-1", new String[0]);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
            for (OperationResult result : results) {
                if (result.isSuccess()) continue;
                this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        return true;
    }

    protected List<RemoteStorageReplica> getRemoteReplicas(RecoveryProcessorContext context, ProtectGroup protectGroup, String disasterSiteId) {
        ProtectGroupReplica protectGroupReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            protectGroupReplica = replica;
            break;
        }
        ArrayList<RemoteStorageReplica> remoteStorageReplicas = new ArrayList<RemoteStorageReplica>();
        if (null == protectGroupReplica) {
            return remoteStorageReplicas;
        }
        for (ProtectObjectReplica protectObjectReplica : protectGroupReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
                RemoteStorageReplica remoteStorage = (RemoteStorageReplica)storageInfo;
                logger.info((Object)("Need to reverse replicationPair direction:" + remoteStorage.getReplicationPairId()), 90160758786816L);
                remoteStorageReplicas.add(remoteStorage);
            }
        }
        return remoteStorageReplicas;
    }

    private OperationResult reverseReplication(ProtectGroup protectGroup, String recoveryArray, RemoteStorageReplica replica) {
        OperationResult result;
        boolean isConsistentGroup = RecoveryProcessUtil.isConsistentGroup((RemoteStorageReplica)replica);
        boolean isVstorePair = RecoveryProcessUtil.isVstorePair((RemoteStorageReplica)replica);
        String replicationId = isConsistentGroup ? replica.getConsistentGroupId() : replica.getReplicationPairId();
        IStorageVstoreReplicationPairManager vstoreReplicationPairManager = null;
        if (isVstorePair) {
            replicationId = replica.getVstorePairId();
            vstoreReplicationPairManager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(recoveryArray);
        }
        String srcProviderSN = replica.getSrcStorageProviderSN();
        String providerSN = replica.getStorageProviderSN();
        IStorageReprotectBaseManager reprotectManager = StorageReprotectManagerProxy.getInstance().getStorageReprotectMgrByDevId(recoveryArray);
        if (this.isUnReversedRemoteStorageReplica(protectGroup, recoveryArray, (RelicaStorageInfo)replica)) {
            if (isVstorePair) {
                if (VerifyUtil.isEmpty((Object)vstoreReplicationPairManager)) {
                    throw new LegoCheckedException(1073947393L);
                }
                result = vstoreReplicationPairManager.swap(providerSN, replicationId);
                if (result != null && result.isSuccess()) {
                    result = vstoreReplicationPairManager.setSecondaryPairReadWrite(providerSN, replicationId, String.valueOf(2));
                }
            } else {
                result = reprotectManager.reverseReplication(srcProviderSN, providerSN, replicationId, isConsistentGroup);
            }
        } else {
            if (isVstorePair) {
                if (VerifyUtil.isEmpty((Object)vstoreReplicationPairManager)) {
                    throw new LegoCheckedException(1073947393L);
                }
                result = vstoreReplicationPairManager.setSecondaryPairReadWrite(providerSN, replicationId, String.valueOf(2));
            } else {
                result = reprotectManager.setSecondaryLunWriteProtection(srcProviderSN, providerSN, replicationId, isConsistentGroup);
            }
            if (null != result && !result.isSuccess() && (String.valueOf(1077938066L).equals(result.getErrorCode()) || String.valueOf(1073749061L).equals(result.getErrorCode()))) {
                result = new OperationResult("ism.business.replication.setTargetResAccessAttr", true, true, new String[0]);
            }
        }
        return result;
    }

    private boolean isUnReversedRemoteStorageReplica(ProtectGroup protectGroup, String recoveryArray, RelicaStorageInfo storageInfo) {
        String siteInfoListStr;
        Set<String> oldProductSiteIdSet = new HashSet<String>(Arrays.asList(protectGroup.getProductSiteId()));
        if ((protectGroup.getTemplate().getType() == 35 || protectGroup.getTemplate().getType() == 36) && null != (siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO"))) {
            List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
            oldProductSiteIdSet = ((SiteInfo)siteInfoList.get(0)).getSiteIdSet();
        }
        if (protectGroup.getTemplate().getType() == PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO_RING.getValue()) {
            return storageInfo instanceof RemoteStorageReplica && !this.isReversed(oldProductSiteIdSet, storageInfo.getSrcStorageProviderSN(), storageInfo.getStorageProviderSN(), storageInfo.getStorageId(), protectGroup.getTemplate().getType());
        }
        return storageInfo instanceof RemoteStorageReplica && recoveryArray.equals(storageInfo.getStorageProviderSN()) && !this.isReversed(oldProductSiteIdSet, storageInfo.getSrcStorageProviderSN(), storageInfo.getStorageProviderSN(), storageInfo.getStorageId(), protectGroup.getTemplate().getType());
    }

    private final class ReverseTask
    implements Callable<OperationResult> {
        private ProtectGroup protectGroup = null;
        private String recoveryArraySN = null;
        private RemoteStorageReplica remoteStorageReplica = null;

        public ReverseTask(ProtectGroup protectGroup, String recoveryArray, RemoteStorageReplica replica) {
            this.protectGroup = protectGroup;
            this.recoveryArraySN = recoveryArray;
            this.remoteStorageReplica = replica;
        }

        @Override
        public OperationResult call() {
            OperationResult result = RefactorReplicationSubProcessor.this.reverseReplication(this.protectGroup, this.recoveryArraySN, this.remoteStorageReplica);
            return result;
        }
    }
}

