/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefreshStorageSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RefreshStorageProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 1591468831038036494L;

    public RefreshStorageProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type;
        RecoveryProcessSerialExecutor recoveryTemplate;
        Set<RecoveryProcessor> subProcessors = this.createSubProcessors(context);
        if (!VerifyUtil.isEmpty(subProcessors)) {
            this.setHasChildProc(true);
        }
        if (null == (recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)(type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()))))) {
            throw new LegoCheckedException(1073947395L);
        }
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(subProcessors);
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.equals((Object)procStatus);
    }

    private Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set protectGroups = recoveryPlan.getProtectGroups();
        ArrayList<String> addedStorage = new ArrayList<String>();
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        List<String> needRefreshArrays = this.getRefreshArrays(protectGroups, disasterSiteId);
        Set<RecoveryProcessor> subProcessors = this.constructSubProcessors(addedStorage, needRefreshArrays);
        return subProcessors;
    }

    private List<String> getRefreshArrays(Set<ProtectGroup> protectGroups, String disasterSiteId) {
        ArrayList<String> needRefreshArrays = new ArrayList<String>();
        for (ProtectGroup protectGroup : protectGroups) {
            List<Integer> ringTemplateTypes = Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_RING.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO_RING.getValue());
            if (ringTemplateTypes.contains(protectGroup.getTemplate().getType())) {
                JSONObject props = JSONObject.fromObject(protectGroup.getProps().get("hyper-dr-ring-used-resources"));
                JSONArray array = new JSONArray();
                if (props.containsKey((Object)"product.storage")) {
                    array.addAll((Collection)props.getJSONArray("product.storage"));
                }
                if (props.containsKey((Object)"recovery.storage")) {
                    array.addAll((Collection)props.getJSONArray("recovery.storage"));
                }
                needRefreshArrays.addAll((Collection<String>)array);
                continue;
            }
            ProtectGroupReplica protectGroupReplica = null;
            for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
                if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
                protectGroupReplica = replica;
                break;
            }
            if (null == protectGroupReplica) continue;
            needRefreshArrays.add(protectGroupReplica.getRecoveryArray());
            needRefreshArrays.add(protectGroupReplica.getProductArray());
        }
        return needRefreshArrays;
    }

    private Set<RecoveryProcessor> constructSubProcessors(List<String> addedStorage, List<String> needRefreshArrays) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (String needRefreshArrayId : needRefreshArrays) {
            if (addedStorage.contains(needRefreshArrayId)) continue;
            IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
            DrResource drResource = recoveryService.getDrResourceByID(needRefreshArrayId);
            String resourceName = needRefreshArrayId;
            if (null != drResource) {
                resourceName = drResource.getName();
            }
            RefreshStorageSubProcessor rss = new RefreshStorageSubProcessor((RecoveryProcessor)this, needRefreshArrayId, resourceName);
            rss.setIsNeedCreateDetail(false);
            subProcessors.add((RecoveryProcessor)rss);
            addedStorage.add(needRefreshArrayId);
        }
        return subProcessors;
    }
}

