/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class RefreshStorageSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 2462925564560426284L;
    private static final Log logger = LogFactory.getInstance(RefreshStorageSubProcessor.class);
    private String recoveryArray;
    private String arrayName;

    public RefreshStorageSubProcessor() {
        this.setIsNeedSave(false);
    }

    public RefreshStorageSubProcessor(RecoveryProcessor parrentProcessor, String recoveryArray, String arrayName) {
        super(parrentProcessor);
        this.recoveryArray = recoveryArray;
        this.arrayName = arrayName;
        this.setIsNeedSave(false);
    }

    public String getRecoveryArray() {
        return this.recoveryArray;
    }

    public void setRecoveryArray(String recoveryArray) {
        this.recoveryArray = recoveryArray;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.arrayName});
        try {
            StorageReprotectManagerProxy.getInstance().refreshStorage(this.recoveryArray);
            logger.info((Object)("Refreshing storage successed. Name\uff1a" + this.arrayName + ",SN:" + this.recoveryArray), 90160758784000L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Refreshing storage failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Refreshing storage failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

