/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.provider.RefactorConfigurationProviderMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationBaseProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class ReprotectCallBackExcuteRecoveryTask
implements ICallBackExcuteRecoveryTask {
    private static final Log logger = LogFactory.getInstance(ReprotectCallBackExcuteRecoveryTask.class);

    public void afterExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        DrmEnumDefine.AppType appType;
        String isReversedInGlobalSetting = (String)context.getAttribute("isReserved");
        if ("true".equalsIgnoreCase(isReversedInGlobalSetting)) {
            logger.debug((Object)"the isReserved is true");
            return;
        }
        RefactorConfigurationProviderMgr refactorCfgProviderMgr = RefactorConfigurationProviderMgr.getInstance();
        IRefactorConfigurationBaseProvider refacotryprovider = refactorCfgProviderMgr.getRefactorConfigurationProvider((appType = RecoveryServiceUtil.getAppType((RecoveryPlan)recoveryPlan)).name());
        if (refacotryprovider == null) {
            logger.error((Object)"refacotryprovider is null,planId:%s. ", new Object[]{recoveryPlan.getPlanId()});
            return;
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (!String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            logger.info((Object)"refactor recoveryplan not success,planId:%s. ", new Object[]{recoveryPlan.getPlanId()});
            return;
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan planWithProcess = planService.getRecoveryPlan(recoveryPlan.getPlanId(), true, false);
        if (planWithProcess == null) {
            logger.error((Object)"The recovery plan does not exist. planId:%s.", new Object[]{recoveryPlan.getPlanId()});
            return;
        }
        Set definitions = planWithProcess.getRecoveryProcesses();
        if (VerifyUtil.isEmpty((Collection)definitions)) {
            return;
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (provider == null) {
            logger.error((Object)"provicer is null,planId is %s. ", new Object[]{recoveryPlan.getPlanId()});
            return;
        }
        Class customProcessorCls = ((IRecoveryProcessProvider)provider).getCustomRecoveryProcessorClass();
        for (RecoveryProcessDefinition definition : definitions) {
            ((IRefactorConfigurationProvider)refacotryprovider).deleteCustomRecoveryProcessors(definition, customProcessorCls, (IRecoveryProcessProvider)provider);
        }
    }

    public void beforeExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
    }
}

