/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.base.task.IBackTaskListener;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.task.ReplicaOperationTask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class UmountReplicaTask
extends ReplicaOperationTask {
    private static Log logger = LogFactory.getInstance(UmountReplicaTask.class);
    private static final KeyLocker UMOUNT_TASK_LOCKER = new KeyLocker(UmountReplicaTask.class, "UMOUNT_TASK_LOCKER");
    private boolean deleteReplica = false;

    public UmountReplicaTask(ProtectGroupReplica replica, User operator, boolean deleteReplica) {
        this(replica, operator, deleteReplica, null);
    }

    public UmountReplicaTask(ProtectGroupReplica replica, User operator, boolean deleteReplica, IBackTaskListener listener) {
        super(replica, replica.getProperty(""), operator, "ism.drm.unmount.replica", false, listener);
        String taskDescription = "Umount replica[%s] from host[%s] timeout.";
        this.setTaskDescription(taskDescription);
        this.deleteReplica = deleteReplica;
    }

    protected void doWork() {
        String hostLockId = "HOST_LOCK_PREFIX_" + this.getReplica().getMountedHost();
        this.tryLock(hostLockId);
        try {
            this.doWorkWithReplicaLock();
        }
        finally {
            this.releaseLock(hostLockId);
        }
    }

    private void doWorkWithReplicaLock() {
        String lockId = "REPLICA_LOCK_PREFIX_" + this.getReplica().getId();
        this.tryLock(lockId);
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        String planId = null;
        Boolean bReplicStatus = false;
        try {
            ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(this.getReplica().getId());
            if (null == replica) {
                throw new LegoCheckedException(1073947394L);
            }
            this.setReplica(replica);
            if (Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()).equals(replica.getMountStatus())) {
                return;
            }
            if (!(Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(replica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()).equals(replica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.MOUNT_FAILED.getStatus()).equals(replica.getMountStatus()))) {
                logger.error((Object)"srcReplica is not valid. replicaId:[%s], status:[%s]", new Object[]{replica.getId(), replica.getStatus()});
                throw new LegoCheckedException(1073948693L);
            }
            planId = (String)this.getReplica().getProps().get("planId");
            this.setMountHost(this.getReplica().getMountedHost());
            ILocalRecoveryManager manager = (ILocalRecoveryManager)ServiceLocator.getInstance().getService(ILocalRecoveryManager.class);
            manager.umountReplica(planId, this.getOperator());
            this.getReplica().setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTING.getStatus()));
            service.saveOrUpdateReplica(this.getReplica());
            this.waitTaskCompleted(planId, DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED, 1073948250L);
            bReplicStatus = true;
            this.afterUnmountReplica(replicaService, planService, planId);
        }
        catch (LegoCheckedException e) {
            ProtectGroupReplica dbReplica;
            logger.error((Object)"UmountReplicaTask error:", (Throwable)e);
            if (!bReplicStatus.booleanValue() && null != (dbReplica = service.queryProtectGroupReplicaById(this.getReplica().getId()))) {
                dbReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()));
                service.saveOrUpdateReplica(dbReplica);
            }
            throw e;
        }
        finally {
            this.releaseLock(lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterUnmountReplica(IReplicaService replicaService, IRecoveryPlanService planService, String planId) {
        if (!this.deleteReplica) {
            return;
        }
        if (VerifyUtil.isEmpty((String)planId)) {
            return;
        }
        String key = planId + 0;
        try {
            long startTime = System.currentTimeMillis();
            int retries = 180;
            boolean isLock = UMOUNT_TASK_LOCKER.tryLock(key, (long)retries);
            long endTime = System.currentTimeMillis();
            logger.info((Object)"The total time spent acquiring locks is %s", new Object[]{String.valueOf(endTime - startTime)});
            if (!isLock) {
                logger.error((Object)"Cannot get lock mount plan retry %s times", new Object[]{String.valueOf(retries)});
                return;
            }
            planService.removeRecoveryPlan(planId);
        }
        finally {
            UMOUNT_TASK_LOCKER.unlock(key);
        }
        replicaService.deleteProtectGroupReplicaById(this.getOperator(), this.getReplica().getPg().getUuid(), this.getReplica().getId());
    }
}

