/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecoveryProcessUtil
extends RecoveryProcessBaseUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessUtil.class);

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Site remoteSite, Collection<RecoveryTask> recoveryTasks) {
        RecoveryPlan plan = context.getRecoveryPlan();
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<Integer> hyperMetreTypeSet = new HashSet<Integer>(Arrays.asList(18, 23, 31, 36, 35));
        PolicyTemplate template = ((ProtectGroup)iterator.next()).getTemplate();
        if (template != null && hyperMetreTypeSet.contains(template.getType())) {
            if (context.getProtectGroup() == null) {
                logger.error((Object)"The protectgroup in context is empty!");
                throw new LegoCheckedException(1073947394L);
            }
            return RecoveryProcessUtil.checkHyperMetroSrcLunUnMapping(remoteSite, context.getProtectGroup().getPolist());
        }
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (RecoveryTask rt : recoveryTasks) {
            Map lunAndHostMap = rt.getLunAndHostMap();
            Map resourceAndTypeMap = rt.getResourceAndTypeMap();
            String srcDevId = rt.getSrcDeviceId();
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(srcDevId);
            if (srcLunIds == null) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(srcDevId, srcLunIds);
            }
            for (String key : lunAndHostMap.keySet()) {
                if (DrmEnumDefine.AppType.NAS_FILESYSTEM.getValue() == ((Integer)resourceAndTypeMap.get(key)).intValue()) continue;
                String srcLunId = RecoveryProcessUtil.getSrcLunIdFromLunAndHostMapKey((String)key);
                srcLunIds.add(srcLunId);
            }
        }
        return RecoveryProcessUtil.isSrcLunsUnMapping(remoteSite, devAndLunMap);
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Collection<RecoveryTask> recoveryTasks) {
        if (recoveryTasks == null) {
            throw new LegoCheckedException(-1L);
        }
        Map<String, Set<String>> devLunMap = RecoveryProcessUtil.getReplicaSourceMap(context);
        if (!VerifyUtil.isEmpty(devLunMap)) {
            return RecoveryProcessUtil.isReplicaSourceUnMapping(devLunMap);
        }
        HashSet<String> devSns = new HashSet<String>();
        HashSet<String> srcLunIds = new HashSet<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            devSns.add(recoveryTask.getSrcDeviceId());
            Set srcStorageIds = recoveryTask.getSrcStorageIds();
            if (VerifyUtil.isEmpty((Collection)srcStorageIds)) {
                logger.debug((Object)"the param is null");
                continue;
            }
            Iterator iterator = srcStorageIds.iterator();
            if (!iterator.hasNext()) continue;
            String srcLunId = (String)iterator.next();
            srcLunIds.add(srcLunId);
        }
        if (devSns.isEmpty() || devSns.size() > 1) {
            logger.error((Object)"Error: the source device amount:%s", new Object[]{String.valueOf(devSns.size())});
            throw new LegoCheckedException(-1L);
        }
        String srcDevSn = (String)CommonUtil.getFirstElement(devSns);
        ArrayList<String> lunIds = new ArrayList<String>(srcLunIds);
        return RecoveryProcessUtil.isSrcLunUnMapping(srcDevSn, lunIds);
    }

    private static boolean isSrcLunsUnMapping(Site remoteSite, Map<String, Set<String>> devAndLunMap) {
        boolean isSrcLunUnMap = false;
        for (Map.Entry<String, Set<String>> entry : devAndLunMap.entrySet()) {
            ArrayList<String> srcLunIds;
            String devId = entry.getKey();
            isSrcLunUnMap = RecoveryProcessUtil.isSrcLunUnMapping(remoteSite, devId, srcLunIds = new ArrayList<String>((Collection)entry.getValue()));
            if (isSrcLunUnMap) continue;
            return false;
        }
        return isSrcLunUnMap;
    }

    private static boolean checkHyperMetroSrcLunUnMapping(Site productionSite, Set<ProtectObject> protectObjects) {
        Set<String> lunWwnSet = RecoveryProcessUtil.getAllWwn(protectObjects);
        ArrayList<String> wwnList = new ArrayList<String>(lunWwnSet);
        List lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(productionSite.getServerUuid(), wwnList, Lun.class);
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (Lun lun : lunList) {
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(lun.getDevSn());
            if (srcLunIds == null) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(lun.getDevSn(), srcLunIds);
            }
            srcLunIds.add(lun.getLunId());
        }
        return RecoveryProcessUtil.isSrcLunsUnMapping(productionSite, devAndLunMap);
    }

    private static Map<String, Set<String>> getReplicaSourceMap(RecoveryProcessorContext context) {
        HashMap<String, Set<String>> devLunMap = new HashMap<String, Set<String>>();
        if (VerifyUtil.isEmpty((Object)context)) {
            return devLunMap;
        }
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            return devLunMap;
        }
        Set replicas = protectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return devLunMap;
        }
        HashSet<String> lunWwnSet = new HashSet<String>();
        RecoveryProcessUtil.extracted(devLunMap, replicas, lunWwnSet);
        for (Map.Entry entry : devLunMap.entrySet()) {
            if (((Set)entry.getValue()).size() == lunWwnSet.size()) continue;
            logger.error((Object)"storageInfos.size=%s not equal lunIdSet.size=%s.", new Object[]{String.valueOf(lunWwnSet.size()), entry.getValue()});
            return new HashMap<String, Set<String>>();
        }
        return devLunMap;
    }

    private static void extracted(Map<String, Set<String>> devLunMap, Set<ProtectObjectReplica> replicas, Set<String> lunWwnSet) {
        for (ProtectObjectReplica replica : replicas) {
            Set storageInfos = replica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            for (RelicaStorageInfo storageInfo : storageInfos) {
                String lunWwn = storageInfo.getProtectObjectStorageWwn();
                if (VerifyUtil.isEmpty((String)lunWwn)) {
                    logger.warn((Object)"empty lunWwn,SrcStorageId=%s.", new Object[]{storageInfo.getSrcStorageId()});
                    continue;
                }
                lunWwnSet.add(lunWwn);
                List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
                if (VerifyUtil.isEmpty((Collection)resources)) {
                    logger.error((Object)"resources null,lunWwn=%s.", new Object[]{lunWwn});
                    continue;
                }
                for (StorageResource resource : resources) {
                    String devSn = resource.getDevSn();
                    String lunId = resource.getResourceId();
                    Set<String> lunIdSet = devLunMap.get(devSn);
                    if (VerifyUtil.isEmpty(lunIdSet)) {
                        lunIdSet = new HashSet<String>();
                        devLunMap.put(devSn, lunIdSet);
                    }
                    lunIdSet.add(lunId);
                }
            }
        }
    }

    private static boolean isReplicaSourceUnMapping(Map<String, Set<String>> devLunMap) {
        for (Map.Entry<String, Set<String>> entry : devLunMap.entrySet()) {
            ArrayList<String> lunIds;
            String srcDevSn = entry.getKey();
            if (RecoveryProcessUtil.isSrcLunUnMapping(srcDevSn, lunIds = new ArrayList<String>((Collection)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getAllWwn(Set<ProtectObject> protectObjects) {
        HashSet<String> allWwn = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)"PolicyTemplate check protectObject storageInfo is empty, po uuid is:%s,name is %s.", new Object[]{po.getUuid(), po.getName()});
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String lunWwn = Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()).equals(posi.getResourceType()) ? posi.getResourceId() : posi.getLunWWN();
                if (VerifyUtil.isEmpty((String)lunWwn)) {
                    logger.error((Object)"lunWWN is empty, po uuid is:%s,name is %s.", new Object[]{po.getUuid(), po.getName()});
                    throw new LegoCheckedException(1073948453L);
                }
                allWwn.add(lunWwn);
            }
        }
        return allWwn;
    }

    public static Set<String> getAllSecondaryLunWwn(ProtectGroup protectGroup) {
        return RecoveryProcessUtil.getSecondaryLunWwn(protectGroup, null);
    }

    public static Set<String> getSecondaryLunWwn(ProtectGroup protectGroup, Set<String> secondarySites) {
        HashSet<String> allWwn = new HashSet<String>();
        ArrayList resourceIds = new ArrayList();
        String deviceSn = null;
        ArrayList replicationRelations = new ArrayList();
        Map replicationRelationBoMap = protectGroup.getAllReplicationRelation();
        Set entrySet = replicationRelationBoMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!VerifyUtil.isEmpty(secondarySites) && !secondarySites.contains(entry.getKey())) continue;
            replicationRelations.addAll((Collection)entry.getValue());
        }
        for (ReplicationRelationBo rep : replicationRelations) {
            deviceSn = rep.getTgtDeviceSn();
            resourceIds.addAll(rep.getTgtLuns().values());
        }
        if (deviceSn == null || VerifyUtil.isEmpty(resourceIds)) {
            logger.error((Object)"ProtectGroup's ReplicationRelation info is empty, pgId:%s.", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073948453L);
        }
        if (RecoveryProcessUtil.isProtectGroupUseNasFileSystem(protectGroup)) {
            allWwn.addAll(resourceIds);
            return allWwn;
        }
        List targetLuns = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResources(deviceSn, resourceIds, Lun.class);
        if (!VerifyUtil.isEmpty((Collection)targetLuns)) {
            for (Lun lun : targetLuns) {
                allWwn.add(lun.getWwn());
            }
        }
        return allWwn;
    }

    public static String getPairStr(HyperMetroPair pair) {
        StringBuilder sb = new StringBuilder();
        String uuid = pair.getUuid();
        String resourceWwn = pair.getResourceWwn();
        String localObjId = pair.getLocalObjId();
        String remoteObjId = pair.getRemoteObjId();
        String remoteDevSn = pair.getRemoteDevSn();
        String split = ",";
        sb.append("[");
        sb.append("pairUuid:").append(uuid).append(split).append("runningStatus:").append(pair.getRunningState()).append(split).append("healthStatus:").append(pair.getHealthState()).append(split).append("syncDirection:").append(VerifyUtil.isEmpty((Object)pair.getSyncDirection()) ? "empty" : pair.getSyncDirection().toString()).append(split).append("resourceWwn:").append(resourceWwn).append(split).append("localObjId:").append(localObjId).append(split).append("remoteObjId:").append(remoteObjId).append(split).append("remoteDevSn:").append(remoteDevSn).append("]");
        return sb.toString();
    }

    public static String getConsistentGroupStr(HyperMetroConsistentGroup group) {
        StringBuilder sb = new StringBuilder();
        String uuid = group.getUuid();
        String devSn = group.getDevSn();
        String split = ",";
        sb.append("[");
        sb.append("pairUuid:").append(uuid).append(split).append("runningStatus:").append(group.getRunningState()).append(split).append("healthStatus:").append(group.getHealthState()).append(split).append("syncDirection:").append(VerifyUtil.isEmpty((Object)group.getSyncDirection()) ? "empty" : group.getSyncDirection().toString()).append(split).append("DevSn:").append(devSn).append("]");
        return sb.toString();
    }

    public static DrmEnumDefine.RecoveryPlanExecuteTypeE getProcType(String procType) {
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA;
        }
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA;
    }

    public static boolean isSrcLunUnMapping(Site remoteSite, String srcDeviceId, List<String> srcLunIds) {
        if (remoteSite == null || srcDeviceId == null || VerifyUtil.isEmpty(srcLunIds)) {
            logger.error((Object)"Invalid parameters. srcDeviceId: %s,srcLunIds:%s.", new Object[]{srcDeviceId, srcLunIds});
            throw new LegoCheckedException(1073947393L);
        }
        if (remoteSite.getSiteType() == 0) {
            return RecoveryProcessUtil.isSrcLunUnMapping(srcDeviceId, srcLunIds);
        }
        try {
            Object[] lunIdArray = new String[srcLunIds.size()];
            srcLunIds.toArray(lunIdArray);
            String lunIds = StringUtil.arrayToStrWithSplit((Object[])lunIdArray, (String)";");
            RestClient client = SiteUtil.initClient((Site)remoteSite);
            HashMap<String, Object> srcUriVariabels = new HashMap<String, Object>();
            srcUriVariabels.put("devSn", srcDeviceId);
            srcUriVariabels.put("lunIds", lunIds);
            srcUriVariabels.put("isFromDevice", true);
            List luns = client.getForObjects("/ws/storages/{devSn}/luns/action/getBatchByLunIds?lunIds={lunIds}&isFromDevice={isFromDevice}", srcUriVariabels, Lun.class);
            return RecoveryProcessUtil.isLunUnMapping(srcLunIds, luns);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query SrcLunUnMapping Remote error:" + srcDeviceId + "-" + srcLunIds), (long)1073948695L, (String[])new String[0], (Log)logger);
            return false;
        }
    }

    private static boolean isSrcLunUnMapping(String srcDeviceId, List<String> lunIds) {
        try {
            List luns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryLunByDevSnAndLunIds(srcDeviceId, lunIds);
            return RecoveryProcessUtil.isLunUnMapping(lunIds, luns);
        }
        catch (Exception e) {
            logger.error((Object)"query SrcLunUnMapping Local error,srcDeviceId:%s,lunIds:%s,error is %s.", new Object[]{srcDeviceId, lunIds, ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }

    private static boolean isLunUnMapping(List<String> lunIds, List<Lun> luns) {
        if (VerifyUtil.isEmpty(luns)) {
            logger.error((Object)"LUNs quered is empty, return isLunUnMapping is false.");
            return false;
        }
        if (luns.size() != lunIds.size()) {
            logger.error((Object)"LUNs quered is not equals to the lunID amount, return isLunUnMapping is false.");
            return false;
        }
        for (Lun lun : luns) {
            boolean isMapped = lun.getMapped();
            if (!isMapped) continue;
            logger.error((Object)"The lun is mapped, and ID: %s,name:%s.", new Object[]{lun.getLunId(), lun.getName()});
            return false;
        }
        return true;
    }

    public static boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        ProtectObjectStorageInfo storageInfo;
        logger.debug((Object)"enter isProtectGroupUseNasFileSystem ");
        boolean isNas = false;
        if (pg.getTemplate().getType() == 1 && pg.getTemplate().getSubType() == 2) {
            isNas = true;
        }
        if (!(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue() != pg.getTemplate().getType() && PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO.getValue() != pg.getTemplate().getType() || VerifyUtil.isEmpty((Object)(storageInfo = pg.getAnyProtectObjectStorageInfo())) || DrmEnumDefine.ResourceTypeE.NAS.getValue() != storageInfo.getResourceType().intValue())) {
            isNas = true;
        }
        if (14 == pg.getTemplate().getType() || 17 == pg.getTemplate().getType() || 28 == pg.getTemplate().getType()) {
            isNas = true;
        }
        return isNas;
    }

    public static String getVstoreId(ProtectGroup pg) {
        String vstoreId = null;
        if (null != pg && null != pg.getPolist() && pg.getPolist().size() > 0) {
            ProtectObject protectObject = (ProtectObject)pg.getPolist().iterator().next();
            vstoreId = RecoveryProcessUtil.getVstoreId(protectObject);
        }
        return vstoreId;
    }

    private static String getVstoreId(ProtectObject protectObject) {
        String vstoreId = null;
        if (null != protectObject && null != protectObject.getUsedStorageResourceSet() && protectObject.getUsedStorageResourceSet().size() > 0) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next();
            vstoreId = null != protectObjectStorageInfo ? protectObjectStorageInfo.getVstoreId() : null;
        }
        return vstoreId;
    }

    public static String getVstoreIdByResourceId(String devSn, String resourceId) {
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceId);
        List result = moDao.findMoBy(NasFileSystem.class, props);
        if (!VerifyUtil.isEmpty((Collection)result)) {
            return ((NasFileSystem)result.iterator().next()).getVstoreId();
        }
        return null;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithConcurrentSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RecoveryPlanExecuteTypeE type, boolean isAsc) {
        if (processorsWithPriority == null || type == null) {
            logger.debug((Object)"The param type or processorsWithPriority is null");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iprocessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessConcurrentExecutor> subProcessors = new ArrayList<RecoveryProcessConcurrentExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (Integer integer : priorityLevel) {
                List<IProcessor> processors = processorsWithPriority.get(integer);
                RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, (boolean)false);
                subProcessors.add(executor);
                iprocessors.addAll(processors);
            }
        } else {
            for (int ii = priorityLevel.size() - 1; ii >= 0; --ii) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(ii));
                RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, (boolean)false);
                subProcessors.add(executor);
                iprocessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iprocessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (mainExecutor == null) {
            logger.error((Object)"mainExecutor is null.");
            throw new LegoCheckedException(0x300001L);
        }
        return mainExecutor;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithSerialSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RecoveryPlanExecuteTypeE type, boolean isAsc) {
        if (processorsWithPriority == null || type == null) {
            logger.debug((Object)"The param type or processorsWithPriority is null");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iprocessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessSerialExecutor> subProcessors = new ArrayList<RecoveryProcessSerialExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (Integer integer : priorityLevel) {
                List<IProcessor> processors = processorsWithPriority.get(integer);
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
                subProcessors.add(executor);
                iprocessors.addAll(processors);
            }
        } else {
            for (int i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
                subProcessors.add(executor);
                iprocessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iprocessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        return mainExecutor;
    }

    private static void updateProgressRatio(List<IProcessor> processors) {
        ArrayList<RecoveryProcessor> recoveryProcessors = new ArrayList<RecoveryProcessor>();
        for (IProcessor processor : processors) {
            if (!(processor instanceof RecoveryProcessor)) continue;
            recoveryProcessors.add((RecoveryProcessor)processor);
        }
        RecoveryServiceUtil.updateProgressRatio(recoveryProcessors);
    }
}

