/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.poll;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.service.impl.SyncDrmServerBackTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class ServerPoller
implements IPoller {
    private Log logger = LogFactory.getInstance(ServerPoller.class);
    private String uuid;

    public ServerPoller(String uuid) {
        this.uuid = uuid;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return "DRMSERVER";
    }

    public void run() {
        try {
            this.logger.debug((Object)("Begin poller task submitting, " + this.uuid), 90160777658372L);
            ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)this.uuid);
            if (null == server) {
                throw new LegoCheckedException(2117645L);
            }
            SyncDrmServerBackTask task = new SyncDrmServerBackTask("ism.discover.poll.operationName", server, false);
            task.doWork();
            this.logger.debug((Object)"End poller task submitting", 90160777658372L);
        }
        catch (LegoCheckedException ex) {
            this.logger.error((Object)("Poll fail, server=" + this.uuid), (Throwable)ex, 90160758784257L);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Poll fail, server=" + this.uuid + ExceptionUtil.getErrorMessage((Throwable)ex)));
        }
    }
}

