/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service.impl;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.resource.service.DiscoverResourceBackTask;
import com.huawei.ism.drm.site.resource.service.impl.AbstractResourceService;
import com.huawei.ism.drm.site.resource.service.impl.ResourceDiscoveryRemoteTaskCallback;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.RemoteSiteMonitorTask;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.io.Serializable;
import org.hibernate.Session;

@Service(name="com.huawei.ism.drm.site.resource.sdk.service.IResourceService", desc="", interfaceClass=IResourceService.class)
public class ResourceServiceImpl
extends AbstractResourceService {
    private static final Log logger = LogFactory.getInstance(ResourceServiceImpl.class);

    public DrResource getDrResourceBySnInLocalSite(String devSn, String resType) {
        logger.debug((Object)("devSn=" + devSn + ", resType=" + resType));
        VerifyUtil.checkStrs((String[])new String[]{devSn, resType});
        DrResource resource = this.getDrResourceBySn(devSn, resType);
        VerifyUtil.checkObject((Object)resource);
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)resource.getSiteId()));
        if (null != site && 0 == site.getSiteType()) {
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMo(ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            logger.error((Object)"updateMo method param is null error", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            session.beginTransaction();
            DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId((Long)mo.getMoId());
            if (!VerifyUtil.isEmpty((Object)resource)) {
                resource.setName(mo.getName());
                session.update((Object)resource);
            }
            session.update((Object)mo);
            this.modifyChildName(mo);
            if (mo instanceof Host) {
                ((Host)mo).setHostName(mo.getName());
            }
            session.getTransaction().commit();
            logger.info((Object)("send modify managedobject message. moId:" + mo.getMoId()), 90160758784001L);
            this.sendModifyMoMessage(mo);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession((Session)session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"update mo and mo child drresour ", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    private void modifyChildName(ManagedObject mo) {
        logger.debug((Object)"modifyChildName");
        if (mo == null || mo.getChildMos() == null) {
            return;
        }
        for (ManagedObject cmo : mo.getChildMos()) {
            if (!(cmo instanceof StorageUnit)) continue;
            cmo.setName(mo.getName());
        }
    }

    public long discoveryResource(DiscoveryPolicy policy) {
        long taskId = -1L;
        String siteId = policy.getLocation();
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            logger.error((Object)("site is not exist, siteId=" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (site.getSiteType() == 0) {
            DiscoverResourceBackTask backtask = new DiscoverResourceBackTask(policy);
            backtask.setTimeout(ManagedObjectManagerProxy.getInstance().getMgr(policy.getDeviceType()).getTimeout());
            BackTaskHandler instance = BackTaskHandler.getInstance();
            taskId = instance.submitTask((AbstractBackTask)backtask);
        } else {
            RestClient client = SiteUtil.initClient((Site)site);
            String uri = "/ws/resources/action/discoverResource";
            JSONArray array = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put((Object)"siteId", (Object)siteId);
            obj.put((Object)"ip", (Object)policy.getStartIP());
            obj.put((Object)"deviceType", (Object)policy.getDeviceType());
            obj.put((Object)"deviceSubType", (Object)policy.getDeviceSubType());
            obj.put((Object)"paramMap", (Object)policy.getParamMap());
            array.add((Object)obj);
            String responseString = client.post(uri, array.toString(), null);
            JSONObject resJsonObject = JSONObject.fromObject((Object)responseString);
            JSONArray records = resJsonObject.getJSONArray("result");
            JSONObject disResult = records.getJSONObject(0);
            Long remoteTaskId = NumberUtil.convertToLong((Object)disResult.getString("taskId"));
            Long errorCode = disResult.getLong("errorCode");
            if (errorCode > 0L) {
                logger.error((Object)errorCode);
                throw new LegoCheckedException(errorCode.longValue());
            }
            BackTask bt = BackTaskUtil.buildBackTask((String)policy.getStartIP(), (String)"ism.drm.discovery.monitor", (String)"System", (String)"", null);
            RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(siteId, remoteTaskId, bt);
            task.setCallback(new ResourceDiscoveryRemoteTaskCallback(siteId));
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        return taskId;
    }
}

