/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.poll.ServerPoller;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.service.impl.AbstractManagementServerService;
import com.huawei.ism.drm.site.service.impl.UpgradeRemoteServerAndSubSiteTransaction;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.util.NetUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

@Service(name="com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService", desc="", interfaceClass=IManagementServerBaseService.class)
public class ManagementServerBaseServiceImpl
extends AbstractManagementServerService
implements IManagementServerBaseService {
    private static final Log logger = LogFactory.getInstance(ManagementServerBaseServiceImpl.class);

    public void updateServer(ManagementServer server) {
        if (server == null) {
            logger.error((Object)"parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServer(server.getUuid());
        if (replica == null) {
            logger.error((Object)"not exsit,uuid =%s. ", new Object[]{server.getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        this.updateBasicInfo(replica, server.getName(), server.getDevAlias(), server.getUser());
        this.updateAuthInfo(replica, server.getIp(), server.getPort(), server.getPwd());
        CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)replica);
    }

    private void updateBasicInfo(ManagementServer replica, String newName, String newAlias, String user) {
        logger.debug((Object)"updateBasicInfo");
        int serverType = replica.getServerType();
        if (0 == serverType) {
            this.updateBasicInfoForLocal(replica, newName);
        } else if (1 == serverType) {
            this.updateBasicInfoForRemote(replica, newAlias);
            if (!VerifyUtil.isEmpty((String)user)) {
                replica.setUser(user);
            }
        }
    }

    private void updateBasicInfoForRemote(ManagementServer replica, String newAlias) {
        if (null == newAlias || newAlias.equals(replica.getDevAlias())) {
            logger.info((Object)"not changed.");
            return;
        }
        this.validateAlias(newAlias);
        replica.setDevAlias(newAlias);
    }

    protected void validateAlias(String alias) {
        if (VerifyUtil.isNone((String)alias)) {
            return;
        }
        if (!CommUtil.checkDrmNameParam((String)alias)) {
            logger.error((Object)"alias illegal,alias = %s. ", new Object[]{alias});
            throw new LegoCheckedException(1073947393L);
        }
        List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ManagementServer where devAlias=?", new Object[]{alias});
        if (!find.isEmpty()) {
            logger.error((Object)"not empty, alias=%s", new Object[]{alias});
            throw new LegoCheckedException(1073947392L);
        }
        ManagementServer localServerInfo = this.getServerInfo();
        if (null == localServerInfo) {
            logger.error((Object)"local info is null.", 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        if (alias.equals(localServerInfo.getName())) {
            logger.error((Object)"alias illegal, alias=%s.", new Object[]{alias});
            throw new LegoCheckedException(1073947392L);
        }
    }

    private void updateAuthInfo(ManagementServer replica, String ip, int port, String pwd) {
        if (1 != replica.getServerType()) {
            return;
        }
        if (VerifyUtil.isEmpty((String)ip) || port <= 0 || null == pwd || pwd.isEmpty()) {
            return;
        }
        this.validateRemoteServerIp(ip);
        this.validatePort(port);
        RestClient client = new RestClient(ip, port, replica.getUser(), pwd);
        ManagementServer rmtServer = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
        if (3 != replica.getStatus()) {
            if (!replica.getUuid().equals(rmtServer.getUuid())) {
                logger.error((Object)"uuid is different, replica=%s ,rmtServer=%s.", new Object[]{replica.getUuid(), rmtServer.getUuid()});
                throw new LegoCheckedException(1073947432L);
            }
            this.validateVersion(rmtServer, ip);
            AlarmReporter.restoreSystemVersionNotMatchAlarm((Long)replica.getMoId());
        } else {
            this.validateUuidBySites(replica, ip, port, replica.getUser(), pwd);
            this.validateVersion(rmtServer, ip);
            UpgradeRemoteServerAndSubSiteTransaction tx = new UpgradeRemoteServerAndSubSiteTransaction(replica, rmtServer.getUuid());
            tx.doInTransaction();
            replica.setUuid(rmtServer.getUuid());
            this.startServerPoller(rmtServer.getUuid());
        }
        replica.setName(rmtServer.getName());
        replica.setStatus(Integer.valueOf(0));
        replica.setIp(ip);
        replica.setPort(port);
        replica.setPwd(pwd);
        replica.setVersion(rmtServer.getVersion());
        AlarmReporter.restoreRemoteServerFaultAlarm((Long)replica.getMoId());
    }

    protected void startServerPoller(String uuid) {
        logger.info((Object)"Start server poller, uuid=%s.", new Object[]{uuid});
        ServerPoller poller = new ServerPoller(uuid);
        PollControllerLocator.getInstance().getPollController().addPoller((IPoller)poller);
    }

    protected void validateVersion(ManagementServer remote, String ip) {
        ManagementServer local = this.getServerInfo();
        if (local == null) {
            logger.error((Object)"Can not find local info");
            throw new LegoCheckedException(0x200909L);
        }
        String localVersion = local.getVersion();
        String remoteVersion = remote.getVersion();
        if (localVersion != null && !localVersion.equals(remoteVersion)) {
            logger.error((Object)"The version match failed, localV=%s,remoteV=%s.", new Object[]{localVersion, remoteVersion});
            throw new LegoCheckedException(1073947695L, new String[]{ip});
        }
    }

    protected void validatePort(int port) {
        if (port < 1) {
            logger.error((Object)"port=%s", new Object[]{String.valueOf(port)});
            throw new LegoCheckedException(1073947393L);
        }
        if (port > 65535) {
            logger.error((Object)"port=%s", new Object[]{String.valueOf(port)});
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void validateRemoteServerIp(String serverIp) {
        NetworkInterface[] infs;
        if (!CommUtil.checkDrmIpParam((String)serverIp)) {
            logger.error((Object)"ip=%s.", new Object[]{serverIp});
            throw new LegoCheckedException(1073947393L);
        }
        for (NetworkInterface networkInterface : infs = NetUtil.availableInterface()) {
            Enumeration<InetAddress> era = networkInterface.getInetAddresses();
            while (era.hasMoreElements()) {
                InetAddress ipElement = era.nextElement();
                String ip = ipElement.getHostAddress();
                if (!serverIp.equals(ip)) continue;
                logger.error((Object)"The specified ip is a local ip: %s.", new Object[]{serverIp});
                throw new LegoCheckedException(1073947698L);
            }
        }
    }

    public void validateUuidBySites(ManagementServer replica, String ip, Integer port, String user, String pwd) {
        RestClient client = new RestClient(ip, port.intValue(), user, pwd);
        List sitesInRemote = client.getForObjects("/ws/sites", null, Site.class);
        if (sitesInRemote == null) {
            logger.error((Object)"Remote server has no sites, ip=%s.", new Object[]{ip});
            throw new LegoCheckedException(1073947432L);
        }
        Iterator iterator = sitesInRemote.iterator();
        while (iterator.hasNext()) {
            Site next = (Site)iterator.next();
            if (1 != next.getSiteType()) continue;
            iterator.remove();
        }
        if (sitesInRemote.isEmpty()) {
            logger.error((Object)"Remote server has no local sites, ip=%s", new Object[]{ip});
            throw new LegoCheckedException(1073947432L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List sitesInDb = siteService.getSites(replica.getUuid());
        if (VerifyUtil.isEmpty((Collection)sitesInDb)) {
            logger.error((Object)"Sites in db is empty, serverUuid=%s", new Object[]{replica.getUuid()});
            throw new LegoCheckedException(1073947432L);
        }
        for (Site siteInDb : sitesInDb) {
            for (Site siteInRemote : sitesInRemote) {
                if (!siteInDb.getSiteId().equals(siteInRemote.getSiteId())) continue;
                logger.info((Object)"match success, siteId=%s", new Object[]{siteInDb.getSiteId()});
                return;
            }
        }
        logger.error((Object)"match failed, ip=%s", new Object[]{ip});
        throw new LegoCheckedException(1073947432L);
    }

    public List<ManagementServer> getServers() {
        logger.debug((Object)"getServers");
        ArrayList<ManagementServer> servers = new ArrayList<ManagementServer>();
        servers.add(this.getServerInfo());
        List moList = CommonDAOLocator.getMoDao().getMoList(ManagementServer.class, "serverType", (Object)1);
        for (ManagementServer mo : moList) {
            mo.setPwd(null);
            servers.add(mo);
        }
        return servers;
    }
}

