/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.service.impl.DeleteRemoteServerTransactionCallback;
import com.huawei.ism.drm.site.service.impl.ManagementServerBaseServiceImpl;
import com.huawei.ism.drm.site.service.impl.SyncDrmServerBackTask;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import org.springframework.transaction.support.TransactionCallback;

@Service(name="com.huawei.ism.drm.site.sdk.service.IManagementServerService", desc="", interfaceClass=IManagementServerService.class)
public class ManagementServerServiceImpl
extends ManagementServerBaseServiceImpl
implements IManagementServerService {
    private static final Log logger = LogFactory.getInstance(ManagementServerServiceImpl.class);

    public void addServer(ManagementServer server, Long userId) {
        if (null == server) {
            logger.error((Object)"server is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkManagementServerCount();
        ManagementServer replica = this.constructAndSaveServerInfo(server.getIp(), server.getPort(), server.getUser(), server.getPwd(), server.getDevAlias());
        SyncDrmServerBackTask task = new SyncDrmServerBackTask("ism.drm.mgmtserver.regedit", replica, true);
        task.setOperationUserId(userId);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private void checkManagementServerCount() {
        long count = CommonDAOLocator.getBaseDao().getTotalCount("select count(moId) from ManagementServer", new Object[0]);
        if (count >= 32L) {
            logger.error((Object)"ManagementServer is more than [%s]", 32L);
            throw new SpecCheckedException("Management_Server_quantity", 32L, count);
        }
    }

    private ManagementServer constructAndSaveServerInfo(String ip, int port, String user, String pwd, String alias) {
        this.validateRemoteServerIp(ip);
        this.validatePort(port);
        this.validateAlias(alias);
        RestClient client = new RestClient(ip, port, user, pwd);
        ManagementServer remote = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
        this.validateVersion(remote, ip);
        if (null != this.getServer(remote.getUuid())) {
            logger.error((Object)("the server has been registered, " + remote.getUuid()), 90160758784000L);
            throw new LegoCheckedException(1073947698L);
        }
        remote.setManaged(Boolean.valueOf(true));
        remote.setServerType(1);
        remote.setIp(ip);
        remote.setDevAlias(alias);
        remote.setPort(port);
        remote.setUser(user);
        remote.setPwd(pwd);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)remote);
        this.startServerPoller(remote.getUuid());
        return remote;
    }

    public void removeServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)("uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = this.getServer(uuid);
        if (null == server) {
            logger.error((Object)("not found, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        if (1 != server.getServerType()) {
            logger.error((Object)("local server can not be removed, " + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List sites = siteService.getSites(uuid);
        for (Site site : sites) {
            siteService.checkSiteCanDelete(site);
        }
        PollControllerLocator.getInstance().getPollController().stopPoller(uuid, true);
        for (Site site : sites) {
            siteService.deleteSite(site.getSiteId());
        }
        DeleteRemoteServerTransactionCallback callback = new DeleteRemoteServerTransactionCallback(server);
        CommonDAOLocator.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callback);
    }

    public void refreshServer(String uuid, Long userId) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)"uuid is empty.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
        if (null == server) {
            logger.error((Object)("not exist such server, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        if (1 != server.getServerType()) {
            logger.error((Object)("can not refresh local server, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        if (3 == server.getStatus()) {
            logger.error((Object)("can not refresh upgrading server, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947398L, new String[]{server.getIp()});
        }
        SyncDrmServerBackTask task = new SyncDrmServerBackTask("ism.drm.mgmtserver.refresh", server, true);
        if (null != userId) {
            task.setOperationUserId(userId);
        }
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public String get(String uuid, String url, JSONObject pathParams, JSONObject headParams) {
        ManagementServer server = this.getServer(uuid);
        if (VerifyUtil.isEmpty((Object)server)) {
            return null;
        }
        RestClient client = SiteUtil.initClient((ManagementServer)server);
        return client.get(url, pathParams.toMap(String.class), client.getHeaders(JSONObject.toMap((JSONObject)headParams, String.class)));
    }
}

