/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.service.impl.RefreshOurSiteCallbackImpl;
import com.huawei.ism.drm.site.service.impl.RefreshSiteBackTask;
import com.huawei.ism.drm.site.service.impl.SiteBaseServiceImpl;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import org.springframework.transaction.support.TransactionCallback;

@Service(name="com.huawei.ism.drm.site.sdk.service.ISiteService", desc="", interfaceClass=ISiteService.class)
public class SiteServiceImpl
extends SiteBaseServiceImpl
implements ISiteService {
    private static final Log logger = LogFactory.getInstance(SiteServiceImpl.class);

    public void refreshSite(Site site) {
        this.checkSiteParam(site);
        logger.debug((Object)"begin to refresh site:%s", new Object[]{site.getUuid()});
        Site siteInDB = this.getSite(site.getSiteId());
        if (siteInDB == null) {
            logger.error((Object)"Site not exist, siteId=%s", new Object[]{site.getSiteId()});
            throw new LegoCheckedException(1073947394L);
        }
        try {
            if (1 == siteInDB.getSiteType()) {
                ManagementServer rmtServer = this.queryRemoteServer(site.getServerUuid());
                if (!site.getServerUuid().equals(rmtServer.getUuid())) {
                    logger.error((Object)("Server uuid is changed, oldInSite=" + site.getServerUuid() + ", remote=" + rmtServer.getUuid()), 90160758784000L);
                    throw new LegoCheckedException(1073947432L);
                }
                Site remoteSite = this.getRemoteSiteInfo(site);
                if (remoteSite == null) {
                    logger.info((Object)"the remote site is null,siteId:%s", new Object[]{site.getUuid()});
                    this.deleteSiteFromDB(site);
                    throw new LegoCheckedException(1073947394L);
                }
                site.setName(remoteSite.getName());
                CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)site);
                this.refreshOurSite(site);
            }
            if (site.getIsCloudSite().booleanValue()) {
                this.refreshOurSite(site);
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"failed to poll site,siteId:%s,error :%s", new Object[]{site.getSiteId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)("Exception happend,failed to poll site:" + site.getSiteId()), (long)1053L, (String[])new String[0], (Log)logger);
        }
        logger.debug((Object)"end to poll site,siteId:%s", new Object[]{site.getSiteId()});
    }

    private void refreshOurSite(Site site) {
        if (1 != site.getSiteType() && !site.getIsCloudSite().booleanValue()) {
            logger.info((Object)"site is not a remote site, siteId=%s", new Object[]{site.getSiteId()});
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        RefreshOurSiteCallbackImpl callBack = new RefreshOurSiteCallbackImpl(site);
        baseDao.getTransactionTemplate().execute((TransactionCallback)callBack);
    }

    private Site getRemoteSiteInfo(Site site) {
        RestClient client = SiteUtil.initClient((Site)site);
        HashMap<String, String> uriVariabels = new HashMap<String, String>();
        uriVariabels.put("siteId", site.getSiteId());
        Site remoteSite = (Site)client.getForObject("/ws/sites/{siteId}", uriVariabels, Site.class);
        return remoteSite;
    }

    private void checkSiteParam(Site site) {
        if (site == null) {
            logger.error((Object)"site is null");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{site.getServerUuid(), site.getSiteId()});
    }

    private ManagementServer queryRemoteServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)"uuid is empty.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        IManagementServerService service = (IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class);
        ManagementServer server = service.getServer(uuid);
        if (server == null) {
            logger.error((Object)"server not exist, uuid=%s", new Object[]{uuid});
            throw new LegoCheckedException(2117645L);
        }
        RestClient client = SiteUtil.initClient((ManagementServer)server);
        ManagementServer rmtServer = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
        return rmtServer;
    }

    @Override
    public void refreshSiteByBackTask(Site site, String userName) {
        logger.debug((Object)"refreshSiteByBackTask");
        BackTask bt = BackTaskUtil.buildBackTask((String)site.getName(), (String)"ism.srm.site.refresh.operationName", (String)userName, (String)"", null);
        RefreshSiteBackTask task = new RefreshSiteBackTask(site, bt, true);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public Site getSiteByBackupBucketOrPath(String bucketOrPath) {
        if (bucketOrPath.length() < 32) {
            logger.error((Object)"The path size less than %s", new Object[]{String.valueOf(32)});
            return null;
        }
        String projectId = bucketOrPath.substring(bucketOrPath.length() - 32);
        return this.getSitebyProjectId(projectId);
    }
}

