/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class UpgradeRemoteServerAndSubSiteTransaction {
    private static final Log logger = LogFactory.getInstance(UpgradeRemoteServerAndSubSiteTransaction.class);
    private ManagementServer replica;
    private String newUuid;

    public UpgradeRemoteServerAndSubSiteTransaction(ManagementServer replica, String newUuid) {
        this.replica = replica;
        this.newUuid = newUuid;
    }

    public void doInTransaction() {
        logger.info((Object)("change uuid info, from " + this.replica.getUuid() + " to " + this.newUuid), 90160758784000L);
        String siteSql = "update ti_site set serverUuid=? where serverUuid=? and siteType=1";
        String svrMoSql = "update t_managedobject set uuid=?, status=? where uuid=? and discriminator='ManagementServer'";
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Transaction transaction = session.beginTransaction();
            NativeQuery sqlQuery = session.createSQLQuery(siteSql);
            sqlQuery.setString(0, this.newUuid);
            sqlQuery.setString(1, this.replica.getUuid());
            int count = sqlQuery.executeUpdate();
            logger.info((Object)("Update remote site count is " + count), 90160758784000L);
            sqlQuery = session.createSQLQuery(svrMoSql);
            sqlQuery.setString(0, this.newUuid);
            sqlQuery.setInteger(1, 0);
            sqlQuery.setString(2, this.replica.getUuid());
            count = sqlQuery.executeUpdate();
            logger.info((Object)("Update remote server mo count is " + count), 90160758784000L);
            transaction.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("Upgrade remote server or site failed, moid=" + this.replica.getMoId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
                throw new LegoCheckedException(132416L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }
}

